FUNCTION rbiwt (
	x		/REAL/
	y		/REAL/
	start		/REAL,2/
	k		/REAL,1,6.0/
	tol		/REAL,1,.001/
	iter		/INT,1,20/
	)
STRUCTURE(
	coef		/REAL,2/
	resid		/LIKE(y)/
	wt		/REAL,LENGTH(x)/
	)
CHECK(LENGTH(x)==LENGTH(y),FATAL(X and Y not of equal length))
CHECK(LENGTH(x)>1,FATAL(Must have at least two points))
if(!MISSING(start))
	CHECK(LENGTH(start)>1,FATAL(Start must have two values))
else { start[1]=0.; start[2]=0. }	# (0,0) means use least squares start
call rbiwt(x,y,LENGTH(x),coef[1],coef[2],dummy,wt,start[1],start[2],k,iter,tol)
for(i=1;i<=LENGTH(x);i=i+1)
	resid[i]=y[i]-coef[1]-x[i]*coef[2]
RETURN(coef, resid, wt)
END
