FUNCTION seq(
	from	/ANY,NAOK,OPTIONAL/
	to	/REAL,OPTIONAL/
	by	/REAL,OPTIONAL/
	length	/INT,OPTIONAL/
	)

icase=0
if(!MISSING(from)) icase=icase+8
if(!MISSING(to)) icase=icase+4
if(!MISSING(by)) icase=icase+2
if(!MISSING(length)) {icase=icase+1; if(length<=0) FATAL(Argument length must be positive) }

if(!MISSING(from) & icase!=8) COERCE(from/REAL,NAFATAL/)

f=1; b=1; n= -1
switch(icase){	# get values for f,t,b
case 0,2,10:	FATAL(More information required to specify sequence)
case 1: t=length; n=length
case 3: b=by; t=(length-1)*b+1; n=length
case 4: t=to; b=sign(1.,t-1.)
case 5: t=to; b=(t-1)/float(max0(length-1,1)); n=length
case 6: t=to; b=by
case 7: t=to; b=by; f=t-b*float(length-1); n=length
case 8: t=LENGTH(from)
	if(t==1){ COERCE(from/REAL,NAFATAL/); t=from }
	b=sign(1.,t-1.)
case 9: f=from; t=length+f-1; n=length
case 11: f=from; b=by; t=f+float(length-1)*b; n=length
case 12: f=from; t=to; b=sign(1.,t-f)
case 13: f=from; t=to; b=(t-f)/float(max0(length-1,1)); n=length
case 14, 15: f=from; t=to; b=by
	}

define(`ISINT',`(abs($1)-aint(abs($1))<=PRECISION*abs($1))')	# test for integral value in real variable
if(abs(b)<1.-PRECISION) mode=REAL
else if(ISINT(b) & ISINT(f)) mode=INT
else mode=REAL
if(f==t) b=1.	# force non-zero value for b
if(mode==INT){
	ifrm=f+sign(.5,f); ib=b+sign(.5,b)	# from and by are known integers
	it=t+sign(5*PRECISION,t); if(n<0)n=(it-ifrm)/ib+1	# avoid increasing TO
	if(isign(1,it-ifrm)!=isign(1,ib))
		FATAL(Inconsistent values of from to and by)
	STRUCTURE(s/INT,n/)
	for(i=1; i<=n; i=i+1) s[i]=ifrm+(i-1)*ib
	}
else {
	if(b==0.) FATAL(Argument by cannot be zero)
	if(n<0)n=(t-f)/b+1.+50.*PRECISION
	if(sign(1.,t-f)!=sign(1.,b))
		FATAL(Inconsistent values of from to and by)
	STRUCTURE(s/REAL,n/)
	for(i=1; i<=n; i=i+1) s[i]=f+float(i-1)*b
	if((s[n]>t&b>0) | (s[n]<t&b<0)) s[n]=t	# force exact match at end
	}
RETURN(s)
END
