/* Special version for tek4662 - remembers amount of space
   available in buffer.  When that space used up, asks for
   buffer space (which is not responded to until space all free) */
ifelse(OpSys,ATT,
`#include <sys/ioctl.h>
#include <termio.h>',
`#include <sgtty.h>')
#include <signal.h>
#define LOWER5 037
F77_SUB(zoutrz,int=ichar,int=n)
{
	r_zoutrz(F_INTP(ichar),F_INTP(n));
}

static r_zoutrz(ichar,n)
long int ichar[],*n;
{
	static int buffree = 100;	/* some initial space required to turn on */
	extern long F77_COM(t46a)[];	/* common block - [13] is logical on/off */
	struct ifelse(OpSys,ATT,termio,sgttyb) iostr;
	char *buf,*calloc(),inbuf[10];
	int i,j,(*istat)(),oflags; char lflag, ovmin;
	j = *n;
	buf = calloc(j,sizeof(*buf));
	for(i=0; i<j; i++)
		buf[i]=ichar[i];
	for(i=0; buffree < j+10 && F77_COM(t46a)[13]==0; i++){	/* wait for enough room in buffer (only when on) */
		buffree = 100;  /* in case awakened by interrupt */
		if(i>0) { printf("\033CF\nWait on tek46\033CE\035\007"); sleep(30); }	/* at least 30 secs of stuff in buffer */
		istat=signal(SIGINT,SIG_IGN);	/* ignore interrupts */
ifelse(OpSys,ATT,
		`ioctl(0, TCGETA, &iostr);
		lflag = iostr.c_lflag; ovmin = iostr.c_cc[VMIN];
		iostr.c_lflag &= ~(ECHO |ICANON);
		iostr.c_cc[VMIN] = 1;  /* 1 char at a time */
		ioctl(0,TCSETAF, &iostr);',
		`ioctl(0, TIOCGETP, &iostr);
		oflags = iostr.sg_flags;
		iostr.sg_flags &= ~ECHO;
		iostr.sg_flags |= CBREAK;
		ioctl(0, TIOCSETP, &iostr);')
		printf("\033CO1\035\007");	/* request buffer space */
		fgets(inbuf,10,stdin);
ifelse(OpSys,ATT,
		`iostr.c_lflag = lflag; iostr.c_cc[VMIN] = ovmin;
		ioctl(0, TCSETA, &iostr);',
		`iostr.sg_flags = oflags;
		ioctl(0, TIOCSETP, &iostr);')
		istat=signal(SIGINT,istat);	/* allow interrupts */
		buffree = (inbuf[3] & LOWER5)*64 + (inbuf[5] & LOWER5)*2;
		}
	buffree -= j;
	write(2,buf,j);
	free(buf);
}
