INCLUDE(device)
#include <signal.h>
#include <stdio.h>

define(PACKET,100)

define(MAXREL,31)
define(INIT,'I')
define(RELLINE,'l')
define(LINE,'L')
define(RELMOVE,'m')
define(COLOR,'O')
define(MOVE,'M')
define(ERASE,'E')
define(CHR,'C')
define(RCHR,'S')
define(RECT,'R')
define(POLYGON,'G')
define(QUERY,'Q')
define(GRAPH_BEGIN,035)
define(GRAPH_END,037)
define(GRAPH_KILL,030)

extern float F77_COM(bgrp)[];			/* graphical parameters */
define(`am',`(F77_COM(bgrp)[($1)-1])')

int ask = 1;
int tojerq = 1;
int oldcol = 999, oldx = -9999, oldy = -9999;

F77_SUB(zparmz,real=par,int=n)
{
	r_zparmz(F_REALP(par),F_INTP(n));
}

static r_zparmz(par,n)
float par[]; long *n;
{
	int i;
	for(i=1; i<=39; i++)
		am(i) = 0.0;
	am(20) = 9.;	/* char size in rasters */
	am(21) = 16.;
	am(22) = 0.+5.;	/* min x raster */
	am(23) = 800.-5.;
	am(24) = 0.+3;	/* min y raster */
	am(25) = 640.-3;
	am(26) = 0.;	/* char addressing offset */
	am(27) = .75;
	am(28) = .01;	/* raster size in inches */
	am(29) = .01;
	am(30) = BLIT;
	am(31) = 1;	/* allow char rotation */
	am(1) = 1.;	/* allow char size change */
	blopen(par,n);
}

blopen(par,n)
float par[]; long *n;
{
	char cmd[100];			/* 32ld cmd to be */
	;

	if(*n>=1) ask = par[0];
	if(*n>=2 && par[1]>0){	/* load the driver */
undefine(`SHOME')
		sprintf(cmd,"cd %s/cmd ; %s/bin/dmdld Sterm.630",
			getenv("SHOME"),getenv("DMD"));
		system(cmd);
	}
	/* issue INIT command to driver to receive coordinates */
	echo_off();
	graphic(INIT); F77_CALL(zflshz);
	scanf("%f %f %f %f",&am(22), &am(24), &am(23), &am(25));
	while(getchar()!='\n');	/* skip newline */
	echo_on();
}

static char
	buf[PACKET],		/* storage for a packet of data */
	*p = &buf[0]		/* free position in buf */
;


xysc(xa, ya)
int xa, ya;
{
	int yi;
	yi = (int) F77_COM(bgrp)[24] - ya + F77_COM(bgrp)[23];
	graphic((xa&037) | 0100);
	graphic(((xa >> 5) & 037) | 0100);
	graphic((yi&037) | 0100);
	graphic(((yi >> 5) & 037) | 0100);
}

xyshort(xa, ya, op)
char op; int xa, ya;
{
	int xi,yi;
	if(abs(xa-oldx)>MAXREL || abs(ya-oldy)>MAXREL) return(0);
	xi = xa - oldx + MAXREL;
	yi = - (ya - oldy) + MAXREL;
	graphic(op);
	graphic((xi&077) | 0100);
	graphic((yi&077) | 0100);
	oldx = xa; oldy = ya;
	return(1);
}

static flush()
{
	write(tojerq, &buf[0], p - &buf[0]);
	p = &buf[0];
}

static int opened = 0;

graphic(c)
char c;
{
	if(!opened++) *p++ = GRAPH_BEGIN;
	*p++ = c;
	if (p == &buf[PACKET])
		flush();
}

F77_SUB(zlinez,int=ix,int=iy)
{
	r_zlinez(F_INTP(ix),F_INTP(iy));
}

static r_zlinez(ix,iy)
long int *ix,*iy;
{
	newcolor();
	if(xyshort((int)*ix,(int)*iy,RELLINE)) return;
	graphic(LINE);
	xysc((int) *ix, (int) *iy);
	oldx = *ix; oldy = *iy;
}

F77_SUB(zptchz,char=ich,real=crot)
{
	r_zptchz(F_CHARP(ich),F_REALP(crot));
}

#include <math.h>
static r_zptchz(ich,crot)
char *ich; float *crot;
{
	double fabs();
	if(fabs(*crot)<45.) { 
		graphic(CHR);
		oldx += am(20);
		}
	else {
		graphic(RCHR);
		oldy += am(20);
		}
	graphic(*ich);
}

F77_SUB(zseekz,int=ix,int=iy)
{
	r_zseekz(F_INTP(ix),F_INTP(iy));
}

static r_zseekz(ix,iy)
long int *ix,*iy;
{
	newcolor();
	if(*ix==oldx && *iy==oldy) return;
	if(xyshort((int)*ix,(int)*iy,RELMOVE)) return;
	graphic(MOVE);
	xysc((int) *ix, (int) *iy);
	oldx = *ix; oldy = *iy;
}

F77_SUB(zejecz)
{
	extern long F77_COM(reshap);
	long x1,y1,x2,y2;
	if(ask){
		fprintf(stderr,"GO? ");
		while( getchar()!='\n' ) ;	/* ignore reply */
	}
	graphic(ERASE);
	F77_CALL(zflshz);
	echo_off();
	scanf("%ld %ld %ld %ld",&x1,&y1,&x2,&y2);
	while( getchar()!='\n' ) ;	/* ignore reply */
	echo_on();
	if(x1!=am(22) || y1!=am(24) || x2!=am(23) || y2!=am(25)){
		oldx = oldy = -9999;
		F77_COM(reshap) = 1;
		F77_CALL(zzdevz,int=&x1,int=&x2,int=&y1,int=&y2);
	}

}


F77_SUB(zflshz)
{
	if(opened) { graphic(GRAPH_END); opened=0; }
	flush();
}

F77_SUB(zintrz)
{
	int i;
	if(opened) {
		for(i=0; i<10; i++)
			graphic(GRAPH_END);
		opened=0;
		}
	flush();
	oldx = -9999; oldy = -9999;
}

F77_SUB(zwrapz)
{
	graphic(GRAPH_KILL);
	flush();
}

F77_SUB(zquxyz,int=x,int=y,int=flag)
{
	r_zquxyz(F_INTP(x),F_INTP(y),F_INTP(flag));
}

static r_zquxyz(x,y,flag)
long *x,*y,*flag;
{
	echo_off();
	graphic(QUERY); F77_CALL(zflshz);
	scanf("%D",x);
	scanf("%D",y);
	scanf("%D",flag);
	while(getchar()!='\n');	/* eat newline */
	*y = (int)F77_COM(bgrp)[24] - *y + (int)F77_COM(bgrp)[23];
	if((*flag)>4) *flag = -1;
	echo_on();
}

newcolor(col)
int col;
{
	int which;
	which = (int)(F77_COM(bgrp)[9]) ;
	if(which==oldcol) return;
	graphic(COLOR);
	graphic(which + ' ');
	oldcol = which;
}

F77_SUB(zpolyz,real=x,real=y,int=n)
{
	r_zpolyz(F_REALP(x),F_REALP(y),F_INTP(n));
}

static r_zpolyz(x,y,n)
float x[],y[]; long *n;
{
	int i,which; long l1,l2; char *p;
	if(*n<3){
		F77_CALL(zflshz);
		F77_CALL(zerrpz,char="zpolyz",char="Needs at least 3 points");
		return;
		}
	newcolor();
	graphic(POLYGON);
	putout(*n);
	for(i=0; i<*n; i++){
		l1 = F77_COM(bgrp)[35]+F77_COM(bgrp)[36]*x[i];
		l2 = F77_COM(bgrp)[23]+F77_COM(bgrp)[24]-F77_COM(bgrp)[37]-F77_COM(bgrp)[38]*y[i];
		putout(l1); putout(l2);
	}
	F77_CALL(zflshz);
}

static putout(l)
long l;
{
	graphic((l & 037)|0100);
	graphic(((l>>5) & 037)|0100);
	graphic(((l>>10) & 077)|0100);
}
