#include <dmd.h>
#include <font.h>
#ifdef DMD630
#include <msgs.h>
#include <object.h>
#include <5620.h>
#undef defont
#undef CW
#undef NS
#define defont		largefont
#define	CW	11	/* width of a character */
#define	NS	16	/* newline size; height of a character */
#else
#include <setup.h>
#endif

#define stipple(r)	rectf(&display, r, F_CLR)
#define	XMARGIN	3	/* inset from border of layer */
#define	YMARGIN	3
#define MAX_TOKENS 5
#define P_NULL		0
#define P_ESC		1
#define P_BRACKET	2
#define P_TOKEN		4
#define UNDERSCORE	1
#define REVVIDEO	2
#define INSERT		4
#ifndef SCRLOCKREQD
#define SCRLOCKREQD	0
#endif
#ifndef SCR_LOCK
#define SCR_LOCK	BLOCKED
#endif

Point	  pt();
Rectangle RECT();

int	x, y;	/* character positions */
int	xxmax, yymax;
long 	state;
long	parsestate;	/* what I am parsing for next */
int	parsenumtokens;
int	parseflag;
int	parsetoken[MAX_TOKENS];
int	saved_x, saved_y;
long	saved_state;

main()
{
	int c;
#ifdef DMD630
	Point ctob();
	Point btoc();
#endif
	state = 0;
	parsestate = P_NULL;
	request(RCV|SCRLOCKREQD);
	reshaped();
#ifdef DMD630
	P->ctob = ctob;
	P->btoc = btoc;
	cache((char *)0, 0);
#endif
	for(;;)
	{
		if(P->state&RESHAPED)
			if(P->state&MOVED)
				moved();
			else
				reshaped();
		if((own()&RCV) && !(P->state&SCR_LOCK))
		{
			curse();
			do	dochar(rcvchar());
			while((own()&RCV) && !(P->state&SCR_LOCK));
			curse();
		}
		wait(CPU);
	}
}

reshaped()
{
	x = y = 0;
	xxmax = (Drect.corner.x-Drect.origin.x-2*XMARGIN)/CW-1;
	yymax = (Drect.corner.y-Drect.origin.y-2*YMARGIN)/NS-1;
	curse();
	P->state &= ~(RESHAPED);
}

moved()
{
	P->state &= ~(RESHAPED|MOVED);
}

dochar(c)
int c;
{
	if(!(parsestate&P_TOKEN) || token(c))
		switch(parsestate) {
			case P_NULL:	/* normal state */
					parsenull(c);
					break;
			case P_ESC:	/* received ESC char */
					parseesc(c);
					break;
			case P_BRACKET:	/* received ESC [ */
					parsebracket(c);
					break;
			default:	/* ??? bug */
					parsestate = P_NULL;
		}
	if(x > xxmax) {
		x = 0;
		newline();
	} else if(x < 0)
		x = 0;
	if(y > yymax)
		y = yymax;
	else if(y < 0)
		y = 0;
}

parsenull(c)
char c;
{
	switch(c) {
		case '\035':	/* graphics mode gs */	/* RAB */
			dographics();			/* RAB */
			break;				/* RAB */

		case '\007':		/* bell */
			ringbell();
			break;

		case '\t':		/* tab modulo 8 */
			x = (x|7)+1;
			break;

		case '\033':
			parsestate = P_ESC;
			return;

		case '\b':		/* backspace */
			--x;
			break;

		case '\n':		/* linefeed */
			newline();
			break;

		case '\r':		/* carriage return */
			x = 0;
			break;

		default:		/* ordinary char */
			if(state&INSERT)
				lscroll(Rect(x,y,xxmax,y+1), Pt(x+1,y));
			writec(c);
			x++;
			/* jdi fix */
			if(x>=80)
			{
				x=0;
				newline();
			}
			break;
	}
}

parseesc(c)
char c;
{
	int i;

	switch(c) {
		case 'c': /* reset window */
			stipple(Drect);
			x = y = state = 0;
			saved_x = saved_y = saved_state = 0;
			break;

		case '7': /* save state */
			saved_x = x;
			saved_y = y;
			saved_state = state;
			break;

		case '8': /* restore state */
			x = saved_x;
			if(x > xxmax) x = xxmax;
			y = saved_y;
			if(y > yymax) y = yymax;
			state = saved_state & (UNDERSCORE|REVVIDEO);
			break;

		case 'D': /* index */
			newline();
			break;

		case 'M': /* reverse index */
			if(y == 0)
				lscroll(Rect(0,0,xxmax+1,yymax), Pt(0,1));
			else
				y--;

		case '\033':
			return;

		case '[':
			parsestate = P_BRACKET|P_TOKEN;
			parsenumtokens = 0;
			parseflag = 0;
			for(i=0;i<MAX_TOKENS;i++)
				parsetoken[i] = 0;
			return;

		default:
			break;
	}
	parsestate = P_NULL;
}

parsebracket(c)
char c;
{
	int token0, numtokens;
	int i,j;

	token0 = parsetoken[0];
	if(!token0)
		token0 = 1;
	numtokens = parsenumtokens;
	switch(c) {
		case '\033':
			parsestate = P_ESC;
			return;

		case 'Z': /* backtab */
			while(token0--)
				if(x&7)
					x &= ~7;
				else
					x -= 8;
			break;

		case 'A': /* up arrow */
			y -= token0;
			break;

		case 'B': /* down arrow */
			y += token0;

			break;

		case 'C': /* right arrow */
			x += token0;
			if(x > xxmax)
				x = xxmax;
			break;

		case 'D': /* left arrow */
			x -= token0;
			break;

		case 'K': /* clear line */
			switch(parsetoken[0]) {
				case 0: /* to EOL */
					i = x;
					j = xxmax;
					break;
				case 1: /* to cursor */
					i = 0;
					j = x;
					break;
				case 2: /* all */
					i = 0;
					j = xxmax;
					break;
				default:
					goto err;
			}
clrline:
			stipple(RECT(Rect(i,y,j+1,y+1)));
			break;

		case 'J': /* clear screen */
			switch(parsetoken[0]) {
				case 0: /* to EOS */
					stipple(RECT(Rect(0,y+1,xxmax+1,yymax+1)));
					i = x;
					j = xxmax;
					goto clrline;
				case 1: /* to cursor */
					stipple(RECT(Rect(0,0,xxmax+1,y)));
					i = 0;
					j = x;
					goto clrline;
				case 2: /* all */
					stipple(Drect);
					break;
				default:
					goto err;
			}

		case 'f':
		case 'H': /* cursor position */
			if(numtokens == 0)
				x = y = 0;
			else if(numtokens == 1)
				y = parsetoken[0] - 1;
			else if(numtokens == 2) {
				y = parsetoken[0] - 1;
				x = parsetoken[1] - 1;
				if(x > xxmax)
				x = xxmax;
			}
			break;

		case 'S': /* scroll up */
			i = token0 > yymax ? yymax+1 : token0;
			lscroll(Rect(0,i,xxmax+1,yymax+1), Pt(0,0));
			break;

		case 'T': /* scroll down */
			i = token0 > yymax ? 0 : yymax + 1 - token0;
			lscroll(Rect(0,0,xxmax+1,i), Pt(0,yymax+1-i));
			break;

		case 'm': /* char attribute */
			if(!numtokens)
				goto clrattr;
			for(i=0; i<numtokens; i++)
				switch(parsetoken[i]) {
					case 0: /* clear */
clrattr:
						state &= ~(UNDERSCORE|REVVIDEO);
						break;
					case 2:
					case 5:
					case 7: state |= REVVIDEO; break;
					case 4: state |= UNDERSCORE; break;
				}
			break;

		case '@': /* insert char */
			i = min(token0, xxmax + 1 - x);
			lscroll(Rect(x,y,xxmax+1-i,y+1), Pt(x+i,y));
			break;

		case 'P': /* delete char */
			i = min(token0, xxmax + 1 - x);
			lscroll(Rect(x+i,y,xxmax+1,y+1), Pt(x,y));
			break;

		case 'L': /* insert line */
			i = token0 > yymax ? 0 : yymax + 1 - token0;
/*jdi fix(on next lines)lscroll(Rect(0,y,xxmax+1,i), Pt(0,y+i)); */
			if(x<80)
			  lscroll(Rect(0,y,xxmax+1,i), Pt(0,y+token0));
			else
			  lscroll(Rect(0,y+1,xxmax+1,i),Pt(0,y+1+token0));
			break;

		case 'M': /* delete line */
			lscroll(Rect(0,y+token0,xxmax+1,yymax+1), Pt(0,y));
			break;

		case 'l': /* reset mode */
			if(token0 == 4)
				state &= ~INSERT;
			break;

		case 'h': /* set mode */
			if(token0 == 4)
				state |= INSERT;
			break;
	}

err:
	parsestate = P_NULL;
}

token(c)
char c;
{
	int semicolon;

	if(parsenumtokens >= MAX_TOKENS)
	{
		parsestate &= ~P_TOKEN;
		return(1);
	}
	if(c <= '9' && c >= '0')
	{
		parsetoken[parsenumtokens] = parsetoken[parsenumtokens]*10 + (c - '0');
		parseflag = 1;
	}
	else
	{
		semicolon = c == ';';
		if(parseflag || semicolon)
		{
			parseflag = semicolon;
			parsenumtokens++;
		}
		if(!semicolon || parsenumtokens >= MAX_TOKENS)
		{
			parsestate &= ~P_TOKEN;
			return(1);
		}
	}
	return(0);
}

lscroll(r,p)
Rectangle r;
Point p;
{
	clippt(&r.origin);
	clippt(&r.corner);
	clippt(&p);
	bitblt(&display, RECT(r), P->layer, pt(p), F_STORE);
	if(p.x == r.origin.x)
		if(p.y < r.origin.y)
/*jdi fix next line stipple(RECT(Rpt(Pt(p.x,r.corner.y-r.origin.y-p.y),
			   r.corner))); */
		    stipple(RECT(Rpt(Pt(p.x,r.corner.y-r.origin.y+p.y),
			   r.corner)));
		else
			stipple(RECT(Rpt(r.origin, Pt(r.corner.x, p.y))));
	else
		if(p.x < r.origin.x)
			stipple(RECT(Rpt(Pt(r.corner.x-r.origin.x+p.x, p.y),
			   r.corner)));
		else
			stipple(RECT(Rpt(r.origin,Pt(p.x,r.corner.y))));
}

clippt(p)
Point *p;
{
	if(p->x<0)
		p->x = 0;
	else if(p->x>xxmax+1)
		p->x = xxmax+1;
	if(p->y<0)
		p->y = 0;
	else if(p->y>yymax+1)
		p->y = yymax+1;
}

writec(c)
char c;
{
	Fontchar *fp = defont.info + c % 128;
	Rectangle r;
	Point p;

	r.origin.x = fp->x;
	r.corner.x = (fp+1)->x;
	r.origin.y = 0;
	r.corner.y = defont.height;
	p = pt(x,y);
	bitblt(defont.bits, r, &display, p, F_STORE);
	if(state&UNDERSCORE)
	{
		segment(&display, Pt(p.x,p.y+defont.ascent), Pt(p.x+CW,
		   p.y+defont.ascent), F_STORE);
	}
	if(state&REVVIDEO)
		rectf(&display, Rpt(p, Pt(p.x+CW,p.y+NS)), F_XOR);
}



newline()
{
	if(y >= yymax) {
		scroll(1, yymax+1, 0, yymax);
		y = yymax;
	} else
	{
		y++;

/*jdi fix follows */ 
		if(y>=yymax)
		{
	    		lscroll(Rect(0,1,xxmax+1,yymax), Pt(0,0));
	    		y=yymax;
		}
	}
}

curse()
{
	rectf(&display, Rpt(pt(x,y), add(pt(Pt(x,y)), Pt(CW,NS))), F_XOR);
}


Point
pt(p)
Point p;
{
	return add(Drect.origin, Pt(p.x*CW+XMARGIN, p.y*NS+YMARGIN));
}

Rectangle
RECT(r)
Rectangle r;
{
	r.origin = pt(r.origin);
	r.corner = pt(r.corner);
	return r;
}


scroll(sy, ly, dy, cy)	/* source, limit, dest, which line to clear */
{
	bitblt(&display, Rpt(pt(0, sy), pt(xxmax+1, ly)),
	    &display, pt(0, dy), F_STORE);
	stipple(Rpt(pt(0, cy), pt(xxmax+1, cy+1)));
}

#ifdef DMD630

Point
ctob(x,y,p)
int x, y;
Proc *p;
{
	Point q;

	if(x==0) x = 80;
	if(y==0) y = 24;
	q.x = XMARGIN * 2 + x * CW + INSET * 2;
	q.y = YMARGIN * 2 + y * NS + INSET * 2;
	return q;
}

Point
btoc(x,y,p)
int x, y;
Proc *p;
{
	Point q;

	q.x = (x - 2 * XMARGIN - 2 * INSET) / CW;
	q.y = (y - 2 * YMARGIN - 2 * INSET) / NS;
	return q;
}

#endif
