subroutine xysort(x,nx,y,ny,ord,no)
real x(nx),y(ny); integer nx,ny,ord(no),no
integer start,jnext,i,j,k
real curx,cury,curd,xmin,xmax,ymin,ymax,scale
logical doord

doord = no>0
i = 0
for(j=1; j<=nx; j=j+1){	# get rid of NAs
	if(NA(x(j))|NA(y(j))) next
	i=i+1
	x(i)=x(j); y(i)=y(j)
	xmax = amax1(xmax, x(i)); xmin = amin1(xmin, x(i))
	ymax = amax1(ymax, y(i)); ymin = amin1(ymin, y(i))
	if(doord) ord(i) = j
	}

if(i<=0) FATAL(No data points without missing values)
nx=i; ny=i; if(doord) no=i

# greedy algorithm starting from first point

# scale factor converts y to x units (assumes square plot xmin,xmax,ymin,ymax)
if(ymax!=ymin && xmax!=xmin) scale = (xmax-xmin)/(ymax-ymin)
else scale = 1	# even if one coord is degenerate, other will be used

curx = x(1); cury = y(1)
for(start=2; start<nx; start=start+1){	# find next point
	curd = BIG
	for(j=start; j<=nx; j=j+1){	# find min distance
		d = abs(x(j)-curx)
		if(d>=curd) next
		d = d + abs(y(j)-cury)*scale
		if(d>=curd) next
		jnext = j
		curd = d
		}
	# interchange found point with point at start
	curx = x(jnext); x(jnext) = x(start); x(start)=curx
	cury = y(jnext); y(jnext) = y(start); y(start)=cury
	if(doord) {
		k = ord(jnext); ord(jnext) = ord(start); ord(start) = k
		}
	}

return
end
