ROUTINE(hatch,		shade in polygon)
subroutine hatch(x,y,n,space,angle)
integer n; real x(n),y(n),space,angle
INCLUDE(stack,graphics)

POINTER px,py,pxhit,pyhit,jstkgt
real xmin,xmax,ymin,ymax,xin,yin

px=jstkgt(4*(n+1),REAL)
py=px+n+1; pxhit=py+n+1; pyhit=pxhit+n+1

QUERY( pin(xin,yin), usr(xmin,xmax,ymin,ymax) )
SPECIFY( usr(0.,xin,0.,yin) )
xin=xin/(xmax-xmin); yin=yin/(ymax-ymin)
for(i=0; i<n; i=i+1){	# transform to inches
	rs(px+i)=(x(i+1)-xmin)*xin
	rs(py+i)=(y(i+1)-ymin)*yin
	}
rs(px+n)=rs(px); rs(py+n)=rs(py)	# close the polygon

call hatch2(rs(px),rs(py),n+1,space,angle,rs(pxhit),rs(pyhit))

SPECIFY( usr(xmin,xmax,ymin,ymax) )	# reset user coords
call jstkrl(1)
return
end



subroutine hatch2(xl,yl,npts,space,angle,xhit,yhit)
# routine to cross-hatch the closed figure or semi-closed figure passed. 
# lines of space spacing and at slope angle (in degrees) will be drawn over the entire figure.
# believes that user coords are in inches and that xl,yl produce
# a closed polygon, i.e. xl(npts)==xl(1), yl(npts)==yl(1).
# also requires scratch xhit and yhit that should be of size npts.
real xl(npts),yl(npts),xhit(npts),yhit(npts)
logical vertic,pass
INCLUDE(print)
data tol/0.0001/
# find the cross-hatching angle corrected to 0-180
ta = amod(angle,180.)
if (ta<0.) ta = ta+180.
# find a bounding rectangle containing the entire figure
call rangev(xl,npts,aleft,aright)
call rangev(yl,npts,alow,ahigh)
# develop the prototype line for hatching tests
ta = ta*3.1415927/180.
size = abs(space)
if (size==0.) return
xat = aleft
dx = 0.
if (abs(ta)>=.005&&abs(ta)<=3.14) dx = -sign(size/sin(ta),cos(ta))
dy = 0.
if (abs(ta-1.5707)>=.005) dy = abs(size/cos(ta))
if (dx<0.) xat = aright
# save parameters so that termination may be tested
yat = alow
yst = alow
stp = (aright-aleft)+(ahigh-alow)
xoth = xat
if (dx==0.) xoth = aright+aleft-xoth
xst = xoth
# start the first hatching line 1/2 space from bounding
xat = xat-dx/2.
if (dy==0.) yat = ahigh
yat = yat-dy/2.
# each hatching line has ends (xat,alow) and (xoth,yat)
# save first end for alternate plotter sweeps
xold = xat+dx
yold = alow
pass = FALSE
# are the hatching lines to be vertical?
vertic = TRUE
if (dy!=0.) {	# find the slope of the original hatching line
	slope1 = tan(ta)
	if (abs(slope1)<.005) slope1 = 0.
	vertic = FALSE
	}
repeat {	# major loop to hatch the figure
	xat = xat+dx
	yat = yat+dy
	nhit = 0
	if (!vertic) const1 = yat-slope1*xoth
	do i = 2,npts {	# test for hits upon each segment of the perimeter
		slope2 = xl(i)-xl(i-1)
		if (abs(slope2)>tol) {	# perimeter line non-vertical, find slope and offset
			slope2 = (yl(i)-yl(i-1))/slope2
			if (abs(slope2)<tol) slope2 = 0.
			const2 = yl(i)-slope2*xl(i)
			if (vertic) {	# the hatch line is vertical, perimeter is not, find hit
				x = xat
				if (sign(1.,(xl(i)-x))==sign(1.,(xl(i-1)-x))) next
				y = slope2*xat+const2
				}
			else {
# both lines are non-vertical, find the intersection
# do the lines have same or complementary slopes
				if (abs(slope1-slope2)<tol) next
# find the x and y of the intersection
				x = (const2-const1)/(slope1-slope2)
				if(x<amin1(xl(i),xl(i-1))-tol || x>amax1(xl(i),xl(i-1))+tol) next
				y = slope1*x+const1
				}
			}
		else {	# perimeter line segment is vertical, test test line
			if (vertic) next
# hatching line not vertical, find intersection
# eliminate duplicate points from contention
			if (abs(yl(i)-yl(i-1))<tol) next
			x = xl(i)
			y = slope1*x+const1
			}
# is this strike within the bounds of the perimeter line?
		if (abs(yl(i)-yl(i-1))>=tol)
			if(y<amin1(yl(i),yl(i-1))-tol || y>amax1(yl(i),yl(i-1))+tol) next
		if (nhit>=1)
			if (abs(xhit(nhit)-x)<tol&&abs(yhit(nhit)-y)<tol){
# EPRINT("Duplicate hits for i=",I(i)," xy=",R(x),R(y))
nnhit=nhit
				if(vertic){	# if both segments on same side of hatch line, eliminate both intersections
					if(sign(1.,xl(i-1)-xl(i-2))==sign(1.,xl(i-1)-xl(i))) nhit=nhit-1
					}
				else {
					t1=yl(i)-yl(i-1)-slope1*(xl(i)-xl(i-1))
					t2=yl(i-2)-yl(i-1)-slope1*(xl(i-2)-xl(i-1))
					if(sign(1.,t1)==sign(1.,t2)) nhit=nhit-1
					}
# if(nnhit!=nhit) EPRINT("Both points eliminated")
				next	# eliminate one duplicate at corner
				}
# the point is within all limits, add to the strike list
		nhit = nhit+1
		xhit(nhit) = x
		yhit(nhit) = y
		}
# the perimeter test complete, how many hits?
	pass = !pass
	if (nhit>=2) {	# order the hits by distance from end point
		aright = BIG
		do i = 1,nhit {	# find the closest point to last plotted point
			ahigh = abs(xold-xhit(i))+abs(yold-yhit(i))
			if (ahigh<=aright) {	# save pointer to the closest link
				aright = ahigh
				j = i
				}
			}
# reorder the links so first point is closest link
		ahigh = xhit(1)
		xhit(1) = xhit(j)
		xhit(j) = ahigh
		ahigh = yhit(1)
		yhit(1) = yhit(j)
		yhit(j) = ahigh
		k = nhit-2
		if (k>=1)
			do i = 1,k {
				aright = abs(xhit(i+1)-xhit(i))+abs(yhit(i+1)-yhit(i))
				l = i+2
				do j = l,nhit {
					aleft = abs(xhit(j)-xhit(i))+abs(yhit(j)-yhit(i))
					if (aleft<=aright) {
						aright = aleft
						ahigh = xhit(i+1)
						xhit(i+1) = xhit(j)
						xhit(j) = ahigh
						ahigh = yhit(i+1)
						yhit(i+1) = yhit(j)
						yhit(j) = ahigh
						}
					}
				}
		if (mod(nhit,2)!=0) nhit = nhit-1
		do i = 1,nhit,2	# plot the segments in pairs
			call linesz(xhit(i),yhit(i),2)
# find the end point for next sweep of the plotter
		if (pass) {
			xold = xoth
			yold = yat+dy
			}
		else {
			xold = xat+dx
			yold = alow
			if (dx==0.) yold = yat+dy
			}
		}
	 } until (nhit==0 &  (abs(xat-xst)+abs(yat-yst)>=stp-0.0005))
# until the total rectangle been effectively cross-hatched
return
end



