SUPPORT(prtmt2,		inner level of print matrix - called by prtmas)
subroutine prtmt2(vx,mode,n,p,rowlab,nrlab,collab,nclab,matype,quotes,rowwid,colwid,p1,p2,p3)
POINTER vx,rowlab(1),collab(1); logical quotes
integer n,p,rowwid(1),colwid(1),nrlab,nclab,p1(1),p2(1),p3(1),matype
INCLUDE(struct, stack,print,option,io)
integer rowmax,i,j,j1,j2,ltotal,nsplft,nsprgt,mode,maxcol,n1,icol
call rclab(rowlab,rowwid,min0(nrlab,n),TRUE)	#set up row, column labels & widths
call rclab(collab,colwid,min0(nclab,p),FALSE)
rowmax=0; for(i=1;i<=min0(nrlab,n);i=i+1)rowmax=max0(rowmax,rowwid(i)+1)
switch(matype){
case FULL_MATRIX: maxcol=p; j1=0; n1=n
case LOWER_MATRIX: maxcol=p; j1=0; n1=n+1
case SUBDIAG_MATRIX: maxcol=p-1; j1=1; n1=n+1
	}
for(j=1;j<=maxcol;j=j+1) {	# correct format for each column
	call dtafmt(vx+j1,mode,j*n-j1,quotes,p1(j),p2(j),p3(j))
	j1=j1+n1
	}
for(j1=1; j1<=maxcol; j1=j2+1) {	# as many columns as will fit across the page
	ltotal=rowmax+1
	for(j=j1;j<=maxcol;j=j+1) {
		icol=mod(j-1,nclab)+1
		ltotal=ltotal+nspace+max0(colwid(icol),p1(j))
		if(ltotal>lwidth)break
		}
	j2=j-1	# ending column this pass
	if(j2<j1) FATAL(Can not fit even one column with row labels with current page width)
	ENCODE(SP(rowmax))
	for(j=j1; j<=j2; j=j+1) { # print column labels
		icol=mod(j-1,nclab)+1
		nsplft=max0(0,p1(j)-colwid(icol));nsprgt=nsplft/2;nsplft=nsplft-nsprgt #center label
		ENCODE(SP(nsplft+nspace),C(TEXT(collab(icol)),colwid(icol)),SP(nsprgt))
		}
	FPRINT(OUTFC)
	switch(matype){	# starting row
	case FULL_MATRIX: i=1
	case LOWER_MATRIX: i=j1
	case SUBDIAG_MATRIX: i=j1+1
		}
	for(; i<=n; i=i+1) {
		irow=mod(i-1,nrlab)+1
		ENCODE(C(TEXT(rowlab(irow)),rowwid(irow)),SP(rowmax-rowwid(irow)))
		ij=vx+(j1-1)*n+i-1 # i-th row, initially the j1-th column
		switch(matype){	# ending column
		case FULL_MATRIX: lim=j2
		case LOWER_MATRIX: lim=min0(j2,i)
		case SUBDIAG_MATRIX: lim=min0(j2,i-1)
			}
		for(j=j1;j<=lim;j=j+1) {
			icol=mod(j-1,nclab)+1
			ENCODE(SP(nspace+max0(0,colwid(icol)-p1(j))), V(mode,ij,p1(j),p2(j),p3(j)))
			ij=ij+n	# next column
			}
		FPRINT(OUTFC)
		}
	SKIP(OUTFC)
	}
return
end
