ROUTINE(snrm2,2-norm of row 1 of x array)
real function snrm2(n,x,incx)
integer n,incx
real x(incx,n)
integer nmax,nmax2,beta,iexp,j,emin
integer emax,t,max0
real s2mach,ax,abig,amed,asml
real b1,b2,s1,s2,eps,relerr
real overfl,rbig,sqrt,float,abs,sngl
real amin1,amax1
double precision dsml,dmed,dbig,dx
SAVE(b1,b2,s1,s2,relerr,overfl,nmax)
data nmax2/I1MACH(9)/
data beta/I1MACH(10)/,t/I1MACH(11)/,emin/I1MACH(12)/,emax/I1MACH(13)/
data rbig/R1MACH(2)/
data b1/0.0/
data b2/0.0/
data s1/0.0/
data s2/0.0/
data relerr/0.0/
data overfl/0.0/
data nmax/0/
# avoid all overflows and underflows
if(n<0)ERROR(negative value for n)
if(n==0) return(0.)
if(incx<=0)ERROR(INCX must be positive)
if (nmax<=0) { # first-time switch
	nmax = nmax2
	iexp = -((1-emin)/2)
# lower boundary of midrange
	b1 = s2mach(1.0,beta,iexp)
	iexp = (emax+1-t)/2
# upper boundary of midrange
	b2 = s2mach(1.0,beta,iexp)
	iexp = -((2-emin)/2)
# scaling factor for lower range
	s1 = s2mach(1.0,beta,iexp)
	iexp = (emax+t)/2
# scaling factor for upper range
	s2 = s2mach(1.0,beta,iexp)
	overfl = rbig/s2
	eps = s2mach(1.0,beta,1-t)
	relerr = sqrt(eps)
	abig = 1.0/eps-1.0
	if (float(nmax)>abig)
		nmax = abig
	if (emin>1-2*t||t+1>emax||t<max0(2,(6-beta)))
		ERROR(algorithm cannot be guaranteed on this machine  -- constants messed up)
	}
dsml = 0.0d0
dmed = 0.0d0
dbig = 0.0d0
do j = 1,n {
	ax = abs(x(1,j))
	dx = ax
	if (ax>b2)
		dbig = dbig+(dx/s2)**2
	else if (ax<=b1)
		dsml = dsml+(dx/s1)**2
	else
		dmed = dmed+dx**2
	}
if (dbig>0.0d0) {
	abig = sqrt(sngl(dbig))
	if (abig<=overfl) {
		abig = abig*s2
		amed = sqrt(sngl(dmed))
		}
	else return(rbig)
	}
else if (dsml<=0.0d0) 
	return( sqrt(sngl(dmed)) )
else if (dmed<=0.0d0) 
	return( sqrt(sngl(dsml))*s1 )
else {
	abig = sqrt(sngl(dmed))
	amed = sqrt(sngl(dsml))*s1
	}
asml = amin1(abig,amed)
abig = amax1(abig,amed)
if (asml>abig*relerr)
	return( abig*sqrt((asml/abig)**2+1.0) )
else
	return( abig )
end
