/* S device driver for Silicon Graphics IRIS 4D
*/

#include <stdio.h>
#include <device.h>
#include "S.h"
#include "device.h"
#include "gl.h"

/* number of local state variables to be retained by device */
#define NLOCAL 5

/* note that all high-level device routines get user coordinates */
/* may need to transform them to rasters for plotting */
/* user-to-raster and raster-to-user conversions */
#define Xorigin		(am(36))
#define Yorigin		(am(38))
#define Xscale		(am(37))
#define Yscale		(am(39))
#define UxR(x)		((Coord)((x) * Xscale + Xorigin))
#define UyR(y)		((Coord)((y) * Yscale + Yorigin))
#define RxU(x)		(((x) - Xorigin) / Xscale)
#define RyU(y)		(((y) - Yorigin) / Yscale)

/* definitions for the state variables */
#define ask ((long *)(cur_device->local_params))[0]
#define oldcolor ((long *)(cur_device->local_params))[1]
#define oldltype ((long *)(cur_device->local_params))[2]
#define oldrot ((long *)(cur_device->local_params))[3]
#define oldsize ((long *)(cur_device->local_params))[4]

/* defines that allow easy access of graphical parameters */
#define am(i)		(F77_COM(bgrp)[i-1])
#define Ltype		((int)am(8))
#define Color		((int)am(10))
#define Cex		(am(18))
#define notNew		(am(121))
extern float F77_COM(bgrp)[];

/* bit patterns for filled polygons */
static short pat1[16] = {0xffff, 0xffff, 0xffff, 0xffff,
			 0xffff, 0xffff, 0xffff, 0xffff,
			 0xffff, 0xffff, 0xffff, 0xffff,
			 0xffff, 0xffff, 0xffff, 0xffff};
static short pat2[16] = {0xaaaa, 0x5555, 0xaaaa, 0x5555,
			 0xaaaa, 0x5555, 0xaaaa, 0x5555,
			 0xaaaa, 0x5555, 0xaaaa, 0x5555,
			 0xaaaa, 0x5555, 0xaaaa, 0x5555};
static short pat3[16] = {0x1111, 0x4040, 0x1111, 0x0404,
			 0x1111, 0x4040, 0x1111, 0x0404,
			 0x1111, 0x4040, 0x1111, 0x0404,
			 0x1111, 0x4040, 0x1111, 0x0404};
static short pat4[16] = {0x7777, 0xeeee, 0xdddd, 0xbbbb,
			 0x7777, 0xeeee, 0xdddd, 0xbbbb,
			 0x7777, 0xeeee, 0xdddd, 0xbbbb,
			 0x7777, 0xeeee, 0xdddd, 0xbbbb};
static short pat5[16] = {0xffff, 0xffff, 0xffff, 0xffff,
			 0xffff, 0xffff, 0xffff, 0xffff,
			 0xffff, 0xffff, 0xffff, 0xffff,
			 0xffff, 0xffff, 0xffff, 0xffff};

/* declarations for routines in the device structure
 *	note that iris4d() is the only externally-called function
 *	all the rest are statics appearing in the device structure.
 */
vector *iris4d(),
	*F77_SUB(bpntsz)(), *F77_SUB(blinsz)(),
	*F77_SUB(btextz)(), *F77_SUB(bsegsz)(), *F77_SUB(brdpnz)();
static vector  *wrap(), *flush(), *signalled(),
	*doclear(), *seek(), *point(), *line(), *getxy(), *polygon(), *mymenu();

/* structure that describes the device and its functions */
static device d_iris4d = {
			/* leave these alone */
	FALSE,				/* active flag */
	0,				/* index in list of devices */
	(float *)NULL,			/* copy of parameter array */
	NLOCAL,				/* number of local parameters */
	(char *)NULL,			/* slot for the local parameters */
			/* functions performed by driver */
	{		/* <R> required <O> optional */
		iris4d,			/* initialize <R> */
		wrap,			/* wrap up <R> */
		flush,			/* flush <R> */
		signalled,		/* caught signal <R> */
			/* these functions deal with sequences of points,
				lines, segments, etc., and can be
				written specially for this device or 
				can be the parenthesized pre-defined
				functions that call lower-level seek,
				line, character, etc functions */
		F77_SUB(bpntsz),	/* points <R> (bpntsz) */
		F77_SUB(blinsz),	/* lines <R> (blinsz) */
		polygon,	 	/* polygon <R> (bpolyz) */
		F77_SUB(btextz),	/* text <R> (btextz) */
		F77_SUB(bsegsz),	/* segments <R> (bsegsz) */
		doclear,			/* clear <R> */
		F77_SUB(brdpnz),	/* graphic input <R> (brdpnz) */
		mymenu,			/* menu <O> */
		NULL,			/* hook <O> */
			/* these low-level functions must be supplied only if
				bpntsz, blinsz, bsegsz, btextz, brdpnz are
				used above */
		seek,			/* seek <O> (low level) */
		point,			/* point <O> (low level) */
		line,			/* line <O> (low level) */
		NULL,			/* length of string <O> (ignore this) */
		getxy,			/* input <O> (low level) */
	}
};

FILE *outfile;
long oldx,oldy;
long win;

vector
*iris4d(a_ask,a_file,pref_left,pref_width,pref_bottom,pref_height)
long *a_ask, *pref_left, *pref_width, *pref_bottom, *pref_height;
char **a_file;
{
	device *d, *new_device();
	int i;

	/* initialize device structure */
	d = new_device(&d_iris4d, 0L);
	set_device(d->which);
	foreground();
	if(*pref_left>=0 && *pref_left <=1280 && *pref_width>0 && *pref_bottom>=0 && *pref_bottom <=1024 && *pref_height>0) 
		prefposition(*pref_left, *pref_width, *pref_bottom, *pref_height);
	win = winopen("S Graphics");
	minsize(0,0);
	winconstraints();
	getsize(&oldx,&oldy);
	qdevice(REDRAW);

	for(i=1; i<=39; i++)
		am(i) = 0.0;
	am(20) = strwidth(" ");	/* char size (x) in rasters */
	am(21) = getheight();	/* char size (y) in rasters */
	am(22) = 0;	/* minimum x raster coordinate */
	am(24) = 0;	/* minimum y raster coordinate */
	am(23) = oldx;	/* maximum x raster coordinate */
	am(25) = oldy;	/* maximum y raster coordinate */
	am(26) = .3;	/* char addressing offset x */
	am(27) = .35;	/* char addressing offset y */
	am(28) = .001;	/* x raster size in inches */
	am(29) = .001;	/* y raster size in inches */
	am(30) = -2000;	/* arbitrary negative device number (device.h) */
	/* am(31) = 1;	/* allow char rotation */
	am(1)  = 2.;	/* allow char size change */

	ask = *a_ask;	/* initialize local variables */

	if(**a_file){	/* no interaction allowed if output to file */
		outfile = fopen(*a_file,"a");
		if(outfile == NULL) Recover("Cannot open file", S_void);
		ask = 0;
		}
	else outfile = stdout;

	checkreshape();
	color(BLACK);
	clear();

	deflinestyle(1,0xFFFF);
	deflinestyle(2,0x3333);
	deflinestyle(3,0x7777);
	deflinestyle(4,0x0F0F);
	deflinestyle(5,0x6F6F);
	defpattern(1, 16, pat1);
	defpattern(2, 16, pat2);
	defpattern(3, 16, pat3);
	defpattern(4, 16, pat4);
	defpattern(5, 16, pat5);

	/* these values for the old parameter values ensure
		that the parameters will be set first time around */
	oldcolor = oldltype = oldrot = oldsize = -1;
	F77_SUB(defltz)();	/* set default values for other parms */
	notNew = 1;	/* force erase on first real plotting */
	return(S_void);
}

/* this function is called to wrap up execution */
static vector *
wrap()
{
	if(outfile != stdout) fclose(outfile);
	winclose(win);
	return(S_void);
}


/* function executed when the device receives a signal (like an interrupt)
	its purpose is to make sure the device is reset to a consistent
	state when interrupted */
static vector *signalled()
{
	return(S_void);
}

/* draw a line segment */
static vector *line(x,y)
long *x,*y;
{
	draw2i(*x,*y);
	return(S_void);
}

/* put out a single character at current position */
static vector *point(ich,crot)
char *ich; float *crot;
{
	char buf[2];
	buf[1]='\0';
	/* change rotation angle if needed */
	if(*crot != oldrot){
		oldrot = *crot;
		}

	/* change character size if needed */
	if(Cex != oldsize){
		oldsize = Cex;
		}

	buf[0] = *ich;
	charstr(buf);
	return(S_void);
}

/* position the device at x,y coords
	this is also the place to check color and line style changes */

static vector *seek(x,y)
long *x,*y;
{
	int j, k;
	checkreshape();
	if(Color != oldcolor){
		color(Color);
		oldcolor = Color;
		}

	if(oldltype != Ltype){
		oldltype = Ltype;
		setlinestyle(Ltype%6);
		setpattern(Ltype%6);
		}

	cmov2i(*x,*y);
	move2i(*x,*y);
	return(S_void);
}

/* clear the graphic area */
static vector *doclear()
{
	checkreshape();
	if(ask){
		fprintf(stderr,"GO? ");
		fflush(stderr);
		while( getc(stdin)!='\n' ) ;	/* ignore reply */
		}
	color(BLACK); clear(); color(oldcolor>=0?oldcolor:WHITE);
	return(S_void);
}


/* called to make sure device is flushed and ready to accept
	text as well as graphic output */
static vector *flush()
{
	return(S_void);
}


/* read an x-y pair from the device, flag indicates whether
	read was successful or not (a negative value indicates
	no point given and generally terminates higher-level reads)
*/
static vector *getxy(x,y,flag)
long *x,*y,*flag;
{
	long i,xo,yo;
	getorigin(&xo,&yo);
	if(outfile!=stdout){
		/* non-interactive, should read from terminal */
		F77_SUB(bquxyz)(x,y,flag);
		return(S_void);
		}
	do; while(!getbutton(LEFTMOUSE));	/* wait for left mouse button */
	*x = getvaluator(MOUSEX)-xo;
	*y = getvaluator(MOUSEY)-yo;
	i = 0;
	do
		i |= getbutton(MIDDLEMOUSE);
	while(getbutton(LEFTMOUSE));	/* wait for no left mouse button */
	*flag = i?-1:0;
	return(S_void);
}

static vector *polygon(x,y,n)
float *x, *y;
int	*n;
{
	int i;

	if(*n > 255) return(F77_SUB(blinsz)(x,y,n));
	if(Color != oldcolor){
		color(Color);
		oldcolor = Color;
		}
	pmv2(UxR(x[0]),UyR(y[0]));
	for ( i = 1; i < *n; i++ ) {
		pdr2(UxR(x[i]),UyR(y[i]));
	}
	pclos();
	return(S_void);
}

static checkreshape()
{
	short dev,val;
	long zero = 0, xs, ys;
	while(qtest()){
		dev = qread(&val);
		if(dev==REDRAW){
			reshapeviewport();
			getsize(&xs,&ys);
			if(xs==oldx && ys==oldy) continue;
			oldx = xs; oldy = ys;
			color(BLACK); clear();
			color(oldcolor>=0?oldcolor:WHITE);
			ortho2(0.,(double)xs,0.,(double)ys);
			F77_SUB(zzdevz)(&zero,&xs,&zero,&ys);
			}
	}
}
static vector *mymenu(ent,arglist)
vector *ent, *arglist;
{
	vector *value;
	int dev,val;
	int n, i; long pup;
	UNUSED(ent);
	value = coevec(*(arglist->value.tree),ANY,TRUE,CHECK_IT);
	if(value==NULL_ENTRY) return(S_void);
	value = coevec(value,CHAR,TRUE,CHECK_IT);
	pup = newpup();

	for(i=0; i<value->length; i++)	/* the labels */
		addtopup(pup,value->value.Char[i]);

	qdevice(RIGHTMOUSE); /* necessary? */
	qreset(); /* necessary? */
	n = dopup(pup);

	/* do; while(!getbutton(RIGHTMOUSE));	/* wait for left mouse button */
	freepup(pup);
	if(n<0) n = 0;
	value=alcvec(INT,1L);
	*(value->value.Long) = n;
	return(value);
}
