#include <jerq.h>
#include <font.h>
#include "texture.h"
#ifdef mc68000
#define ringbell() (*((char*)(384*1024L+062)) = 2)
#endif
#ifdef MUXTERM
#define	kbdchar		Ukbdchar
#define	wait		Uwait
#define	sendchar	Usendchar
int windowproc();
struct Proc *newproc();
#include <msgs.h>
#include <layer.h>
#include <jerqproc.h>
#endif

Point PtCurrent;	/* current graphics position */
struct Proc *glayer = 0;
Bitmap *Slayer;
extern Font rotfont,odefont;

short xmn,xmx,ymn,ymx;
#undef	CW
#define	CW	9
short col = 0;
#define NBITMAPS 2
Bitmap *maps[NBITMAPS];

#define NMENUS 8
char **menus[NMENUS];


static Texture menucurs={
	0x0FF0, 0x0810, 0x0810, 0x0810, 0x0810, 0x0FF0, 0x0FF0, 0x0FF0, 
	0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0FF0,
};
static Texture deadmouse = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000C, 0x0082, 0x0441,
	0xFFE1, 0x5FF1, 0x3FFE, 0x17F0, 0x03E0, 0x0000, 0x0000, 0x0000,
};

dographics()
{
	Point pt, getpt(), getshort(), old_mxy, prev_mxy, offset, p1,p2,p3;
	register c; char s[2],**p,*getlab();
	Rectangle r;
	Menu labmenu;
	short x,y,mflag,getcoord(),i,from,to,mode,number,tick1,tick2,ntick,nl;
	for(;;){
		c = getchar();
		switch(c){
		case 'I':	/* initialize - return rectangle coords */
			for(i=1; i<NBITMAPS; i++)
				if(maps[i]){
					bfree(maps[i]);
					maps[i] = (Bitmap *) NULL;
					}
			for(i=0; i<NMENUS; i++)
				if(menus[i]){
					freemenu(menus[i]);
					menus[i] = (char **) NULL;
					}
#ifdef MUXTERM
			for(;;) {
				r=getrect3();
				cursswitch(&deadmouse);
				if(r.corner.x-r.origin.x<100 ||
				   r.corner.y-r.origin.y<40) continue;
				if(!(glayer=newproc(windowproc))) continue;
				glayer->rect=inset(r, 3);
				if(!(glayer->layer=newlayer(r))) continue;
				muxnewwind(glayer, C_NEW);
				upfront(glayer->layer);
				setrun(glayer);
				sleep(120);
				break;
				}
#else
			while( !(glayer=getproc()) ) {
				sleep(60);	/* wait for user action */
				cursswitch((Texture *)0);
				}
#endif
			Slayer = (Bitmap *)glayer->layer;
			cursswitch((Texture *)0);
			maps[0] = Slayer;
			rectf(Slayer, Slayer->rect, F_XOR); /* flash */
			sleep(20);
			rectf(Slayer, Slayer->rect, F_XOR);
			respond(xmn=Slayer->rect.origin.x+3);
			respond(ymn=Slayer->rect.origin.y+3);
			respond(xmx=Slayer->rect.corner.x-3);
			respond(ymx=Slayer->rect.corner.y-3);
			break;
		case '\035':	/* gs -- ignore */
			break;
		case '\030':	/* delete layer */
#ifdef MUXTERM
			delete(Slayer);
#endif
			break;
		case '\037':	/* us -- exit graphics */
			return;
		case 'P':	/* PRIM stuff */
			if(!glayer){ ringbell(); return; }
			doprim();
			return;
		case 'b':	/* Box cox display */
			if(!glayer){ ringbell(); return; }
			doboxcox();
			return;
		case 'X':	/* Scatter plot matrix stuff */
			if(!glayer){ ringbell(); return; }
			doscat();
			return;
		case 'D':	/* interactive iDentify */
			if(!glayer){ ringbell(); return; }
			doident();
			return;
		case 'n':	/* moving regression line */
			if(!glayer){ ringbell(); return; }
			doregn();
			return;
		case 'u': 	/* set menu */
			i = getcoord()%NMENUS;
			nl = getcoord();
			if(menus[i]) freemenu(menus[i]);
			p = menus[i] = (char **)alloc((nl+1) * sizeof(*p));
			for(i=0; i<nl; i++)
				*p++ = getlab();
			*p++ = NULL;
			return;
		case 'U': 	/* menu selection */
			i = getcoord()%NMENUS;
			nl = (getcoord()-1)%3 +1;
			if(!menus[i]) { respond(0); return; }
			cursswitch(&menucurs);
			do wait(MOUSE); while(button123()==0);
			labmenu.item = menus[i];
			i=menuhit(&labmenu, nl);
			cursswitch((Texture *)0);
			respond(i+1);
			return;
		case 'Q':	/* query coordinates */
			wait(MOUSE);
			ringbell();
			while (!button123());
			x = mouse.xy.x;
			y = mouse.xy.y;
			mflag = mouse.buttons;
			do 	/* collect extra button pushes while down */
				mflag |= mouse.buttons;
			while (button123());
			sleep(5);
			respond(x);
			respond(y);
			respond(mflag & 07);
			break;
		case 'G':	/* filled polyGon */
			dopoly();
			break;
		case 'O':	/* new color */
			col = getchar()-' ';
			break;
		case 'R':	/* filled rectangle */
			pt=getpt();
			texture( Slayer, Rpt(pt, getpt()), patterns+col, F_STORE);
			break;
		case 'c':	/* copy a bitmap */
			from = getchar()-' ';
			to = getchar()-' ';
			mode = getchar()-' ';
		/*	offset = sub(getpt(),Pt(512,512));
			bitblt(	maps[from], maps[from]->rect,
				maps[to], add(maps[to]->rect.origin,offset),
				(Code) mode); */
			bitblt(	maps[from], maps[from]->rect,
				maps[to], maps[to]->rect.origin,
				(Code) mode); 
			break;
		case 'N':	/* new bitmap */
			number = getchar()-' ';
			if(number && maps[number])
				bfree(maps[number]);
			p1 = getpt();
			p2 = getpt();
			if(p1.x==p2.x && p1.y==p2.y)
				Slayer = maps[number] = balloc(maps[0]->rect);
			else if(p1.x==p2.x || p1.y==p2.y)
				maps[number] = (Bitmap *) NULL;
			else
				Slayer = maps[number] = balloc(Rpt(p1,p2));
			if(!Slayer) Slayer = maps[0];
			break;
		case 'B':	/* blink */
			number = getchar()-' ';
			tick1 = getcoord();
			tick2 = getcoord();
			ntick = getcoord();
			for(i=0; !button123() && i<ntick; i++){
				bitblt(	maps[number], maps[number]->rect,
					maps[0], maps[0]->rect.origin,
					F_XOR); 
				nap(tick1);
				bitblt(	maps[number], maps[number]->rect,
					maps[0], maps[0]->rect.origin,
					F_XOR);
				nap(tick2);	
			}
			while(button123());
			break;
		case 's':	/* set bitmap */
			number = getchar()-' ';
			if(number>=NBITMAPS || number<0) number = 0;
			if(maps[number])
				Slayer = maps[number];
			else
				Slayer = maps[0];
			break;
		case 'r':	/* rubber band line */
			wait(MOUSE);
			ringbell();
			while (!button123());
			old_mxy = mouse.xy;
			do{
				prev_mxy = mouse.xy;
				segment(Slayer, old_mxy,prev_mxy,F_XOR);						nap(2);
				segment(Slayer, old_mxy,prev_mxy,F_XOR);
				}
			while (button123());									sleep(5);
			respond(old_mxy.x);
			respond(old_mxy.y);
			respond(prev_mxy.x);
			respond(prev_mxy.y);
			break;
		case 'T':	/* track */
			wait(MOUSE);
			number = getchar()-' ';
			p1 = getpt();
			p2 = getpt();
			if(p1.x == p2.x & p1.y == p2.y){
				p1 = maps[number]->rect.origin;
				p2 = maps[number]->rect.corner;
				}
			bitblt(maps[number],Rpt(p1,p2),
				maps[0],maps[0]->rect.origin,
				F_XOR);
			while(!button123());
			mflag = offset.x = offset.y = 0;
			p3 = mouse.xy;
			for(;;){
				bitblt(maps[number],Rpt(p1,p2),
					maps[0],
					add(maps[0]->rect.origin,offset),
					F_XOR);
				if(!button123()) break;
				mflag |= mouse.buttons;
				offset = sub(mouse.xy,p3);
				bitblt(maps[number],Rpt(p1,p2),
					maps[0],
					add(maps[0]->rect.origin,offset),
					F_XOR);
				}
			sleep(5);
			respond(offset.x);
			respond(offset.y);
			respond(mflag & 07);
			break;
		case 'q':	/* new query */
			mflag = getchar()-' ';
			mode = getchar()-' ';
			wait(MOUSE);
			ringbell();
			while (mouse.buttons==mflag);
			x = mouse.xy.x;
			y = mouse.xy.y;
			mflag = mouse.buttons;
			if(mode)
				do
					mflag |= mouse.buttons;
				while (button123());
			sleep(5);
			respond(x);
			respond(y);
			respond(mflag & 07);
			break;
		case 'C':	/* character */
			s[0] = getchar(); s[1] = '\0';
			string(&odefont, s, Slayer, PtCurrent, col<0?F_XOR:col==0?F_CLR:F_OR);
			PtCurrent.x += CW;
			break;
		case 'S':	/* sideways character */
			s[0] = getchar(); s[1] = '\0';
			PtCurrent.y -= CW;
			string(&rotfont, s, Slayer, PtCurrent, col<0?F_XOR:col==0?F_CLR:F_OR);
			break;
		case 'E':	/* erase graphic area */
			if(glayer->state & (RESHAPED|MOVED)){
				glayer->state &= ~(RESHAPED|MOVED);
				for(i=1; i<NBITMAPS; i++)
					if(maps[i]){
						bfree(maps[i]);
						maps[i] = (Bitmap *) NULL;
						}
				}
			maps[0] = Slayer = (Bitmap *)glayer->layer;
			rectf(Slayer, inset(Slayer->rect,3), F_CLR);
			respond(xmn=Slayer->rect.origin.x+3);
			respond(ymn=Slayer->rect.origin.y+3);
			respond(xmx=Slayer->rect.corner.x-3);
			respond(ymx=Slayer->rect.corner.y-3);
			break;
		case 'M':	/* move */
			PtCurrent = getpt();
			break;
		case 'm':	/* relative move */
			PtCurrent = add( getshort(), PtCurrent);
			break;
		case 'l':	/* relative line */
			pt = p1 = getshort();
			if(p1.x==0 && p1.y==0)
				p1.x = 1;
			segment(Slayer, PtCurrent, add(p1, PtCurrent),
				col<0?F_XOR:col==0?F_CLR:F_OR);
			PtCurrent = add( pt ,PtCurrent);
			break;
		case 'L':	/* line */
			pt = p1 = getpt();
			if(p1.x==PtCurrent.x && p1.y==PtCurrent.y)
				p1.x++;
			segment(Slayer, PtCurrent, p1, col<0?F_XOR:col==0?F_CLR:F_OR);
			PtCurrent = pt;
			break;
		default:	/* anything else -- beep error and exit */
			ringbell();
			return;
		}
	}
}

#include "rotate.h"
doprim()
{
	extern long previous;
	short i,c,axis,size,sign,xsign,ysign,zsign,ptsize;
	short *x,*y,*z,n,getcoord();
	n = getcoord();
	x = (short *)alloc(n* sizeof(*x));
	y = (short *)alloc(n* sizeof(*y));
	z = (short *)alloc(n* sizeof(*z));
	for(i=0; i<n; i++){
		x[i] = getcoord();
		y[i] = getcoord();
		z[i] = getcoord();
	}
	previous=0; axis = X_TO_Y; size=5; sign=xsign=ysign=zsign= -1; ptsize=4;
	for(;;){
		rotate(x, y, z, n, ymx-ymn, xmx-xmn, ymn, xmn, axis, sign, size, ptsize);
		sleep(1);
		if(own()&KBD){
			c=kbdchar();
			switch(c & 0x7f){
			case 'x': axis = Y_TO_Z; xsign = sign = -xsign; break;
			case 'y': axis = Z_TO_X; ysign = sign = -ysign; break;
			case 'z': axis = X_TO_Y; zsign = sign = -zsign; break;
			case '-': sign = -sign; break;
			case '>': size--; if(size<1) size = 1;  break;
			case '<': size++; if(size>7) size = 7;  break;
			case 'h': sign = sign!=0 ? 0 : 1; break;
			case 'l': ptsize++; if(ptsize>15) ptsize = 15;  break;
			case 'r': rectf(glayer->layer, inset(glayer->layer->rect,3), F_XOR);
				break;
			case 's': ptsize--; if(ptsize<2) ptsize = 2; break;
			case 'q': goto out;
			default: ringbell();
			}
		}
		sleep(2);
	}
out:
	rectf(glayer->layer, inset(glayer->layer->rect,3), F_CLR);
	free(x); free(y); free(z);
}

doscat()
{
	short *xyz,n,p,*status,getcoord(),i,nlabs,*limits;
	char **labs,**nams,*getlab(),*genlab();
	n = getcoord();
	p = getcoord();
	xyz = (short *)alloc((n*p) * sizeof(*xyz));
	status = (short *)alloc(n * sizeof(*status));
	nams = (char **)alloc(p * sizeof(*nams));
	limits = (short *)alloc((2*p) * sizeof(*limits));
	for(i=0; i<(n*p); i++)
		xyz[i] = getcoord();
	for(i=0; i<p; i++)	/* variable names */
		*(nams+i) = getlab();
	nlabs = getcoord();
	labs = (char **)alloc((n+1) * sizeof(*labs));
	if(nlabs) for(i=0; i<n; i++) *(labs+i) = getlab();
	else for(i=0; i<n; i++) *(labs+i) = genlab(i+1);
	*(labs+n) = NULL;
	scatmat(xyz, n, p, status, nams, labs, limits);
	free(xyz); free(status);
	for(i=0; i<p; i++) free(*(nams+i));
	free(nams);
	if(labs){
		for(i=0; i<nlabs; i++) free(*(labs+i));
		free(labs);
		}
	free(limits);
}

doident()
{
	short i;
	short *x,*y,*status,n,nl,getcoord(); char **label,*getlab();
	n = getcoord();
	x = (short *)alloc(n* sizeof(*x));
	y = (short *)alloc(n* sizeof(*y));
	status = (short *)alloc(n* sizeof(*status));
	for(i=0; i<n; i++){
		x[i] = getcoord();
		y[i] = getcoord();
		}
	nl = getcoord();	/* labels? */
	if(nl){
		label = (char **)alloc(nl * sizeof(*label));
		for(i=0; i<nl; i++)
			*(label+i)=getlab();
		}
	identify(x,y,n,label,nl,status);
	free(x); free(y); free(status);
	if(nl){
		for(i=0; i<nl; i++) free(*(label+i));
		free(label);
		}
}


short getcoord()
{
	short i;
	i = getchar() &037;
	i |= (getchar()&037) << 5;
	i |= (getchar()&077) << 10;
	return(i);
}


Point
getpt()
{
	Point p; 
	p.x = getchar() & 037;
	p.x |= (getchar()&037) << 5;
	p.y = getchar() & 037;
	p.y |= (getchar()&037) << 5;
	return(p);
}

Point
getshort()
{
	Point p; 
	p.x = (getchar() & 077)-31;
	p.y = (getchar() & 077)-31;
	return(p);
}


respond(i)
short i;
{
	char buf[10], *p; short j,sign;
	sign = i<0;
	if(sign) i = -i;
	p = buf+10;
	*--p = '\n'; j=1;
	do {
		*--p = i%10 + '0';
		i /= 10;
		j++;
	}
	while(i!=0);
	if(sign) { *--p = '-'; j++; }
	for(i=0; i<j; i++) sendchar(*p++);
}


char *
genlab(i)
short i;
{
	char buffer[10];
	char *pp;
	dtoc(buffer,i);
	pp = (char *)alloc(strlen(buffer)+1);
	strcpy(pp,buffer);
	return(pp);
}

char *
getlab()
{
	char buffer[100];
	char *p,*pp;
	p = &buffer[0];
	while(*(p++) = getchar());
	pp = (char *)alloc((short)(p-buffer));
	strcpy(pp,buffer);
	return(pp);
}

struct seg { short x, y, X, Y; char stat;} ;
typedef struct seg segS;
typedef struct seg * segP;


dopoly()
{
	segP sinp, sp;
	short i,x,y,prevx,prevy,firstx,firsty,n,getcoord(),colr;
	char c;
	if(col> 0) colr = (col - 1) % (sizeof(patterns)/sizeof(patterns[1])-1) + 1;
	else colr = 0;
	n = getcoord();
	sinp = (struct seg *) alloc(n*sizeof(struct seg));
	firstx = prevx = getcoord(); firsty = prevy = getcoord();
	sp = sinp;
	for(i=1; i<n; i++){
		x = getcoord(); y=getcoord();
		mkseg(sp++, prevx, prevy, x, y);
		prevx = x; prevy = y;
		}
	mkseg(sp, prevx, prevy, firstx, firsty);
	realfill(sinp, n, patterns+colr);
	free(sinp);
}

freemenu(q)
char **q;
{
	char **p;
	for(p=q; *p; p++) free(*p);
	free(q);
}

dtoc(outbuf,i)
char *outbuf; short i;
{
	char buf[10], *p; short j;
	p = buf + 10;
	j = 0;
	do {
		*--p = i%10 + '0';
		i /= 10;
		j++;
	}
	while(i!=0);
	for(i=0; i<j; i++)
		*outbuf++ = *p++;
	*outbuf = 0;
}

doboxcox()
{
	short n,nxp,nyp,lx,ly,nin,get10bit(),i,j;
	short *x,*y; char **xlab,**ylab,*buf;

	cursswitch(&deadmouse);
	n = get10bit();	/* number of points */
	nxp = get10bit();	/* number of x powers */
	nyp = get10bit();	/* number of y powers */

	nin = n*nxp;
	x = (short *)alloc(nin* sizeof(*x));
	for(i=0; i<nin; i++) x[i] = get10bit();

	nin = n*nyp;
	y = (short *)alloc(nin* sizeof(*y));
	for(i=0; i<nin; i++) y[i] = get10bit();

	lx = get10bit();	/* number of x labels */
	xlab = (char **)alloc((nxp+1)* sizeof(*xlab));
	buf = (char *)alloc(lx);
	xlab[0] = buf;
	j = 1;
	for(i=0; i<lx; i++) {
		*buf = getchar();
		if(*buf==0) xlab[j++] = buf+1;
		buf++;
		}

	ly = get10bit();	/* number of x labels */
	ylab = (char **)alloc((nyp+1)* sizeof(*ylab));
	buf = (char *)alloc(ly);
	ylab[0] = buf;
	j = 1;
	for(i=0; i<ly; i++) {
		*buf = getchar();
		if(*buf==0) ylab[j++] = buf+1;
		buf++;
		}
	cursswitch((Texture *) 0);
	boxinteract(x,y,n,nxp,xlab,nyp,ylab);

	free(xlab[0]); free(xlab);
	free(ylab[0]); free(ylab);
	free(x); free(y);
}

short get10bit()
{
	short i;
	i = getchar() &037;
	i |= (getchar()&037) << 5;
	return(i);
}

static doregn()
{
	short i;
	short *x,*y,n,getcoord();
	n = getcoord();
	x = (short *)alloc(n* sizeof(*x));
	y = (short *)alloc(n* sizeof(*y));
	for(i=0; i<n; i++){
		x[i] = getcoord();
		y[i] = getcoord();
		}
	regn(x,y,n);
	free(x); free(y);
}
