FUNCTION clorder(
	tree	/STR/
	x	/REAL/
	)
STATIC( real xleft,xright; integer left,right,nleft,nright )
STRUCTURE(
	merge	/INT,MATRIX,FROM(tree)/
	height	/REAL,FROM(tree)/
	order	/INT,FROM(tree)/
	)
n=LENGTH(height)
if(LENGTH(x)!=n+1) FATAL(Ordering vector must match number of items in tree)
STRUCTURE(
	sumx	/REAL,n/
	nx	/INT,n+1/
	)
for(i=1; i<=n; i=i+1){
	left=merge[i,1]; right=merge[i,2]
	if(left<0){ nleft=1; xleft=x[(-left)] }
	else{ nleft=nx[left]; xleft=sumx[left] }
	if(right<0){ nright=1; xright=x[(-right)] }
	else{ nright=nx[right]; xright=sumx[right] }
	if(xright/float(nright) < xleft/float(nleft)){	# interchange
		merge[i,1]=right; merge[i,2]=left
		}
	nx[i]=nleft+nright
	sumx[i]=xleft+xright
	}
call treelv(merge[1,1],merge[1,2],n+1,order,nx)	# find leaf ordering from modified merge lists
RETURN(merge,height,order)
END
