#coeops		coerce for arithmetic, logic & bit operators
subroutine coeops(p1,p2,m1,m2,n1,n2,value1,value2,p,entry,mode,n,value,whichf)
POINTER p1,p2,value1,value2,p,entry,value
integer m1,m2,n1,n2,mode,n,whichf
#p1,p2 input pointers to operand structures
#m1,m2; n1,n2; value1,value2: output modes;length;values for coerced operands
#p,entry: output structure & data entry pointers for result of operation
#mode: output mode for **operation** (& for result, if arith operator)
#n, value: output length, value pointer for result

#NOTE: this routine depends on LGL, INT and REAL taking equal space

INCLUDE(struct, stack,arith)
POINTER copys,getvec,dirfnd,alctss,e1,e2,dir1,dir2,pcopy,deref
integer dmode,nstr; real st1,st2,en1,en2,pe1,pe2,st,en
logical arith,dimeq

arith=whichf<=NARITHOP
call coeves(p1,e1,ANY,TRUE); call coeves(p2,e2,ANY,TRUE)
m1=MODE(e1); m2=MODE(e2); n1=LENGTH(e1); n2=LENGTH(e2)
if(arith & max0(m1,m2)>DBL) FATAL(Non-numeric data in arithmetic)
# determine mode for result, operation
if(whichf==AND_OP | whichf==OR_OP){m1=LGL;m2=LGL} #bit operators need LGL operands
else { #generally, coerce operands to dominant mode
	m1=max0(m1,INT); m2=max0(m2,INT)
	if(whichf==PWR_OP) {
		m1=REAL #left operand real (handle -ve pwrs, int. overflow)
		if(m2==INT)whichf=IPWR_OP #special operator, no coerce
		}
	else if(whichf==DIV_OP & m1==INT & m2==INT){m1=REAL;m2=REAL} #force real for divide
	else {m1=max0(m1,m2); m2=m1}
	}
if(arith) dmode=max0(m1,m2) #mode for the result
else dmode=LGL
mode=max0(m1,m2) #mode for the operation
if(MODE(e1)!=m1)call coeves(p1,e1,m1,TRUE)
if(MODE(e2)!=m2)call coeves(p2,e2,m2,TRUE)
value1=VALUE(e1); value2=VALUE(e2)

nstr=0; p=NULL # sort out special cases with 1 or 2 non-vector structures
if(MODE(deref(p1))==STR) { pcopy=p1; nstr=1 } # deref to exclude 1-component struc's
if(MODE(deref(p2))==STR) {pcopy=p2; nstr=nstr+1}
switch(nstr) {
case 0: n=max0(n1,n2); p=getvec(dmode,n); entry=p
case 1:  # output looks like structure
case 2: dir1=VALUE(p1); dir2=VALUE(p2) #special checks for compatible structs
	if(dirfnd(dir1,TSTRING(Dim))!=NULL & dirfnd(dir2,TSTRING(Dim))!=NULL){
		if(!dimeq(dir1,dir2))FATAL(Arrays must conform in dimensions)
		}
	else if(dirfnd(dir1,TSTRING(Tsp))!=NULL & dirfnd(dir2,TSTRING(Tsp))!=NULL){
		call ctsop(p1,st1,en1,pe1) #get time series parameters
		call ctsop(p2,st2,en2,pe2)
		if(abs(pe2-pe1)>.001)FATAL(Time series must have same periodicity)
		st=amax1(st1,st2); en=amin1(en1,en2) #get intersect of time window
		n= (en-st)*pe1 +1.01;
		if(n<=0)FATAL(Time series must have intersecting times)
		value1=VALUE(e1)+ifix((st-st1)*pe1+.01)
		value2=VALUE(e2)+ifix((st-st2)*pe2+.01)
		n1=n; n2=n #match value, length
		p=alctss(dmode,st,en,pe1,NOARG); entry=dirfnd(VALUE(p),TSTRING(Data))
		}
	else {
		n=max0(n1,n2); p=getvec(dmode,n); entry=p
		}
	}
if(p==NULL){
	p=copys(pcopy); entry=dirfnd(VALUE(p),TSTRING(Data))
 	n=LENGTH(entry); MODE(entry)=dmode # see NOTE
	}
value=VALUE(entry)
return
end
