FUNCTION loglin(
	table	/ARRAY/,
	margin	/INT/,
	start	/REAL,OPTIONAL/,
	eps	/REAL,1,.1/
	iter	/INT,1,20/
	print	/LGL,1,TRUE/
	)

STRUCTURE(
	fit	/LIKE(table)/
	Dim	/FROM(table)/
	newmar	/INT,LENGTH(margin)+2/
	)

STATIC( integer i,l,ierr,nlast; real dev )
l=LENGTH(margin)
for(i=1; i<=l; i=i+1)
	if(margin[i]>LENGTH(Dim)|margin[i]<0)
		FATAL(Bad margin specification)
call icopy(margin,newmar,l)
newmar[l+1]=0
newmar[l+2]=0

if(!MISSING(start)){
	CHECK(LENGTH(start)==LENGTH(table),FATAL(Incorrect length for start))
	call rcopy(start,fit,LENGTH(start))
	}
else fit[1]=-1.


call loglin(table,LENGTH(Dim),Dim,newmar,fit,eps,iter,dev,nlast)

if(nlast>iter) WARNING(Did not converge)

if(print | nlast>iter) 
	EPRINT(I(nlast,0)," iterations: deviation",R(dev))
RETURN(fit)
END
