FUNCTION postscript(
	width		/REAL,1,7.5/
	height		/REAL,1,10.0/
	horizontal	/LGL,1,FALSE/
	font		/INT,1,5/
	ptsize		/REAL,1,14./
	)
STRUCTURE(parms/REAL,5/)	# w,h,vertical

if(horizontal){
    if(MISSING(width)) width=10
    else if (width > 10.75) FATAL(Width cannot exceed 10.75 inches)
    if(MISSING(height)) height=7.5
    else if (height > 8.0) FATAL(Height cannot exceed 8.0 inches)
}
else {
    if (width > 8.0) FATAL(Width cannot exceed 8.0 inches)
    if (height > 10.75) FATAL(Height cannot exceed 10.75 inches)
}
parms[1] = width
parms[2] = height
if(horizontal) parms[3]=1; else parms[3]=0
parms[4] = font - 1
parms[5] = ptsize

DEVICE_DRIVER
RETURN(parms)
END
