#absv     absv - get absolute value of a vector
subroutine absv(x,n,y)
#
real x(1),y(1)
#
if (n>0)
	do i = 1,n
		y(i) = abs(x(i))
return
end



#add    add - add 2 vectors
subroutine add(x,y,n,xpy)
#
real x(1),y(1),xpy(1)
#
if (n>0)
	do i = 1,n
		xpy(i) = x(i)+y(i)
return
end



#radd  radd - add a constant to a vector
subroutine radd(val,x,n,xad)
#
real x(1),xad(1),val
#
if (n>0)
	do i = 1,n
		xad(i) = x(i)+val
return
end



#div     div - divide 1st vector / 2nd vector
subroutine div(x,y,n,xy)
#
real x(1),y(1),xy(1)
#
if (n>0)
	do i = 1,n
		xy(i) = x(i)/y(i)
return
end



#rdiv  rdiv - divide a vector by a constant
subroutine rdiv(val,x,n,xdv)
#
real x(1),xdv(1),val
#
if (n>0)
	do i = 1,n
		xdv(i) = x(i)/val
return
end



#mult  mult - multiply 2 vectors
subroutine mult(x,y,n,xy)
#
real x(1),y(1),xy(1)
#
if (n>0)
	do i = 1,n
		xy(i) = x(i)*y(i)
return
end



#rmult  rmult - multiply a vector by a constant
subroutine rmult(val,x,n,xm)
#
real x(1),xm(1),val
#
if (n>0)
	do i = 1,n
		xm(i) = x(i)*val
return
end



#rmovf  rmovf- forward move reals from a to b.  loc(a).gt.loc(b)
subroutine rmovf(a,n,b)
#
real a(1),b(1)
#
if (n>0)
	do i = 1,n
		b(i) = a(i)
return
end



#brput  brput - fill a vector with a value
subroutine brput(val,x,n)
#
real x(1),val
#
if (n>0)
	do i = 1,n
		x(i) = val
return
end



#ivec  ivec- fill an integer vector with 1(1)n
subroutine ivec(n,ix)
#
integer ix(1)
#
if (n>0)
	do i = 1,n
		ix(i) = i
return
end



#rvec  rvec- fill a real vector with go(del)end
subroutine rvec(go,end,del,x)
#
real x(1)
#
n = (end-go)/del+1.5
if (n>0) {
#
	x(1) = go
	if (n>1)
		do i = 2,n
			x(i) = x(1)+(float(i-1)*del)
	}
return
end



#subt  subt - subtract 2 vectors
subroutine subt(x,y,n,xmy)
#
real x(1),y(1),xmy(1)
#
if (n>0)
	do i = 1,n
		xmy(i) = x(i)-y(i)
return
end



#sumx     sumx - sum the elements of a vector
real function sumx(x,n)
#
real x(1)
#
sumx = 0.
if (n>0)
	do i = 1,n
		sumx = sumx+x(i)
return
end



#sxy    sxy - get sum of cross products
real function sxy(x,y,n)
#
real x(1),y(1)
#
sxy = 0.
if (n>0)
	do i = 1,n
		sxy = sxy+x(i)*y(i)
return
end



#zrol    zrol - machine 0.0 plus epsilon
real function zrol(z)
#
z = float(I1MACH(10))**(I1MACH(12)+2)
zrol = z
return
end



