#ex4                                                              ex4   ======
# data used - iris
# test of cross
subroutine ex4
INCLUDE(graphics)
real x(25,3),y(25,3),u(25,3),v(25,3)
CHARACTER(d,1,3)
data d/"A","B","C"/
data x(01,1),y(01,1),u(01,1),v(01,1)/5.1,3.5,1.4,0.2/
data x(02,1),y(02,1),u(02,1),v(02,1)/4.9,3.0,1.4,0.2/
data x(03,1),y(03,1),u(03,1),v(03,1)/4.7,3.2,1.3,0.2/
data x(04,1),y(04,1),u(04,1),v(04,1)/4.6,3.1,1.5,0.2/
data x(05,1),y(05,1),u(05,1),v(05,1)/5.0,3.6,1.4,0.2/
data x(06,1),y(06,1),u(06,1),v(06,1)/5.4,3.9,1.7,0.4/
data x(07,1),y(07,1),u(07,1),v(07,1)/4.6,3.4,1.4,0.3/
data x(08,1),y(08,1),u(08,1),v(08,1)/5.0,3.4,1.5,0.2/
data x(09,1),y(09,1),u(09,1),v(09,1)/4.4,2.9,1.4,0.2/
data x(10,1),y(10,1),u(10,1),v(10,1)/4.9,3.1,1.5,0.1/
data x(11,1),y(11,1),u(11,1),v(11,1)/5.4,3.7,1.5,0.2/
data x(12,1),y(12,1),u(12,1),v(12,1)/4.8,3.4,1.6,0.2/
data x(13,1),y(13,1),u(13,1),v(13,1)/4.8,3.0,1.4,0.1/
data x(14,1),y(14,1),u(14,1),v(14,1)/4.3,3.0,1.1,0.1/
data x(15,1),y(15,1),u(15,1),v(15,1)/5.8,4.0,1.2,0.2/
data x(16,1),y(16,1),u(16,1),v(16,1)/5.7,4.4,1.5,0.4/
data x(17,1),y(17,1),u(17,1),v(17,1)/5.4,3.9,1.3,0.4/
data x(18,1),y(18,1),u(18,1),v(18,1)/5.1,3.5,1.4,0.3/
data x(19,1),y(19,1),u(19,1),v(19,1)/5.7,3.8,1.7,0.3/
data x(20,1),y(20,1),u(20,1),v(20,1)/5.1,3.8,1.5,0.3/
data x(21,1),y(21,1),u(21,1),v(21,1)/5.4,3.4,1.7,0.2/
data x(22,1),y(22,1),u(22,1),v(22,1)/5.1,3.7,1.5,0.4/
data x(23,1),y(23,1),u(23,1),v(23,1)/4.6,3.6,1.0,0.2/
data x(24,1),y(24,1),u(24,1),v(24,1)/5.1,3.3,1.7,0.5/
data x(25,1),y(25,1),u(25,1),v(25,1)/4.8,3.4,1.9,0.2/
data x(01,2),y(01,2),u(01,2),v(01,2)/6.3,3.3,6.0,2.5/
data x(02,2),y(02,2),u(02,2),v(02,2)/5.8,2.7,5.1,1.9/
data x(03,2),y(03,2),u(03,2),v(03,2)/7.1,3.0,5.9,2.1/
data x(04,2),y(04,2),u(04,2),v(04,2)/6.3,2.9,5.6,1.8/
data x(05,2),y(05,2),u(05,2),v(05,2)/6.5,3.0,5.8,2.2/
data x(06,2),y(06,2),u(06,2),v(06,2)/7.6,3.0,6.6,2.1/
data x(07,2),y(07,2),u(07,2),v(07,2)/4.9,2.5,4.5,1.7/
data x(08,2),y(08,2),u(08,2),v(08,2)/7.3,2.9,6.3,1.8/
data x(09,2),y(09,2),u(09,2),v(09,2)/6.7,2.5,5.8,1.8/
data x(10,2),y(10,2),u(10,2),v(10,2)/7.2,3.6,6.1,2.5/
data x(11,2),y(11,2),u(11,2),v(11,2)/6.5,3.2,5.1,2.0/
data x(12,2),y(12,2),u(12,2),v(12,2)/6.4,2.7,5.3,1.9/
data x(13,2),y(13,2),u(13,2),v(13,2)/6.8,3.0,5.5,2.1/
data x(14,2),y(14,2),u(14,2),v(14,2)/5.7,2.5,5.0,2.0/
data x(15,2),y(15,2),u(15,2),v(15,2)/5.8,2.8,5.1,2.4/
data x(16,2),y(16,2),u(16,2),v(16,2)/6.4,3.2,5.3,2.3/
data x(17,2),y(17,2),u(17,2),v(17,2)/6.5,3.0,5.5,1.8/
data x(18,2),y(18,2),u(18,2),v(18,2)/7.7,3.8,6.7,2.2/
data x(19,2),y(19,2),u(19,2),v(19,2)/7.7,2.6,6.9,2.3/
data x(20,2),y(20,2),u(20,2),v(20,2)/6.0,2.2,5.0,1.5/
data x(21,2),y(21,2),u(21,2),v(21,2)/6.9,3.2,5.7,2.3/
data x(22,2),y(22,2),u(22,2),v(22,2)/5.6,2.8,4.9,2.0/
data x(23,2),y(23,2),u(23,2),v(23,2)/7.7,2.8,6.7,2.0/
data x(24,2),y(24,2),u(24,2),v(24,2)/6.3,2.7,4.9,1.8/
data x(25,2),y(25,2),u(25,2),v(25,2)/6.7,3.3,5.7,2.1/
data x(01,3),y(01,3),u(01,3),v(01,3)/7.0,3.2,4.7,1.4/
data x(02,3),y(02,3),u(02,3),v(02,3)/6.4,3.2,4.5,1.5/
data x(03,3),y(03,3),u(03,3),v(03,3)/6.9,3.1,4.9,1.5/
data x(04,3),y(04,3),u(04,3),v(04,3)/5.5,2.3,4.0,1.3/
data x(05,3),y(05,3),u(05,3),v(05,3)/6.5,2.8,4.6,1.5/
data x(06,3),y(06,3),u(06,3),v(06,3)/5.7,2.8,4.5,1.3/
data x(07,3),y(07,3),u(07,3),v(07,3)/6.3,3.3,4.7,1.6/
data x(08,3),y(08,3),u(08,3),v(08,3)/4.9,2.4,3.3,1.0/
data x(09,3),y(09,3),u(09,3),v(09,3)/6.6,2.9,4.6,1.3/
data x(10,3),y(10,3),u(10,3),v(10,3)/5.2,2.7,3.9,1.4/
data x(11,3),y(11,3),u(11,3),v(11,3)/5.0,2.0,3.5,1.0/
data x(12,3),y(12,3),u(12,3),v(12,3)/5.9,3.0,4.2,1.5/
data x(13,3),y(13,3),u(13,3),v(13,3)/6.0,2.2,4.0,1.0/
data x(14,3),y(14,3),u(14,3),v(14,3)/6.1,2.9,4.7,1.4/
data x(15,3),y(15,3),u(15,3),v(15,3)/5.6,2.9,3.6,1.3/
data x(16,3),y(16,3),u(16,3),v(16,3)/6.7,3.1,4.4,1.4/
data x(17,3),y(17,3),u(17,3),v(17,3)/5.6,3.0,4.5,1.5/
data x(18,3),y(18,3),u(18,3),v(18,3)/5.8,2.7,4.1,1.0/
data x(19,3),y(19,3),u(19,3),v(19,3)/6.2,2.2,4.5,1.5/
data x(20,3),y(20,3),u(20,3),v(20,3)/5.6,2.5,3.9,1.1/
data x(21,3),y(21,3),u(21,3),v(21,3)/5.9,3.2,4.8,1.8/
data x(22,3),y(22,3),u(22,3),v(22,3)/6.1,2.8,4.0,1.3/
data x(23,3),y(23,3),u(23,3),v(23,3)/6.3,2.5,4.9,1.5/
data x(24,3),y(24,3),u(24,3),v(24,3)/6.1,2.8,4.7,1.2/
data x(25,3),y(25,3),u(25,3),v(25,3)/6.4,2.9,4.3,1.3/
call beginz
call srngez(x,y,75)
SPECIFY( axs(2,"e") )
call titlez(TSTRING(Iris Data - EX4),TSTRING(Petal and Sepal Length),TSTRING(Petal and Sepal Width))
call mtextz(3,2.,TSTRING(A=Setosa  B=Virginica  C=Versicolor))
call mtextz(3,0.,TSTRING((cross gives relative sepal size)))
QUERY( cxy(cx,cy) )
# plot the letters a,b,or c and crosses for sepal data
# blank out a 1-character square at center of cross
SPECIFY( xpd(TRUE) )
do j = 1,3 {
	SPECIFY( pch(d(j)) )
	call pointz(x(1,j),y(1,j),25)
	}
call rscale(u,75,2.*cx,cx,u)
call rscale(v,75,2.*cy,cy,v)
call cross(x,y,u,v,75)
return
end
#cross                                                            ======cross
subroutine cross(x,y,u,v,n)
real x(n),y(n),u(n),v(n)
INCLUDE(graphics)
do i = 1,n {
	QUERY( cxy(cx,cy) )
	call ytickz(y(i),1,x(i)+.75*cx,x(i)+u(i))
	call ytickz(y(i),1,x(i)-u(i),x(i)-.75*cx)
	call xtickz(x(i),1,y(i)-v(i),y(i)-.75*cy)
	call xtickz(x(i),1,y(i)+.75*cy,y(i)+v(i))
	}
return
end
#rscale	normalize data to given range
subroutine rscale(x,n,ymin,ymax,y)
real x(n),y(n)
call rangev(x,n,xmin,xmax)
b=(ymax-ymin)/(xmax-xmin)
a=ymin-b*xmin
do i=1,n
	y(i)=a+b*x(i)
return
end
