ROUTINE(dashlz,		device-independent dashed line)
subroutine dashlz(x1,y1,x2,y2)
INCLUDE(graphics)
real x(2),y(2)
logical dotmod
QUERY( lty(lty), pin(w,h), usr(x1o,x2o,y1o,y2o) )
lt = max(mod(lty,10),2)
space = w*(1+lty/10)*.0042
#  compute transformation factors
xa = (-x1o/(x2o-x1o))*w
ya = (-y1o/(y2o-y1o))*h
xb = w/(x2o-x1o)
yb = h/(y2o-y1o)
#  compute end points and length in new scale (inches)
x(1) = xa+xb*x1
xx2 = xa+xb*x2
y(1) = ya+yb*y1
yy2 = ya+yb*y2
tleng = sqrt((xx2-x(1))**2+(yy2-y(1))**2)
if (tleng<=space) {	# if no room for dashed line plot solid one and return
	x(1) = x1
	x(2) = x2
	y(1) = y1
	y(2) = y2
	call linesz(x,y,2)
	}
else {	#change coordinates and proceed
	SPECIFY( usr(0.0,w,0.0,h) )
	angle = atan2(yy2-y(1),xx2-x(1))
	xd = space*cos(angle)
	yd = space*sin(angle)
	for(totl=0; totl<tleng; totl=totl+float(i+j)*space){	# add up total inches plotted
		for(i=1; dotmod(lt); i=i+1) ;	#count number of solids
		x(2) = amin1(xx2,x(1)+xd*float(i))
		y(2) = amin1(yy2,y(1)+yd*float(i))
		call linesz(x,y,2)
		for(j=1; !dotmod(lt); j=j+1) ;	#count number of spaces
		x(1) = x(2) + xd*float(j)
		y(1) = y(2) + yd*float(j)
		}
	x(2) = xx2	#  finish with dash
	y(2) = yy2
	x(1) = xx2-xd
	y(1) = yy2-yd
	call linesz(x,y,2)
	SPECIFY( usr(x1o,x2o,y1o,y2o) )	# restore original scaling and return
	}
return
end
