ROUTINE(hhbrkz,		create breakpoints for histogram)
subroutine hhbrkz(z,n,k,nbreak,cbreak)
real z(n),cbreak(*),adjust(2)
data adjust/.5, -.25/
if(n<=0) return
eps2 = 10.**(-NDIGITS)
eps=.5*eps2
call rangev(z,n,zmin,zmax)
umin=zmin; umax=zmax
nint = k-1
repeat {	# find approx nint pretty class breaks
	call zuintz(umin,umax,nint,udist)
	if(umin<zmin) break	# don't let zmin fall on break point
	if(umin==umax) umin = umin-1.;
	else  umin = umin-.001*(umax-umin)
	}

# count data points which fall on class breaks
kadj = 0
repeat {	# make fewer than a third of points fall on class breaks
	kntm = 0
	do i = 1,n
		if(amod(z(i)-umin+eps,udist)<eps2) kntm=kntm+1
	if(kntm<=(n+2)/3) break
	kadj = kadj+1
	if(n<=2 | kadj>=2) break
	umin=umin-udist*adjust(kadj)
	}

cbreak(1)=umin
nbreak=1
repeat{
	nbreak=nbreak+1
	cbreak(nbreak)=cbreak(nbreak-1)+udist
	}
	until(cbreak(nbreak)>zmax)
return
end
