ROUTINE(alngam,alog (abs (gamma (x))))
real function alngam(x)
# june 1977 edition.   w. fullerton, c3, los alamos scientific lab.
real x,sinpiy,sq2pil,sqpi2l,pi,xmax,dxrel,y
real gamma,r9lgmc
SAVE( xmax,dxrel )
data sq2pil/0.9189385332 0467274e0/
# sq2pil = alog(sqrt(2.*pi)),  sqpi2l = alog (sqrt(pi/2.))
data sqpi2l/0.2257913526 4472743e0/
data pi/3.1415926535 8979324e0/
data xmax,dxrel/0.,0./
if (xmax==0.) {
	xmax = R1MACH(2)/alog(R1MACH(2))
	dxrel = sqrt(R1MACH(4))
	}
y = abs(x)
if (y<=10.0)	# alog (abs (gamma(x))) for  abs(x) .le. 10.0
	return( alog(abs(gamma(x))) )
# alog (abs (gamma(x))) for abs(x) .gt. 10.0
if (y>xmax)  ERROR(overflow -- abs(x) too large)
if (x>0.)
	return( sq2pil+(x-0.5)*alog(x)-x+r9lgmc(y) )
sinpiy = abs(sin(pi*y))
if (sinpiy==0.) ERROR(x is a negative integer)
if (abs((x-aint(x-0.5))/x)<dxrel)
	ERROR(answer under half precision as x near negative integer,answer returned,WARNING)
return( sqpi2l+(x-0.5)*alog(y)-x-alog(sinpiy)-r9lgmc(y) )
end
