ROUTINE(qtdis,quantile of t distribution df degrees of freedom at probability p)
real function qtdis(p,df)
real p,df

real halfpi,zrotol,fn,pr,a,b,c,d,x,y,pr2,fnp2,qnorms
integer n
data halfpi/1.57079633/
data zrotol/SMALL/
if(p<=0.|p>=1.)ERROR(`Probability out of range (0,1)')
if (df<1.0) ERROR(DF less than 1)
n = df
fn = df
pr = (1.-p)*2.
if (p<0.5)
	pr = p*2.
if (abs(fn-2.)<=zrotol)	#   for df=2
	qtdis = sqrt(2./(pr*(2.-pr))-2.)
else if (abs(fn-1.)<=zrotol) {	# for df=1
	pr = pr*halfpi
	qtdis = cos(pr)/sin(pr)
	}
else {
	a = 1./(fn-0.5)
	b = 48./a**2
	c = ((20700.*a/b-98.)*a-16.)*a+96.36
	d = ((94.5/(b+c)-3.)/b+1.)*sqrt(a*halfpi)*fn
	x = d*pr
	y = x**(2./fn)
	if (y<=a+.05) {
		fnp2 = fn+2.
		y = ((1./(((fn+6.)/(fn*y)-0.089*d-0.822)*fnp2*3.)+0.5/(fn+4.))*y-1.)*(fn+1.)/fnp2+1./y
		}
	else {	#   asymptotic inverse expansion about normal
		pr2 = pr*0.5
		x = qnorms(pr2)
		y = x**2
		if (fn<5.)
			c = c+0.3*(fn-4.5)*(x+0.6)
		c = (((0.05*d*x-5.)*x-7.)*x-2.)*x+b+c
		y = (((((0.4*y+6.3)*y+36.)*y+94.5)/c-y-3.)/b+1.)*x
		y = a*y**2
		if (y<=0.002)
			y = 0.5*y**2+y
		else
			y = exp(y)-1.
		}
	qtdis = sqrt(fn*y)
	}
if (p<0.5)
	qtdis = -qtdis
return
end
