SUPPORT(zzorth)
subroutine zzorth(m,n,Q,v,r,rho,norm,u,s,ndim)

INCLUDE(gs)
logical restrt,null
integer m,n,i,j,k,ndim
logical norm
real Q(m,ndim),v(m),r(ndim),u(m),s(ndim)
real rho,rho0,rho1,t,snrm2
double precision ss,qq,vv

restrt=FALSE; null=FALSE; fail=FALSE
for(j=1; j<=n; j=j+1)
	r(j)=0.
rho0=snrm2(m,v,1); rho=rho0; rhobeg=rho
k=0
repeat{ #Take a Gram-Schmidt iteration, ignoring r on later steps if prev v null
	for(i=1; i<=m; i=i+1)
		u(i)=0.
	for(j=1; j<=n; j=j+1) {
		ss=0.
		for(i=1; i<=m; i=i+1) {
			qq=Q(i,j)
			vv=v(i)
			ss=ss+qq*vv
			}
		t=ss; s(j)=ss
		for(i=1; i<=m; i=i+1)
			u(i)=u(i)+Q(i,j)*t
		}
	if(!null)
		for(j=1; j<=n; j=j+1)
			r(j)=r(j)+s(j)
	for(i=1; i<=m; i=i+1)
		v(i)=v(i)-u(i)
	rho1=snrm2(m,v,1); t=snrm2(n,s,1)
	k=k+1
	if(m==n) {	#Treat special case m=n
		for(i=1; i<=m; i=i+1)
			v(i)=0.
		rho=0.
		return
		}
	if(rho0+omega*t<=theta*rho1) break	# Test for termination
	if(rho1<=sigma*rhobeg)break #nearly total orthogonality
	if(k>4) { #exit to fail if too many iterations
		fail=TRUE; return
		}
	if(!restrt & (rho1<=rho*sigma)) {
		restrt=TRUE
		#find first row of minimal length of Q
		for(i=1; i<=m; i=i+1)
			u(i)=0.
		for(j=1; j<=n; j=j+1)
			for(i=1; i<=m; i=i+1)
				u(i)=u(i)+Q(i,j)**2
		t=2.
		for(i=1; i<=m; i=i+1)
			if(u(i)<t) {
				k=i; t=u(k)
				}
		#take correct action if v is null
		if(rho1==0.) {
			null=TRUE; rho1=1.
			}
		#reinitialize v and k
		for(i=1; i<=m; i=i+1)
			v(i)=0.
		v(k)=rho1; k=0
		}
	#Take another iteration
	rho0=rho1
	}
if(norm) for(i=1; i<=m; i=i+1) #Normalize v and take standard exit
	v(i)=v(i)/rho1
if(!null)rho=rho1
else rho=0.
return
end
