#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "S.h"
#include "device.h"

#define MAXREL 31
#define INIT 'I'
#define RELLINE 'l'
#define LINE 'L'
#define RELMOVE 'm'
#define COLOR 'O'
#define MOVE 'M'
#define ERASE 'E'
#define CHR 'C'
#define RCHR 'S'
#define RECT 'R'
#define POLYGON 'G'
#define QUERY 'Q'
#define MENU 'U'
#define GRAPH_BEGIN 035
#define GRAPH_END 037
#define GRAPH_WRAP 030

#define NLOCAL 6

#define ask ((long *)(cur_device->local_params))[0]
#define oldcol ((long *)(cur_device->local_params))[1]
#define oldx ((long *)(cur_device->local_params))[2]
#define oldy ((long *)(cur_device->local_params))[3]
#define opened ((long *)(cur_device->local_params))[4]

#define am(i)		(F77_COM(bgrp)[i-1])
#define Ltype		((int)am(8))
#define Lwidth		((int)am(9))
#define Color		((int)am(10))
#define Cex		(am(18))
#define Srot		(am(48))
#define Adjust		(am(100))
#define notNew		(am(121))

extern float F77_COM(bgrp)[];
static vector *wrap(), *flush(), *signalled(), *polygon(),
	*clear(), *seek(), *point(), *line(), *getxy(), *tty_menu();
vector *tty5620(), *F77_SUB(bpntsz)(), *F77_SUB(blinsz)(),
	*F77_SUB(btextz)(), *F77_SUB(bsegsz)(), *F77_SUB(brdpnz)();
static putout(), graphic(), newcolor(), putstring();
static long labs();

static device d_tty5620 = {
	FALSE,
	0,
	(float *)NULL,
	NLOCAL,
	(char *)NULL,
	{
		tty5620,		/* initialize <R> */
		wrap,			/* wrap up <R> */
		flush,			/* flush <R> */
		signalled,		/* caught signal <R> */
		F77_SUB(bpntsz),	/* points (bpntsz) */
		F77_SUB(blinsz),	/* lines (blinsz) */
		polygon,		/* polygon (bpolyz) */
		F77_SUB(btextz),	/* text (btextz) */
		F77_SUB(bsegsz),	/* segments (bsegsz) */
		clear,			/* clear <R> */
		F77_SUB(brdpnz),	/* graphic input (brdpnz) */
		tty_menu,			/* menu <O> */
		NULL,			/* hook <O> */
		seek,			/* seek (low level) */
		point,			/* point (low level) */
		line,			/* line (low level) */
		NULL,			/* length of string <O> */
		getxy,			/* input (low level) */
	}
};

FILE *outfile, *infile;

vector
*tty5620(a_ask, load, loader, object, a_file)
long *a_ask, *load;
char **a_file, **loader, **object;
{
	device *d, *new_device();
	int i;
	char cmd[100], *getenv();

	/* initialize device structure */
	d = new_device(&d_tty5620, 0L);
	set_device(d->which);

	oldcol = 999;
	oldx = oldy = -9999;
	opened = 0;
	ask = *a_ask;

	if(**a_file){
		outfile = fopen(*a_file,"a");
		if(outfile == NULL)
			PROBLEM "Cannot open output file %s for appending", *a_file 
			RECOVER(S_void);
		infile = fopen(*a_file,"r");
		if(infile == NULL)
			PROBLEM "Cannot open input file %s for reading", *a_file
			RECOVER(S_void);
		ask = 0;
		}
	else { outfile = stdout; infile = stdin; }

	for(i=1; i<=39; i++)
		am(i) = 0.0;
	am(20) = 9.;	/* char size in rasters */
	am(21) = 16.;
			/* am(22) - am(25) filled later */
	am(26) = 0.;	/* char addressing offset */
	am(27) = .75;
	am(28) = .01;	/* raster size in inches */
	am(29) = .01;
	am(30) = TTY5620;
	am(31) = 1;	/* allow char rotation */
	am(1) = 1.;	/* allow char size change */

	if(*load && !**a_file){	/* load the driver */
		sprintf(cmd,"%s %s/cmd/%s",
			*loader,getenv("SHOME"),*object);
		system(cmd);
#ifdef Research
		system("stty old!");
#endif
		}

	echo_off();
	graphic(INIT);
	flush();
	fscanf(infile,"%f %f %f %f",& am(22),& am(24),& am(23),& am(25));
	while(getc(infile)!='\n');	/* skip newline */
	echo_on();
	F77_SUB(defltz)();
	notNew = 1;	/* force erase on first real plotting */
	return(S_void);
}

static vector *
wrap()
{
	graphic(GRAPH_WRAP);
	return(S_void);
}

static vector *
polygon (x, y, n)
float x[], y[];
long *n;
{
	int i;
	long l1,l2;
	if(*n<3){
		flush();
		PROBLEM "Polygon needs at least 3 points" RECOVER(NULL_ENTRY);
		}
	newcolor();
	graphic(POLYGON);
	putout(*n);
	for(i=0; i<*n; i++){
		l1 = am(36)+am(37)*x[i];
		l2 = am(24)+am(25)-am(38)-am(39)*y[i];
		putout(l1); putout(l2);
		}
	flush();
	return (S_void);
}

static putout(l)
long l;
{
	graphic((int)(l & 037)|0100);
	graphic((int)((l>>5) & 037)|0100);
	graphic((int)((l>>10) & 077)|0100);
}

static int echo_is_off = 0;

static vector *signalled()
{
	int i;
	if(opened) {
		for(i=0; i<10; i++)
			graphic(GRAPH_END);
		opened=0;
		}
	fflush(stdout);
	if(echo_is_off) {
		echo_on();
		echo_is_off = 0;
		}
	oldx = -9999; oldy = -9999;
	return(S_void);
}

static graphic(c)
int c;
{
	if(!opened) {
		putc(GRAPH_BEGIN,outfile);
		opened=TRUE;
	}
	putc(c,outfile);
}


static xysc(xa, ya)
int xa, ya;
{
	int yi;
	yi = (int) am(25) - ya + (int) am(24);
	graphic((xa&037) | 0100);
	graphic(((xa >> 5) & 037) | 0100);
	graphic((yi&037) | 0100);
	graphic(((yi >> 5) & 037) | 0100);
}

static xyshort(xa, ya, op)
int op, xa, ya;
{
	int xi,yi;
	if(labs(xa-oldx)>MAXREL || labs(ya-oldy)>MAXREL) return(0);
	xi = xa - oldx + MAXREL;
	yi = - (ya - oldy) + MAXREL;
	graphic(op);
	graphic((xi&077) | 0100);
	graphic((yi&077) | 0100);
	oldx = xa; oldy = ya;
	return(1);
}

static long labs(x)
long x;
{
	return(x>0?x:-x);
}


static vector *line(ix,iy)
long *ix,*iy;
{
	newcolor();
	if(xyshort((int)*ix,(int)*iy,RELLINE)) return(S_void);
	graphic(LINE);
	xysc((int)*ix, (int)*iy);
	oldx = *ix; oldy = *iy;
	return(S_void);
}

static vector *point(ich,crot)
F_CHARTYPE ich;
float *crot;
{
	if(fabs(*crot)<45.) { 
		graphic(CHR);
		oldx += am(20);
		}
	else {
		graphic(RCHR);
		oldy += am(20);
		}
	graphic(*F_CHARP(ich));
	return(S_void);
}

static vector *seek(ix,iy)
long *ix,*iy;
{
	newcolor();
	if(*ix==oldx && *iy==oldy) return(S_void);
	if(xyshort((int)*ix,(int)*iy,RELMOVE)) return(S_void);
	graphic(MOVE);
	xysc((int)*ix, (int)*iy);
	oldx = *ix; oldy = *iy;
	return(S_void);
}

static vector *clear()
{
	long x1, x2, y1, y2;
	if(ask){
		fprintf(stderr,"GO? ");
		fflush(stderr);
		while( getc(infile)!='\n' ) ;	/* ignore reply */
	}
	graphic(ERASE);
	flush();
	echo_off();
	fscanf(infile,"%ld %ld %ld %ld" ,&x1,&y1,&x2,&y2);
	while(getc(infile)!='\n');	/* skip newline */
	echo_on();
	if(x1!=am(22) || y1!=am(24) || x2!=am(23) || y2!=am(25)){
		oldx = oldy = -9999;
		F77_SUB(zzdevz)(&x1,&x2,&y1,&y2);
		}
	return(S_void);
}


static vector *flush()
{
	if(opened) {
		graphic(GRAPH_END);
		opened=0;
		}
	fflush(outfile);
	return(S_void);
}

static vector *getxy(x,y,flag)
long *x,*y,*flag;
{
	echo_is_off = 1;
	echo_off();
	graphic(QUERY);
	flush();
	fscanf(infile,"%ld %ld %ld",x,y,flag);
	while(getc(infile)!='\n');	/* eat newline */
	*y = (int)am(25) - *y + (int)am(24);
	if((*flag)>4) *flag = -1;
	echo_on();
	echo_is_off = 0;
	return(S_void);
}

static newcolor()
{
	int which;
	which = (int) am(10);
	if(which==oldcol) return;
	graphic(COLOR);
	graphic(which + ' ');
	oldcol = which;
}

static vector *tty_menu(ent,arglist)
vector *ent, *arglist;
{
	vector *value;
	int n, i;
	UNUSED(ent);
	value = coevec(*(arglist->value.tree),ANY,TRUE,CHECK_IT);
	if(value==NULL_ENTRY) return(S_void);
	value = coevec(value,CHAR,TRUE,CHECK_IT);

	echo_off();
	graphic('u');		/* set up menu */
	putout((long)1);	/* menu number */
	putout((long) value->length);	/* number of items */
	for(i=0; i<value->length; i++)	/* the labels */
		putstring(value->value.Char[i],outfile);
	fflush(outfile); opened = 0;
	graphic('U');		/* select from menu */
	putout((long)1);	/* menu number */
	putout((long)3);	/* button number */
	fflush(outfile); opened = 0;
	fscanf(infile,"%d",&n);
	while(getc(infile)!='\n');	/* eat newline */
	graphic('u');		/* delete menu */
	putout((long)1);
	putout((long)0);
	fflush(outfile); opened = 0;
	echo_on();

	value=alcvec(INT,1L);
	*(value->value.Long) = n;
	return(value);
}

static putstring(p,o)
char *p;
FILE *o;
{
	do
		putc(*p,o);
	while(*(p++));
}
