subroutine stable(x,n,a,b,u,e)
real x(1),a,b,u(1),e(1); integer n

for(i=1; i<=n; i=i+1) x(i) = rstab(a,b,u(i),e(i))
return
end

#rstab  --  random stable standardized form
function rstab(alpha,bprime,u,w)
# arguments ..
#       alpha : characteristic exponent
#      bprime : skewness in revised parameterization
#           u : uniform variate on (0.,1.), for example from a uniform
#             pseudo-random number generator
#           w : exponentially distributed variate

double precision da,db
data piby2/1.57079633/,piby4/.785398163/
data thr1/0.99/
eps = 1.0-alpha
# compute some tangents
phiby2 = piby2*(u-0.5)
a = phiby2*tan2(phiby2)
bb = tan2(eps*phiby2)
b = eps*phiby2*bb
if (eps>(-0.99))
	tau = bprime/(tan2(eps*piby2)*piby2)
if (eps<=(-0.99))
	tau = bprime*piby2*eps*(1.-eps)*tan2((1.-eps)*piby2)
# compute some necessary subexpressions
# if phi near pi by 2, use double precision.
if (a>thr1) {
# double precision
	da = dble(a)**2
	db = dble(b)**2
	a2 = 1.d0-da
	a2p = 1.d0+da
	b2 = 1.d0-db
	b2p = 1.d0+db
	}
else {
# single precision
	a2 = a**2
	a2p = 1.+a2
	a2 = 1.-a2
	b2 = b**2
	b2p = 1.+b2
	b2 = 1.-b2
	}
# compute coefficient
z = a2p*(b2+2.*phiby2*bb*tau)/(w*a2*b2p)
# compute the exponential-type expression
alogz = alog(z)
d = d2(eps*alogz/(1.-eps))*(alogz/(1.-eps))
# compute stable
rstab = (1.+eps*d)*2.*((a-b)*(1.+a*b)-phiby2*tau*bb*(b*a2-2.*a))/(a2*b2p)+tau*d
return
end



#d2         evaluate (exp(x)-1)/x
function d2(z)
double precision p1,p2,q1,q2,q3,pv,zz
data p1,p2,q1,q2,q3/.84006 68525 36483 239 d3,.20001 11415 89964 569 d2,.16801 33705 07926 648 d4,
  .1801 33704 07390 023 d3,1.d0/
# the approximation 1801 from hart et al (1968, p. 213)
if (abs(z)>0.1)
	d2 = (exp(z)-1.0)/z
else {
	zz = z*z
	pv = p1+zz*p2
	d2 = 2.d0*pv/(q1+zz*(q2+zz*q3)-z*pv)
	}
return
end



#tan        tangent function
function mytan(xarg)
logical neg,inv
data p0,p1,p2,q0,q1,q2/.129221035e+3,-.887662377e+1,.528644456e-1,.164529332e+3,-.451320561e+2,1.0/
# the approximation 4283 from hart et al(1968, p. 251)
data piby4/.785398163/,piby2/1.57079633/
data pi/3.14159265/
neg = .false.
inv = .false.
x = xarg
neg = x<0.
x = abs(x)
# perform range reduction if necessary
if (x>piby4) {
	x = amod(x,pi)
	if (x>piby2) {
		neg = !neg
		x = pi-x
		}
	if (x>piby4) {
		inv = .true.
		x = piby2-x
		}
	}
x = x/piby4
# convert to range of rational
xx = x*x
tan = x*(p0+xx*(p1+xx*p2))/(q0+xx*(q1+xx*q2))
if (neg)
	tan = -tan
if (inv)
	tan = 1./tan
return
end



#tan2       compute tan(x)/x
#     function defined only for abs(xarg).le.pi by 4
#     for other arguments returns tan(x)/x, computed directly
function tan2(xarg)
data p0,p1,p2,q0,q1,q2/.129221035e+3,-.887662377e+1,.528644456e-1,.164529332e+3,-.451320561e+2,1.0/
# the approximation 4283 from hart et al(1968, p. 251)
data piby4/.785398163/,piby2/1.57079633/
data pi/3.14159265/
x = abs(xarg)
if (x>piby4)
	tan2 = mytan(xarg)/xarg
else {
	x = x/piby4
# convert to range of rational
	xx = x*x
	tan2 = (p0+xx*(p1+xx*p2))/(piby4*(q0+xx*(q1+xx*q2)))
	}
return
end

