
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

static char rcsid[]=
  "$Header: /tmp_mnt/r/jove_staff3/mogul/alpha/code/NNstat/RCS/connect.c,v 1.3 1993/08/31 22:52:22 mogul Exp $";

/*
	connect.c  -- used by collect to open, close network connection
 */
/* CHANGES:
 *     Aug93/DECWRL: Alpha/OSF port
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include <errno.h>
#include <ctype.h>
#include <strings.h>

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/signal.h>
#include <netdb.h>

#include "collect.h"

int	sockno;
short   port = 0;
char    hoststring[20];
FILE    *fpin, *fpout;
extern FILE *tracefp;
extern XDR *readp, *writep;

void
appendTime(cp, when)
   char *cp;
   time_t when;
{
   struct tm *t;

   t = localtime(&when);
   sprintf(endof(cp),"%s at %2.2d%2.2d%2.2d.%2.2d%2.2d%2.2d",
   	      hoststring,
	      t->tm_hour, t->tm_min, t->tm_sec,
              t->tm_mon+1, t->tm_mday, t->tm_year);

} /* appendTime */							    

void
flush_xdr()
{ 
   fflush(fpout);
};

void
perrorOut(cp)
   char *cp;
{
   char temp[100];

   sprintf(temp, "collect -- %s ", cp);
   appendTime(temp, time(0));
   perror(temp);
   
} /* perrorOut */

boolean
openconn(inetaddr)
   struct in_addr *inetaddr;
{
   FILE *fdopen();
   char temp[100];	
   struct sockaddr_in myctladdr, remote;	
   int len = sizeof (myctladdr);
   u_int32 hostnum;

   hostnum = ntohl(inetaddr->s_addr);
   sprintf(hoststring,"%d.%d.%d.%d",
   	   (hostnum>>24), ((hostnum>>16)&0xff), 
	   ((hostnum>>8)&0xff), (hostnum&0xff));

   if (tracefp) {
      strcpy(temp, "Open TCP conn to: ");
      appendTime(temp, time(0));
      strcat(temp, "\n");
      fprintf(tracefp, temp);
      fflush(tracefp);
      }

   /* Set up the socket address structure */
   bzero((char *)&remote, sizeof(struct sockaddr_in));
   remote.sin_family = AF_INET;
   remote.sin_addr.s_addr = inetaddr->s_addr; 
   remote.sin_port = htons((port==0)? STATD_PORT: port);
   	
   if ((sockno = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      perrorOut("socket");
      return(FALSE);
      }
	   
   /* Open TCP connection...  */
   if (connect(sockno, &remote, sizeof(remote)) < 0) {
      perrorOut("connect");
      close(sockno);
      sockno = -1;
      return(FALSE);
      };
	    
   if (getsockname(sockno, &myctladdr, &len) < 0) {
      perrorOut("getsockname");
      close(sockno);
      sockno = -1;
      return(FALSE);
      }
	    
   fpin =  NULL ;
#ifdef SYSV
   sock2 = dup(sockno);
#endif  
   if ( ((fpin = fdopen(sockno, "r")) == NULL)  ||
#ifdef SYSV
        ((fpout = fdopen(sock2, "w")) == NULL)) {
#else
        ((fpout = fdopen(sockno, "w")) == NULL)) {
#endif
      perrorOut("fdopen") ;
      if (fpin) 
          fclose(fpin);
#ifdef SYSV
      close(sock2);
#endif
      close(sockno);
      sockno = -1;
      return(FALSE);
   };
      
   xdrstdio_create(readp, fpin, XDR_DECODE); 
   xdrstdio_create(writep, fpout, XDR_ENCODE); 
   
   return(TRUE);
} /* openconn */

void
closeconn()
{
   xdr_destroy(readp);	/* close streams */
   xdr_destroy(writep);

   if (tracefp) {
      fprintf(tracefp,"Closing TCP conn...\n");
      fflush(tracefp);
      }
	
   if (sockno < 0)
      return;  

   fclose(fpin);
   fclose(fpout);
   sockno = -1;
} /* closeconn */

void
netclose()
{
   char temp[100];

   strcpy(temp, "collect -- timed out ");
   appendTime(temp, time(0));
   fprintf(stderr, "%s\n", temp);
			  
   closeconn();
} /* netclose */

