
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

static char rcsid[]=
  "$Header: lookupnames.c,v 1.5 93/09/22 15:16:23 mogul Exp $";

/*     	Lookuphosts Program	(lookupnames.c)
 
	This program may be used to scan log files containing host and 
	network numbers, and fill the corresponding host or network names.
	These names will be looked up in the Domain Name Database, or if
	no matching entry is returned, in a networks file.  A standard
	hosts.txt file may also be used to supply the network names.  
	If no host/network name is found in either database, the string
	"(UNKNOWN-HOST)" will be printed in place of the name.

	The usage is:
       		lookupnames input-file-list > results-file

	Optional command line flags are as follows:
		networks-file			-n filename
		timeout-for-host-lookups	-t seconds
		
	The default networks-file is assumed to be a file named 
	"networks.txt".  This file should contain the networks 
	portion of a standard "hosts.txt" file.  For example:

		NET : 128.9.0.0 : ISI-NET :

	Alternatively, a full hosts.txt may be used.  The lookupnames
	program will scan the networks list for "NET" entries, until the
	beginning of first "GATEWAY" entry or the end of the file.

	The default timeout-for-host-lookups is 5 seconds.  After this
	timeout has elapsed, the lookupnames program will check the
	networks-file for a matching entry.  If none is found, the string
	"(TIMEOUT)" will be printed in place of the host/network name.
		
*/

#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#ifdef ISI4_2
#include <netdb.h-bind>
#else
#include <netdb.h>
#endif
#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#ifndef NOETHER
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
struct ether_addr *ether_aton ();
#endif
#ifdef RPC_DEFINES_UINT
#include <rpc/rpc.h>
#else
#include "types32bits.h"
#endif

#ifndef FALSE
#define FALSE	0	/* logical false */
#define TRUE	1	/* logical true */
#endif
#define boolean int

#define isdot(c) (c=='.')? TRUE: FALSE
#define iscolon(c) (c==':')? TRUE: FALSE
#define isopenb(c) (c=='[')? TRUE: FALSE
#define isclosb(c) (c==']')? TRUE: FALSE

#define GIVEUP 5
#define MAXLINE 256
#define MAXFILES 50
#define DEF_NETS "networks.txt"
#define HELPSTR \
	"  usage: lookupnames file-spec [-t seconds] [-n networks-list]\n\n"

extern char *index();
jmp_buf	savej;
FILE 	*ifile, 		/* input file */
	*nfile;			/* networks list (hosts.txt) */
int     timeout = 0, 		/* time to wait for nameserver */
	filecount = 0;		/* number of files from argv's */
char	*files[MAXFILES],	/* array of file pointers from argv's */
   	result[MAXLINE],	/* used to pass arguments to giveup() */
	temp[MAXLINE];		/* used to pass arguments to giveup() */

boolean
lookupnet(netp, resultp)
   char *netp, *resultp;
{
   char keyword[100],netnum[100],netname[100];
	
   if (nfile) {
      rewind(nfile);
      while(EOF != fscanf(nfile,"%s %*s %s %*s %s%*[^\n]",
   				keyword,netnum,netname)) {
         if (!strcmp("NET",keyword) && !strcmp(netp, netnum)) {
	    strcpy(resultp, netname);
	    return(TRUE);
             }
         if (!strcmp("GATEWAY",keyword))
            return(FALSE);
         }
      }
   return(FALSE);
} /* lookupnet */

void
giveup()
{
   if (lookupnet(temp, result))
      printf(" %s", result);
   else
      printf(" (TIMEOUT)") ;
   fflush(stdout);
   longjmp (savej, 1);
}

void
scanfile()
{
   int i;
   int isinet = 0;
   int isether = 0;
   struct hostent *hp ;
   u_int32 inetaddr;
#ifndef NOETHER
   struct ether_addr *etheraddr;
#endif
   char	*cp, 
	buf[MAXLINE];
	
   signal(SIGALRM, giveup);
   while (cp = fgets(buf, sizeof(buf), ifile)) {		

      while (*cp) {
	while (*cp && !isopenb(*cp)) {
	   putchar(*cp);
	   cp++;
           }
	if (*cp) putchar(*cp++);
      
	setjmp(savej);
	isether = isinet = 0;
	while (*cp && !isclosb(*cp)) {
	   while (*cp && !isxdigit(*cp)) {
	      putchar(*cp);
	      cp++;
	      }

           for (i=0;*cp && (isxdigit(*cp) || isdot(*cp) || iscolon(*cp));
	        i++,cp++) {
	      putchar(*cp);
	      temp[i] = *cp;
	      if (iscolon(*cp) || (isxdigit(*cp) && !isdigit(*cp)))
		  isether = 1;
	      if (isdot(*cp))
		  isinet = 1;
	      }
           temp[i] = '\0';

	   if (!strlen(temp)) continue;

	   if (isinet) {
	       if ((inetaddr = dotted10(temp)) == -1) continue;

	       alarm(timeout);
	       hp = gethostbyaddr( &inetaddr, 4, AF_INET);
	       alarm(0);
	       if (hp == NULL) {
		   if (lookupnet(temp, result))
		       printf(" %s", result);
		   else
		       printf(" (UNKNOWN-HOST)") ;
	       }
	       else 
		   printf(" %s", hp->h_name ) ;
	   }
#ifndef NOETHER
	   else if (isether) {
	       if ((etheraddr = ether_aton(temp)) == NULL) continue;

	       if (ether_ntohost(result, etheraddr))
		   printf(" (UNKNOWN-ETHER)") ;
	       else 
		   printf(" %s", result) ;
	   }
#endif
           }
      }
      
      fflush(stdout);
      }
} /* scanfile */

void
main(argc, argv)
   int argc ;
   char **argv;
{
   int i;
   char *cp, filename[256];
	
   if (argc == 1) {
      printf(HELPSTR);
      return;
      }

   for (i = 1; i < argc ; i++) {
      if (!strcmp("-t", argv[i])) {
	 /* nameserver timeout */
         for (cp = argv[++i]; *cp; cp++)
	     if (! isdigit(*cp)) {
		printf("Bad nameserver timeout: %s\n",argv[i]);
		return;
	        }
	  timeout = atoi(argv[i]);
          }
	 
      else if (!strcmp("-n", argv[i])) {
	 /* networks file */
	 strcpy(filename, argv[++i]);
	 }
      else if (argv[i][0] == '-') {
	 printf("Bad option: %s\n%s", argv[i], HELPSTR);
	 return;
  	 }
      else files[filecount++] = argv[i];
      }	
      
   if (!timeout)
      timeout = GIVEUP;
   if (strlen(filename) == 0)
      strcpy(filename, DEF_NETS);
   if (!(nfile = fopen(filename,"r"))) 
      printf("\nNetwork list: %s not found.\n\n", filename);
   for (i = 0; i < filecount ; i++) {
      printf("\nFile: %s\n\n", files[i]);
      
      if (ifile = fopen(files[i],"r")) {
         scanfile();
         fclose(ifile);
         }
      else printf("    File not found.\n\n");
      }	
   if (nfile)
      fclose(nfile);

} /* main */
