#!/bin/sh
#
# make_rpcenum.sh
# 	Based on make_rpc.enum by Pascal Hennequin (DSR-TELEINF),
#	pascal@hugo.int-evry.fr
#	Modified slightly by Jeffrey Mogul/DECWRL (mogul@wrl.dec.com)
#
# Usage:
#	make_rpcenum.sh [host names]
# The result is written to stdout.
# One way to generate a list of nearby host names is
#	make_rpcenum.sh `arp -a | awk '{print $1}'`
#
# Ce script sert a construire une table d'enumeration
# pour les rpc. Cette table doit etre utiliser avec
# nnstat version 3.2 (ou plus?) + option XPARSE et patches P.Hennequin
#
# This script constructs an enumeration table for RPC ports.
# The table is meant for use with NNstat version 3.3 (and later).
#
# Principe:
# --------
# lancer des rpcinfo -p sur les machines interessantes et
# mettre ca dans une table d'enumeration pour nnstat. On contruit
# les objects TCP.rpc* et UDP.rpc*
#
# Princpal of operation:
# (1) The user can supply a list of host names as arguments.  If
#	no arguments are supplied, the host names are taken from the
#	list of servers from which this machine is currently mounting
#	filesystems from.
# (2) Point "rpcinfo -p" at each host of interest, and put the result
#	in an enumeration table formatted for use by NNstat.  Both
#	TCP.rcp* and UDP.rpc* objects are constructed
#

# This script needs the version of awk that takes variable definitions
# on the command line.  "nawk" and "gawk" work; regular "awk" doesn't
# always work
AWK=gawk

tmpfiletcp=/tmp/make.rpc.enum.tcp.$$
tmpfileudp=/tmp/make.udp.enum.tcp.$$

if [ 0 -eq $# ]
then
    hosts=`df | grep ':' | sed 's/:.*//' | sort -u`
else
    hosts=""
    while test $# != 0
    do
	echo $1 $hosts
	hosts=$hosts" "$1
	shift
    done
fi

/bin/cp /dev/null $tmpfile.tcp
/bin/cp /dev/null $tmpfile.udp

for i in $hosts
do
  IP_address=`nametoaddr $i | $AWK '{print $1;}'`

  rpcinfo -p $i | grep tcp | $AWK '{\
    if (NF<5)\
      rpc_pgm_serv=$1;\
    else\
      rpc_pgm_serv=$5;\
    printf("%s:%s/%s \"%s/%s\",\n",$3,IP_ad,$4,host,rpc_pgm_serv);}' IP_ad=$IP_address host=$i >> $tmpfile.tcp

  rpcinfo -p $i | grep udp | $AWK '{\
    if (NF<5)\
      rpc_pgm_serv=$1;\
    else\
      rpc_pgm_serv=$5;\
    printf("%s:%s/%s \"%s/%s\",\n",$3,IP_ad,$4,host,rpc_pgm_serv);}' IP_ad=$IP_address host=$i >> $tmpfile.udp

done

echo 'enum {'
echo 'TCP.rpc* ('
(sort -u $tmpfile.tcp | $AWK -F: '/^tcp.*$/ {print $2;}')
echo '),'
echo 'UDP.rpc* ('
(sort -u $tmpfile.udp | $AWK -F: '/^udp.*$/ {print $2;}')
(echo ')'; echo '}')
/bin/rm $tmpfile.tcp $tmpfile.udp

