/* 
 * nametoaddr.c
 *	simple program to translate a host name into an IP address
 *	Jeffrey Mogul	DECWRL	October 1993
 * based on:
 *	host - print information about a host
 *	originally written by Paul Vixie @DEC WRL, January 1989
 */

#ifndef lint
static char RcsId[] = "$Header: nametoaddr.c,v 1.2 93/10/21 13:28:30 mogul Exp $";
#endif

#include <stdio.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <netdb.h>

main(argc, argv)
	char **argv;
{
	int l_addr;
	struct in_addr addr;
	struct hostent *host;
	long **cp;
	char *inet_ntoa();

	if (argc != 2) {
		printf("usage: %s hostname\n", argv[0]);
		exit(1);
	}
	l_addr = inet_addr(argv[1]);
	if (l_addr != -1) {
		addr = * (struct in_addr *) &l_addr;
		if (!(host = gethostbyaddr(&addr, sizeof addr, AF_INET))) {
			fprintf(stderr, "%s: ", inet_ntoa(addr));
			perror("gethostbyaddr");
			exit(1);
		}
	} else {
		if (!(host = gethostbyname(argv[1]))) {
			perror("gethostbyname");
			exit(1);
		}
	}
	if (host->h_addr_list && *host->h_addr_list) {
		for (cp = (long**) host->h_addr_list;  *cp;  cp++)
			printf(" %s", inet_ntoa(**cp));
		printf("\n");
	}
}
