BEGIN {file = ""; start = 0}

$0 ~ /Log created/ , $0 ~ /Object name/ {
   if (file != FILENAME) {
	if (start != 0) {
           total += latest - start; 
           printf "\nDaily total = %d (%s to %s)\n", daytot, time1, time2
           print "\nGrand Total = " total " (" starttime " to " endtime ")\n"
	   if (v == 1) print "\f"
           }
	 start = 0; total = 0; file = FILENAME; cleartime = "";
         printf "\nFile: " FILENAME "\n\n"
	 }
    print
    }

($1 == "ReadTime:") {
   day = substr($3, 1, (length($3)-4));
   if (start == 0) starttime = $2 " " day
   time2 = endtime = $2 " " day
   temp = $5 " " substr($6, 1, (length($6)-3))
   if (cleartime == temp) 
	out =  "\n  " time2 "\t\t"
   else	{
	out =  "\n  " time2 "    " temp
	if (length(cleartime) != 0) total += latest
	}
   cleartime = temp
   next #;
   }

#($1 == "Total") {
$0 ~ /Total Count/ {
   if (start == 0) {
      if (v == 1) {
        print "\n  Read-Time\t    Clear-Time\t    Total-Count\t      Increment"
        print   "  ---------\t    ----------\t    -----------\t      ---------"
        }
      daytot = inc = 0
      start = $3
      prevday = day
      time1 = starttime
      }
   else {
      if ($3 >= latest) 
	 inc = $3 - latest
      else inc = $3 + 0
      daytot += inc
      }
   latest = $3 + 0
   if (v == 1) printf "%s\t%7d\t\t%7d", out, latest, inc
   if (prevday != day) {
      printf "\nDaily total = %d (%s to %s)", daytot, time1, time2
      if (v == 1) printf "\n"
      time1 = time2
      prevday = day
      daytot = 0
      }
   next #;
   }

END {total += latest - start; 
     printf "\nDaily total = %d (%s to %s)\n", daytot, time1, time2
     print "\nGrand Total = " total " (" starttime " to " endtime ")\n"
     }
