/*
 * types32bits.h
 *
 * Declarations of several data types that must be 32 bits wide,
 * no matter what machine we are running on.  "long" is unsafe
 * because on DEC Alpha machines that means 64 bits.  "int" is
 * unsafe because on some machines that means 16 bits.
 *
 * Use int32 or u_int32 whenever you mean "32 bits" and not
 * "some large number of bits".
 *
 * NEVER use int or int32 or u_int32 (or, for that matter, long)
 * when the variable might contain a pointer value.
 */

#if defined (RPC_DEFINES_UINT)
/* u_int32 already defined */
typedef	int int32;
#else

#if  defined(pdp11)
/* other 16-bit machines */
typedef	long int32;
typedef	unsigned long u_int32;
#else
/* works almost everywhere */
typedef	int int32;
typedef	unsigned int u_int32;
#endif

#endif	/* RPC_DEFINES_UINT */
