
#ifndef long_h
#define long_h

typedef union {
	struct {
		unsigned long lo,hi;
	};
	struct {
		unsigned short lolo, lohi, hilo, hihi;
	};
#define NBPL 8
	unsigned char b[NBPL];
} Long;

unsigned _Ladd(Long *r, Long a, Long b);
unsigned _Lsub(Long *r, Long a, Long b);
unsigned _Lmul(Long *res, Long a, Long b);
unsigned _Ldiv(Long *quo, Long *rem, Long num, Long denom);

#pragma aux _Ladd = \
	"mov  edx,[esp]" \
	"add  edx,8[esp]" \
	"mov  [eax],edx" \
	"mov  edx,4[esp]" \
	"adc  edx,12[esp]" \
	"mov  4[eax],edx" \
	"setc al" \
	"movzx eax,al" \
	parm caller [eax] modify [eax edx] value [eax];

#pragma aux _Lsub = \
	"mov edx,[esp]" \
	"sub edx,8[esp]" \
	"mov [eax],edx" \
	"mov edx,4[esp]" \
	"sbb edx,12[esp]" \
	"mov 4[eax],edx" \
	"setc al" \
	"movzx eax,al" \
	parm caller [eax] modify [eax edx] value [eax];

#pragma aux _Lmul =\
	"mov    ecx, eax" \
	"mov    eax, [esp]" \
	"mul    dword ptr 8[esp]" \
	"mov    [ecx], eax" \
	"mov    ebx, edx" \
	"mov    eax, [esp]" \
	"mul    dword ptr 12[esp]" \
	"add    ebx, eax" \
	"mov    eax, 4[esp]"\
	"mul    dword ptr 12[esp]" \
	"add    ebx, eax" \
	"mov    4[ecx], ebx" \
	"xor    eax,eax" \
	parm caller [eax] modify [eax ebx ecx edx] value [eax];

#endif

// rdtsc - Read Time Stamp Counter
// The 64 bit value is written into memory pointed to by ptr.
void rdtsc64( Long *ptr );
#pragma aux rdtsc64 = "db 0fh,31h" "mov [ebx],eax" "mov [ebx+4],edx" \
	parm nomemory [ebx] modify exact nomemory [eax edx];

