

/************* 
*  Map 
*/
#define IN 0
#define OUT 1
#define MAXDIMS 5
#define MAXSTR 256
#define NAMELEN 64
typedef int Position;
typedef struct _Map{    
  struct _Map *cnext;
  struct _Map *cprev;
  int time; /* to be replaced w/ posn spec on n dims */
  Position p[2][MAXDIMS];      /* defines range on n dims */
  long in;
  long out;
  long icon;
  int selected;
  char text[MAXSTR];
} Map;

typedef Map * MapPtr;
 
Map txta, *text = &txta;
Map vdeo, *video = &vdeo;

/******************
*  Dimension
*/
#define WRAP 1                 /* Package topologies */
#define FREEZE 2
#define BOUNCE 3
#define LIMIT 4

typedef struct _Dimension {
  int min;             /* minimum value on this dim */
  int max;
  int current;         /* current pos'n on this dim */
  int range;           /* what extent is being Packageed, rel. to current */
  int boundary;          /* WRAP, FREEZE, BOUNCE, LIMIT */
  char name[NAMELEN]
 } Dimension;

typedef Dimension * DimensionPtr;
/********************
*   Screens
*/
typedef struct _Screen_ele{
  Window w, parent;
  int x,y,width,height,borderwidth;
  int type;
  int mapped;
  int selected;
  char name[NAMELEN], parentname[NAMELEN];
  char nextname[NAMELEN];      /* replaced by ptr in *next  */
  int border, backgrnd;
  Pixmap border_pixmap, backgrnd_pixmap;
  struct _Screen_ele *cnext, *cprev, *next;    /* next is user's chain */
} Screen_ele;

typedef Screen_ele * ScreenPtr;


/********************
*  Package Elements
*/
#define OFF 0
#define TEXT_TYPE 1
#define VIDEO_TYPE 2
#define DISP_TYPE 3

#define STOPPED 0
#define PAUSE 1
#define PLAYING 2

typedef struct _Element{
  struct _Element *cnext;       /* system chain */
  struct _Element *cprev;
  struct _Element *next;        /* user chain */
  struct _Element *prev;
  Window w;                    /* where Packageed */
  int on;                       /* on the screen or not */
  int type;                     /* text, video, etc. */
  int state;                    /* video playing or not */
  Map *map;                     /* head of item list */
  Map *now_showing;
  int current_frame;
  int init_active;               /* active at startup? */
  int selected;
  char file[NAMELEN];           /* data for compound elements */
  char name[NAMELEN];
  char screen_name[NAMELEN];
  char nextname[NAMELEN];       /* replaced by ptr in *next */
} Element;

typedef Element * ElementPtr;

/*********************
*  Package
*/

typedef struct _Package{
  struct _Package *cnext, *cprev, *next;
  Element *ele;                /* list of Package elements */
  Screen_ele *screen;          /* list of screen elements */
  Dimension *dims[MAXDIMS];    /* array of dimensions */
  int ndims;                   /* how many dimensions */
  int geom;                    /* linear, manifold, etc. see dimension? */
  int duration;                /* how many clock ticks at 1/30th sec --tmp*/
  int init_active;              /* active at startup? */
  int selected;
  char name[NAMELEN];
  char nextname[NAMELEN];      /* replaced by ptr in *next */
  char screen_name[NAMELEN];   /* replaced by ptr in *screen */
} Package;

typedef Package * PackagePtr;


static unsigned bits = 0;
#define MSK_PACKAGE 1
#define MSK_SCREEN 2
#define MSK_ELEMENT 4
#define MSK_MAP 8
#define MSK_DIMENSION 16
#define Supress(mask) (bits = bits | mask)
#define Supressed(mask) (bits & mask)
#define Unsupress(mask) (bits = bits & ~mask)


#define VIDBACK 0                 /* background pix */
#define PRIO_2 2                  /* video priority */
#define SETTLE count(5000)
#define MAKE16(z) (z)=((z)+8)&(~0xf)


#define YES 1
#define NO 0

#define TIMECTRL_WIDTH  630 /* pixels in the time control bar */
#define CalculateTime(x,dsp) (x * dsp->duration / TIMECTRL_WIDTH)  
extern int time;
extern int timeinc;
extern int time_is_on;
extern int rate;
extern int timer();
extern int clock;

#define addbutton(w)\
    buttons[buttoncount].name = XtAWindow;\
    buttons[buttoncount].value = (caddr_t)w;\
    buttoncount++;

#define Borderwidth 1
extern Font font;
extern char string[256];
extern FILE *fp;




/************************
*  Event data
*
*	This union is needed to get at the details of an event.  
*	The fact that the Xevent structure and the particular
*	event description structures occupy the same memory is
*	not described in the Xlib documentation.  The detail fields
*	of an event are accessed through this union as   
*			event.keypress.detail  
*	etc.   One other point; the input calls, XNextEvent, etc. need
*	a pointer, therefore the address of the union is passed.
*/

/*
union evnt { XEvent                rep;
	     XKeyPressedEvent      keypress;
	     XButtonPressedEvent   buttpress;
	     XButtonReleasedEvent  buttrelease;
	     XEnterWindowEvent	   enterwin;
	     XLeaveWindowEvent	   exitwin;
	     XMouseMovedEvent      mousemove;
          } event;

*/


#define Screen_sets 10

char *calloc();
char *malloc();
PackagePtr readfile();
PackagePtr first_package, pck, tpck;	   
ElementPtr ele, tele;
ScreenPtr scr, tscr, screen_sets[Screen_sets];
DimensionPtr dim;
MapPtr map, tmap;
int setcount = -1;
int linecount = 0;



union lu {char name[NAMELEN];
	  int val;
       }  lkp, *lkup = &lkp;

#define Key 0
#define Val 1
#define FAILURE -1

#define PACKAGE 1
#define ELEMENT 2
#define NEWSCREEN 3
#define SCREEN 4
#define MAP 5
#define DIMENSION 6
#define INCLUDE 7
SCOPE int signal_unexpected();
SCOPE int getpackage();
SCOPE int getelement();
SCOPE int getscreen();
SCOPE int getmap();
SCOPE int getdimension();

SCOPE int lookup();
SCOPE char * lookup_type();
SCOPE char * lookup_boundary();

SCOPE void resolve_names();
SCOPE void makewindows();
