#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <stdio.h>

#define MT 10

typedef struct _Dimension {
	char    name[256];
	int	param;
	int	(*timer_fn)();
	int	interval;
} Dimension;


Dimension	*dim[MT];
int		*flag[MT];
int 		time[MT];
int		interval[MT];
int		ntimers, cur = -1;

update_timers()
{
  static char		*func = "update_timer";
  struct itimerval  	value, ovalue;
  static int		cur_time, next, next_time;
  static int		same[MT] = {-1};
  static int		set_bit[] = { 1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
  int			i, j = 0;
  static int		same_mask = 0;

	/*  First case handles the first expiration of the first timer,
	*   before `cur' has been set.  If the timer is a one-shot
	*   deal, everthing gets cleared and the timer shut down.
	*   Cur stays at -1 when the last (only here) timer is shut down.
	*   Otherwise, the interval is reset and the current and 
	*   cur_time variables are initialized.  This is a temporary fix.
	*/

for(i=0; i<10; ++i) printf(" %d",time[i]);
printf("\n");
	
  	if(cur == -1 && ntimers) 
  	{
		if(dim[0]) (*dim[0]->timer_fn)(dim[0]->param);
		if(flag[0]) *flag[0] = 1;
		if(interval[0])
		{
			cur = 0;
			cur_time = time[0] = interval[0];

			value.it_interval.tv_sec = 0;
			value.it_interval.tv_usec = 0;
			value.it_value.tv_sec = time[0]/1000;
			value.it_value.tv_usec = (time[0]%1000)*1000;
			if(setitimer(ITIMER_REAL,&value,&ovalue )== -1)
			{
				printf("%s: fault stopping timer\n",
					    func);
				return (-1);
		 	 }

		 }
		else
		{
			time[0] = -1;
			dim[0] = (Dimension *) 0;
			flag[0] = (int *) 0;
			--ntimers;

			value.it_interval.tv_sec = 0;
			value.it_interval.tv_usec = 0;
			value.it_value.tv_sec = 0;
			value.it_value.tv_usec = 0;
			if( setitimer( ITIMER_REAL,&value,&ovalue ) == -1 )
			{
				printf("%s: fault stopping timer");
				return (-1);
			 }
			if( (int)signal( SIGALRM,SIG_DFL ) == -1 )
			{
				printf("%s: fault resetting signal handler\n"
				    ,func);
				return(-1);
		 	 }
		 }
	 }

	/*  Following handles repeat business and multiple timers.
	*   First call the update functions on the dimensions and/or
	*   set the timeout flags on the expired timers.  `Same' array
	*   holds other timers that may be expiring at the same time
	*   as `cur' (routine favors the one-timer case).
	*
	*   Next subtract `cur_time' msec from all timers except `cur' and
	*   any on the `same' list.  Also skip timers not set.  Save
	*   shortest time for the next round.
	*
	*   Next reset `cur' or shut it down.  If any on `same' list,
	*   do them too.  Screen these also to find shortest time.
	*
	*   After all times are updated, go through the list looking
	*   for duplicates of shortest time.  Any found go on `same'
	*   list.  Next slot in `same' not used gets a -1 to mark end.
	*
	*   Finally reset the timer to the shortest time, which
	*   becomes `cur'.
	*/

	else
	{
		if(dim[cur]) (*dim[cur]->timer_fn)(dim[cur]->param);
		if(flag[cur]) *flag[cur] = 1;
		for(i = 0; i < MT && same[i] != -1; ++i)
		{
			if(dim[same[i]]) 
			    (*dim[same[i]]->timer_fn)(dim[same[i]]->param);
			if(flag[same[i]]) *flag[same[i]] = 1;
		 }

		next = cur ? 0 : 1;
		next_time = time[next];
		for(i = next; i < MT; ++i)
		{
			if(i != cur 
			    && time[i] != -1 
			    && ! (same_mask & set_bit[i]))
			{
				if((time[i] -= cur_time) < next_time)
				{
					next = i;
					next_time = time[next];
				 }
			 }
		 }
		if(interval[cur])
		{
			time[cur] = interval[cur];
			if(time[cur] < next_time);
			{
				next = cur;
				next_time = time[cur];
			 }
		 }
		else
		{
			time[cur] = -1;
			dim[0] = (Dimension *) 0;
			flag[0] = (int *) 0;
			if(! (--ntimers))
			{

				value.it_interval.tv_sec = 0;
				value.it_interval.tv_usec = 0;
				value.it_value.tv_sec = 0;
				value.it_value.tv_usec = 0;
				if(setitimer(ITIMER_REAL,&value,&ovalue )== -1)
				{
					printf("%s: fault stopping timer\n",
					    func);
					return (-1);
			 	 }
				if( (int)signal( SIGALRM,SIG_DFL ) == -1 )
				{
				  printf("%s: fault resetting signal handler\n"
				     ,func);
				  return(-1);
		 	 	 }
			 }
		 }

		if(same_mask)
		{
			for( i = 0; i < MT && same[i] != -1; ++i)
			{
				if( interval[same[i]])
				{
					time[same[i]] = interval[same[i]];
					same_mask ^= set_bit[same[i]];
				 }
				else
				{
				  time[same[i]] = -1;
				  same_mask ^= set_bit[same[i]];
				  dim[same[i]] = (Dimension *) 0;
		  		  flag[same[i]] = (int *) 0;
				  interval[same[i]] = 0;
				  if( ! (--ntimers))
				  {
				     value.it_interval.tv_sec = 0;
				     value.it_interval.tv_usec = 0;
				     value.it_value.tv_sec = 0;
				     value.it_value.tv_usec = 0;
				     if(setitimer(ITIMER_REAL,&value
					,&ovalue )== -1)
			  	     {
				        printf("%s: fault stopping timer\n"
					    ,func);
					return (-1);
			 	      }
				     if( (int)signal( SIGALRM,SIG_DFL ) == -1 )
				     {
					printf("%s: fault setting signal handler\n",func);
					return(-1);
		 	 	      }
				    }
				 }
				if( time[same[i]] < next_time)
				{
					next = same[i];
					next_time = time[next];
				 }
			 }

		 }
		j = 0;
		for( i = 0; i < MT; ++i)           /* find duplicates */
		{
			if(time[i] == next_time  && i != next)
			{

				same[j++] = i;
				same_mask |= set_bit[i];
			 }
		 }

		if(j < MT) same[j] = -1;

		cur = next;
		cur_time = next_time;

		value.it_interval.tv_sec = 0;
		value.it_interval.tv_usec = 0;
		value.it_value.tv_sec = time[cur]/1000;
		value.it_value.tv_usec = (time[cur]%1000)*1000;
		if( setitimer( ITIMER_REAL,&value,&ovalue ) == -1 )
		{
			printf("%s: fault setting timer\n",func);
			return (-1);
		 }
		return (0);
	 }
}




start_timer(d, f, msec)
  Dimension	*d;
  int		*f;   
  int		msec;
{
  static char   *func = "start_timer";
  struct itimerval  	value, ovalue;
  int		oldmask;
  int		i;

	oldmask = sigblock ( 1<<SIGALRM );

	for(i = 0; i < MT && time[i] != -1; ++i);
	if( i >= MT)
	{
		printf("%s: no timers left\n", func);
		sigsetmask( oldmask );
		return(-1);
	 }

	dim[i] = d ? d : 0;
	time[i] = msec ? msec : d->interval;
	interval[i] = msec ? 0 : d->interval;
	if(++ntimers == 1)
	{
		if( (int)signal(SIGALRM, update_timers) == -1 )
		{
			printf("%s: setting signal handler\n",func);
			sigsetmask( oldmask );
			return (-1);
		}

		value.it_interval.tv_sec = 0;
		value.it_interval.tv_usec = 0;
		value.it_value.tv_sec = time[i]/1000;
		value.it_value.tv_usec = (time[i]%1000)*1000;
		if( setitimer( ITIMER_REAL,&value,&ovalue ) == -1 )
		{
			printf("%s: fault setting timer\n",func);
			sigsetmask( oldmask );
			return (-1);
		 }
	 }
	sigsetmask( oldmask );
	return(1);
}


stop_timer(d)
   Dimension	*d;
{
   static char  *func = "stop_timer";
   struct itimerval  	value, ovalue;
   int 		oldmask, i;

	oldmask = sigblock ( 1<<SIGALRM );

	for(i = 0; i < MT && dim[i] != d; ++i);
	if( i >= MT)
	{
		printf("%s: dimension `%s' is not currently timed\n"
		    ,func,d->name);
		sigsetmask( oldmask );
		return(0);
	 }
	time[i] = -1;
	dim[i] = (Dimension *) 0;
        flag[i] = (int *) 0;
	if(--ntimers == 0)
	{
		cur = -1;
		value.it_interval.tv_sec = 0;
		value.it_interval.tv_usec = 0;
		value.it_value.tv_sec = 0;
		value.it_value.tv_usec = 0;
		if( setitimer( ITIMER_REAL,&value,&ovalue ) == -1 )
		{
			printf("%s: fault stopping timer");
			sigsetmask( oldmask );
			return (-1);
		 }
		if( (int)signal( SIGALRM,SIG_DFL ) == -1 )
		{
			printf("%s: fault resetting signal handler\n",func);
			sigsetmask( oldmask );
			return(-1);
		 }
	 }
	sigsetmask( oldmask );

}
	

testing(t)
  int   t;
{
  printf("%d\n",t);
}


main()
{

Dimension *a, *b, *c;
int i;

for(i=0; i<MT; ++i) time[i] = -1;

a = (Dimension *)calloc(1, sizeof(Dimension));
strcpy(a->name, "a");
a->interval = 1000;
a->param = 1000;
a->timer_fn = testing;
start_timer(a, 0, 0);

b = (Dimension *)calloc(1, sizeof(Dimension));
strcpy(b->name, "b");
b->interval = 2000;
b->param = 2000;
b->timer_fn = testing;
start_timer(b, 0, 0);

c = (Dimension *) calloc(1, sizeof(Dimension));
strcpy(c->name, "c");
c->interval = 3000;
c->param = 3000;
c->timer_fn = testing;
start_timer(c, 0, 0);


while(1);

}
