#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#define DISPLAYS
#include "dspdefs.h"
#define VDISC extern
#include "vdisc.h"

extern in_region();

  void
display_still(e)
  Element   	*e;
{
  static char   *funcname = "display_still";
  Map		*m = e->current;
  WindowInfo    info;
  int 		status, frame;
  float 	n, off;
  char		s[Nchars];


  	if( ! XQueryWindow(e->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->w);
	 }

	if(m->simple.out <= m->simple.in)
	{
		frame = m->simple.in;
	 }
	else
	{
		n = m->simple.out - m->simple.in;
		off = e->p->dimension[m->simple.key_dimension]->current 
		    + m->simple.in;
		frame = ( off/ n) * n;	
	 }
	sprintf(s,"search %d",frame);
  	sony_cmd(disc->port, s);
  	if((status = XScaleVideo(e->w, 0, 0, 640, 480, 
				0, 0, info.width,info.height)) == -1)
	{
	  	printf("%s: failed XScaleVideo to 0,0,%d,%d in window %d\n",
			funcname,info.width,info.height,m->simple.w);
		exit(1);
	 }
        
}

/*
  void
display_complex(e)
  Element   	*e;
{
  static char   *funcname = "display_complex";
  Map		*m = e->current;
  WindowInfo    *info;
  int 		status;
  CVideo        *cvideo;

printf("%s\n",funcname);

  	if( ! XQueryWindow(e->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
        if(info->mapped == IsUnmapped)
	{
		XMapWindow( (Window) m->simple.w);
	 }


	if (!(cvideo = InitCVideo(m->complex.w, 640, 480, disc->port, 
		m->complex.startframe, m->complex.rows,
	    	m->complex.columns, m->complex.offset, 
		m->complex.xoverlap, m->complex.yoverlap, HORIZONTAL))) 
	{
			printf( "Could not init map.\n");
			exit(3);
	 }
        
}
*/

#define Nspeeds 4
#define VDSC_STEP  1000 /* msec between frames */
#define VDSC_SLOW  165
#define VDSC_PLAY  33
#define VDSC_FAST  11


  int
play_vdisc(disc, d)
  Vdisc  	*disc;
  Dimension	*d;
{
  char		s[Nchars];
  int		sign = d->rate_setting < 0 ? -1 : 1;
  int		i;
  static struct	spd{
			int	val;
			char	fwdcmd[Nchars];
			char    revcmd[Nchars];
		     }  speed[4] = {	VDSC_FAST, "ffast", "rfast",
			      		VDSC_PLAY, "fplay", "rplay",
			      		VDSC_SLOW, "fslow", "rslow",
			      		VDSC_STEP, "fstep", "rstep" 
			      	      };

	for(i = 0; i < Nspeeds && speed[i].val < (d->rate_setting *sign);++i);
	if(i > Nspeeds) i = Nspeeds;
        if(sign < 0)
	{
		sprintf(s,speed[i].revcmd);
	 }
	else
	{
		sprintf(s,speed[i].fwdcmd);
	 }		
	sony_cmd(disc->port, s);
	d->rate = speed[i].val * sign;
	d->interval = speed[i].val;
	return (speed[i].val);
}

boundary_video(e,d,disc)
  Element	*e;
  Dimension	*d;
  Vdisc		*disc;
{
  char		*funcname = "boundary_video";
  char		s[Nchars];
  int 		n, status;
  WindowInfo    info;

	switch(d->boundary)  /* Note: EXPIRE handled in setpos */
  	{
		case WRAP:
			disc->operation = VDSC_STOPPED;
			display_video(e);
			break;
		case FREEZE:
			sprintf(s, "still");
			sony_cmd(disc->port, s);
		  	if( ! XQueryWindow(e->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }

			if((status = XStillVideo(e->w,0,0,
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    funcname, e->w);
				exit(1);
	 		 }

			disc->operation = VDSC_STOPPED;
			break;
		case BOUNCE:
			d->rate_setting *= -1;
			n = play_vdisc(disc, d);
			if((status = XStartVideo(e->w, 0,0,3)) == -1)
			{
				printf("%s: failed XStartVideo\n"
				    ,funcname);
				exit(1);
	 		 }		
			disc->operation = n;	
			break;
		case LIMIT:
			sprintf(s, "still");
			sony_cmd(disc->port, s);
		  	if( ! XQueryWindow(e->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }

			if((status = XStillVideo(e->w,0,0,
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    funcname, e->w);
				exit(1);
	 		 }
			disc->operation = VDSC_STOPPED;
			d->rate = d->rate_setting = 0;
			break;
	}
}


  void
display_video(e)
  Element   	*e;
{
  static char   *funcname = "display_video";
  Map		*m = e->current;
  Dimension	*d = e->p->dimension[m->simple.key_dimension];
  WindowInfo    info;
  int 		status, rate, rf, frame;
  float		n, off;
  char		s[Nchars];
  int		zero = 0;
  
  	if( in_region(e->p, m))
	{
   		if( disc->operation == VDSC_STOPPED )
   		{
  			if( ! XQueryWindow(e->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
        		if(info.mapped == IsUnmapped)
			{
				XMapWindow( (Window) e->w);
	 	 	 }
			n = m->simple.out - m->simple.in;
			off = e->p->dimension[m->simple.key_dimension]->current
		   	    + m->simple.in;
			frame = ( off/ n) * n;	

			sprintf(s,"search %d",frame);
  			sony_cmd(disc->port, s);
  			if((status = XStillVideo(e->w, 0, 0, 
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo to 0,0,%d,%d\n",
			    	    funcname,info.width,info.height);
				exit(1);
	 	 	 }

	 		if(d->rate_setting != 0)
			{
				disc->controlling_element = e;
					/* Control can be taken if the disc is 
					*  stopped.
					*/
				n = play_vdisc(disc, d);
  				if((status = XStartVideo(e->w, 0,0,3)) == -1)
				{
	  				printf("%s: failed XStartVideo\n"
					    ,funcname);
					exit(1);
	 			 }		
				disc->operation = n;
				stop_timer(d);

				start_timer(d, &zero, 0);
	 	 	 }
		 }
		else		/* disc is playing -- watch for end  */
		{
			if((     (d->rate < 0 && d->current == d->min)
			     ||  (d->rate > 0 && d->current == d->max))
			     &&  (disc->controlling_element == e)  )
			{
				boundary_video(e,d,disc);
			 }
		 }
    	 }
	else		/*  element is out of bounds  */
	{
	        if(info.mapped == IsMapped)
		{
			XUnmapWindow( (Window) m->simple.w);
	 	 }
		if((     (d->rate < 0 && d->current == d->min)
		     ||  (d->rate > 0 && d->current == d->max))
		     &&  (disc->controlling_element == e)  )
		{
			sprintf(s, "still");
			sony_cmd(disc->port, s);
			disc->operation = VDSC_STOPPED;
		 }
	 }		
}


  void
display_text(e)
  Element   	*e;
{
  static char   *funcname = "display_text";
  Map		*m = e->current;
  WindowInfo    info;
  int 		status;
  char		s[Nchars];

printf("%s\n",funcname);

  	if( ! XQueryWindow(m->simple.w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) m->simple.w);
	 }
	sprintf(s,"search %d",m->simple.in);
  	sony_cmd(disc, s);
  	if((status = XScaleVideo(m->simple.w, 0, 0, 640, 480, 
				0, 0, info.width,info.height)) == -1)
	{
	  	printf("%s: failed XScaleVideo to 0,0,%d,%d in window %d\n",
			funcname,info.width,info.height,m->simple.w);
		exit(1);
	 }
       
}



  void
display_TKwidget(e)
  Element   	*e;
{
  static char   *funcname = "display_TKwidget";
  Map		*m = e->current;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *maplist;
  Mapped_items		  *tmp, *newlist = 0;

  extern struct maplist 	  *find_all_maps();

 	maplist = (struct maplist *)find_all_maps(e);

  	while( maplist != 0 && maplist->map != 0)
  	{
		for(tmp = e->mapped_items; tmp && tmp->map != maplist->map; 
		    tmp = tmp->next);
		if( tmp)
		{
			if(tmp->prev) tmp->prev->next = tmp->next;
			if(tmp->next) tmp->next->prev = tmp->prev;
			if(tmp == e->mapped_items && !tmp->next)
				e->mapped_items = 0;
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		else
		{
  			if( !XMapWindow( (Window) maplist->map->simple.w))
			{
	  			printf("%s: failed XMapWindow\n", funcname);
				exit(1);
	 	 	 }
			if((tmp = (Mapped_items *)
			    calloc(1, sizeof(Mapped_items))) == 0)
			{
	  			printf("%s: failed calloc mapped_items\n"
				    ,funcname);
				exit(1);
			 }
			tmp->map = maplist->map;
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		maplist = maplist->next;			
	  }
	while( e->mapped_items != 0)
	{
		if( !XUnmapWindow( (Window) e->mapped_items->map->simple.w))
		{
			printf("%s: failed XUnmapWindow\n", funcname);
			exit(1);
	 	 }
		tmp = e->mapped_items;
		e->mapped_items = e->mapped_items->next;
		free(tmp);
	        e->mapped_items = 0;
	  }
	if(newlist) e->mapped_items = newlist;
	XFlush();        
}










