#include </mit/StaffTools/include/X/Xtlib.h>

typedef struct _Button{
	  int 		 selected;
	  Window 	 w, parent;
	  int 		 x, y, width, height, borderwidth;
	  int 		 foreground, background, border;
	  Pixmap 	 foreground_pixmap, background_pixmap, border_pixmap;
	  char 		 name[Nchars], parentname[Nchars], label[Nchars];
	  char		 fontname[Nchars];
	  FontInfo	 *font;
	  void		 (*function)();
	  char		 parameter[Nchars];
	  char           *ptrparam;
	  int		 param_type;
	  int		 notify;
	} Button;


static Arg buttonarglist[] = {
	{XtNname,	(caddr_t) "name"},
       	{XtNlabel,      (caddr_t) "label"},
	{XtNfont,       (caddr_t) NULL}, 
	{XtNborderWidth,(caddr_t) 1},
	{XtNforeground, (caddr_t) BlackPixel},
	{XtNbackground, (caddr_t) WhitePixel},
	{XtNborder,     (caddr_t) NULL}, 
	{XtNjustify,    (caddr_t) XtjustifyCenter},
    	{XtNfunction,	(caddr_t) NULL},
	{XtNinternalWidth, (caddr_t) 4}, 
	{XtNinternalHeight, (caddr_t) 2}, 
	{XtNparameter,	(caddr_t) NULL},
     	{XtNnotify,      (caddr_t) ButtonPressed}, 
	{XtNx,           (caddr_t) 0}, 
        {XtNy,           (caddr_t) 0}, 
/*
	{XtNreason,      (caddr_t) NULL}, 
	{XtNeventBindings, (caddr_t) NULL},
	{XtNsensitive,   (caddr_t) NULL} 
*/
    };

#define XtkButtonName 		0
#define XtkButtonLabel		1
#define XtkButtonFont		2
#define XtkButtonBorderwidth	3
#define XtkButtonForeground	4  
#define XtkButtonBackground	5
#define XtkButtonBorder		6
#define XtkButtonJustify	7
#define XtkButtonFunction	8
#define XtkButtonIntWidth 	9
#define XtkButtonIntHeight	10
#define XtkButtonParameter	11
#define XtkButtonNotify		12
#define XtkButtonX		13
#define XtkButtonY		14
/*
#define XtkButtonReason		15
#define XtkButtonEventBindings	16
#define XtkButtonSensitive	17
*/

/*--------------------------------------------------*/

typedef struct _TKscrollbar{
	  int 		 selected;
	  Window 	 w, parent;
	  char		 value[Nchars], orientation[Nchars];
	  int 		 x, y, width, height, borderwidth;
	  int 		 foreground, background, border;
	  Pixmap 	 foreground_pixmap, background_pixmap, border_pixmap;
	  char 		 name[Nchars], parentname[Nchars];
	  void		 (*scrollupdownproc)();
	  void		 (*thumbproc)();
	  float		 top, shown;
	} TKscrollbar;


static Arg TKscrollbararglist[] = {
	{XtNname,		(caddr_t) "name"},
       	{XtNwindow,     	(caddr_t) NULL},
	{XtNorientation,	(caddr_t) XtorientHorizontal},
       	{XtNvalue,      	(caddr_t) NULL}, 
	{XtNx,          	(caddr_t) 0}, 
        {XtNy,          	(caddr_t) 0}, 
	{XtNwidth,		(caddr_t) 10}, 
	{XtNheight,		(caddr_t) 20}, 
	{XtNborderWidth,	(caddr_t) 1},
	{XtNforeground, 	(caddr_t) NULL},
	{XtNbackground, 	(caddr_t) NULL},
	{XtNborder,     	(caddr_t) NULL}, 
	{XtNscrollUpDownProc,   (caddr_t) NULL},
    	{XtNthumbProc,		(caddr_t) NULL},
	{XtNtop, 		(caddr_t) NULL}, 
	{XtNshown, 		(caddr_t) NULL} 
    };

#define XtkScrollbarName 	0
#define XtkScrollbarWindow	1
#define XtkScrollbarOrientation	2
#define XtkScrollbarValue	3
#define XtkScrollbarX		4
#define XtkScrollbarY		5
#define XtkScrollbarWidth	6
#define XtkScrollbarHeight	7
#define XtkScrollbarBorderwidth	8
#define XtkScrollbarForeground	9
#define XtkScrollbarBackground	10
#define XtkScrollbarBorder	11
#define XtkScrollbarScrollproc	12
#define XtkScrollbarThumbproc	13
#define XtkScrollbarTop		14
#define XtkScrollbarShown	15


/*-------------------------------------------*/

typedef struct _TKtext{
	  int 		 selected;
	  Window 	 w, parent;
	  int 		 x, y, width, height,length,borderwidth;
	  int 		 foreground, background, border;
	  Pixmap 	 foreground_pixmap, background_pixmap, border_pixmap;
	  char 		 name[Nchars], parentname[Nchars];
	  char		 file[Nchars], string[Nchars], event_bindings[Nchars];
 	  int		 options;
	  int 		 display_pos, insert_pos, left_margin;  
	  FontInfo	 *font;
	  XtEditType     edit_type;
	} TKtext;


static Arg TKtextarglist[] = {
	{XtNname,	(caddr_t) "text"},
	{XtNeditType,	(caddr_t) XttextRead},
	{XtNtextOptions, (caddr_t) NULL},
	{XtNdisplayPosition, (caddr_t) 0},
	{XtNinsertPosition, (caddr_t) 0},
	{XtNleftMargin, (caddr_t) 2},
	{XtNforeground, (caddr_t) NULL},
	{XtNbackground, (caddr_t) NULL},
	{XtNborder, (caddr_t) NULL},
	{XtNborderWidth, (caddr_t) 4},
	{XtNfile, (caddr_t) NULL},
	{XtNstring, (caddr_t) NULL},
	{XtNlength, (caddr_t) 200},
	{XtNfont, (caddr_t) NULL},
	{XtNeventBindings, (caddr_t) NULL},
	{XtNwidth, (caddr_t) 100},
	{XtNheight, (caddr_t) 20}
	};


#define XtkTextName		0
#define XtkTextWindow           1
#define XtkTextEditType         2
#define XtkTextOptions		3	
#define XtkTextDisplayPosition	4
#define XtkTextInsertPosition	5
#define XtkTextLeftMargin	6
#define XtkTextForeground	7
#define XtkTextBackground	8
#define XtkTextBorder		9
#define XtkTextBorderWidth	10
#define XtkTextFile		11
#define XtkTextString		12
#define XtkTextLength		13
#define XtkTextFont		14
#define XtkTextEventBindings	15
#define XtkTextWidth		16
#define XtkTextHeight 		17
#define XtkTextX		18
#define XtkTextY		19


/*-------------------------------------------*/

typedef struct _Dialog_Butt{
	  char		 label[Nchars];
/*	  char		 function[Nchars]; */
	  void		 (*function)();	 
	  char		 parameter[Nchars];
	  int		 param_type; 
	} Dialog_Butt;

typedef struct _Dialog{
	  int 		 selected;
	  Window 	 w, parent;
	  int 		 x, y, width, height, borderwidth;
	  int 		 foreground, background, border;
	  Pixmap 	 foreground_pixmap, background_pixmap, border_pixmap;
	  char 		 name[Nchars], parentname[Nchars], label[Nchars];
	  char		 *entryptr[Nchars];
	  Dialog_Butt    *button;

	} Dialog;



static Arg Dialogarglist[] = {
	{XtNname,	(caddr_t) "name"},
	{XtNborderWidth,(caddr_t) 1},
	{XtNwidth, (caddr_t) 10}, 
	{XtNheight, (caddr_t) 10},
	{XtNforeground, (caddr_t) BlackPixel},
	{XtNbackground, (caddr_t) WhitePixel},
	{XtNborder,     (caddr_t) NULL},
	{XtNdefaultDistance, (caddr_t) 4},

	{XtNjustify,    (caddr_t) XtjustifyCenter},
    	{XtNfunction,	(caddr_t) NULL},
	{XtNparameter,	(caddr_t) NULL},
       	{XtNnotify,      (caddr_t) ButtonPressed}, 
	{XtNx,           (caddr_t) 0}, 
        {XtNy,           (caddr_t) 0}, 
       	{XtNlabel,      (caddr_t) "label"},
    };


#define XtkDialogName 		0
#define XtkDialogBorderwidth	1
#define XtkDialogIntWidth 	2
#define XtkDialogIntHeight	3
#define XtkDialogForeground	4  
#define XtkDialogBackground	5
#define XtkDialogBorder		6
#define XtkDialogDefaultDistance 7

#define XtkDialogJustify	8
#define XtkDialogFunction	9
#define XtkDialogParameter	10
#define XtkDialogNotify		11
#define XtkDialogX		12
#define XtkDialogY		13
#define XtkDialogLabel		14
