typedef long Window;
typedef long Font;
/* at the bottom... union is commented out */


/************* 
*  Map 
*/
#define IN 0
#define OUT 1
#define MAXDIMS 5
#define MAXSTR 256
#define NAMELEN 64
typedef int Position;
typedef struct _Map{    
  struct _Map *cnext;
  struct _Map *cprev;
  int time; /* to be replaced w/ posn spec on n dims */
  Position p[2][MAXDIMS];      /* defines range on n dims */
  long in;
  long out;
  long icon;
  int selected;
  char text[MAXSTR];
} Map;

typedef Map * MapPtr;
 
Map txta, *text = &txta;
Map vdeo, *video = &vdeo;

/******************
*  Dimension
*/
#define WRAP 1                 /* display topologies */
#define FREEZE 2
#define BOUNCE 3
#define LIMIT 4

typedef struct _Dimension {
  int min;             /* minimum value on this dim */
  int max;
  int current;         /* current pos'n on this dim */
  int range;           /* what extent is being displayed, rel. to current */
  int boundary;          /* WRAP, FREEZE, BOUNCE, LIMIT */
  char name[NAMELEN]
 } Dimension;

typedef Dimension * DimensionPtr;
/********************
*  Screen elements
*/
typedef struct _Screen_ele{
  struct _Screen_ele *cnext;   /* next in system chain */
  struct _Screen_ele *cprev;   
  struct _Screen_ele *next;    /* next in user's chain */
  struct _Screen_ele *prev;
  Window w;
  int type;
  int mapped;
  int selected;
  char name[NAMELEN];
  char nextname[NAMELEN];      /* replaced by ptr in *next above */
} Screen_ele;

typedef Screen_ele * ScreenPtr;


/********************
*  Display elements
*/
#define OFF 0
#define TEXT_TYPE 1
#define VIDEO_TYPE 2
#define DISP_TYPE 3

#define STOPPED 0
#define PAUSE 1
#define PLAYING 2

typedef struct _Dsp_ele{
  struct _Dsp_ele *cnext;       /* system chain */
  struct _Dsp_ele *cprev;
  struct _Dsp_ele *next;        /* user chain */
  struct _Dsp_ele *prev;
  Screen_ele *scrn_ele;         /* where displayed */
  int on;                       /* on the screen or not */
  int type;                     /* text, video, etc. */
  int state;                    /* video playing or not */
  Map *map;                     /* head of item list */
  Map *now_showing;
  int current_frame;
  int init_active;               /* active at startup? */
  int selected;
  char file[NAMELEN];           /* data for compound elements */
  char name[NAMELEN];
  char nextname[NAMELEN];       /* replaced by ptr in *next */
} Dsp_ele;

typedef Dsp_ele * ElementPtr;

/*********************
*  Display
*/

typedef struct _Display{
  struct _Display *cnext;      /* system chain */
  struct _Display *cprev;
  struct _Display *next;       /* edit list pointer  */
  Dsp_ele *ele;                /* list of display elements */
  Screen_ele *screen;          /* list of screen elements */
  Dimension *dims[MAXDIMS];    /* array of dimensions */
  int ndims;                   /* how many dimensions */
  int geom;                    /* linear, manifold, etc. see dimension? */
  int duration;                /* how many clock ticks at 1/30th sec --tmp*/
  int init_active;              /* active at startup? */
  int selected;
  char name[NAMELEN];
  char nextname[NAMELEN];      /* replaced by ptr in *next */
  char screen_name[NAMELEN];   /* replaced by ptr in *screen */
} Display;

typedef Display * DisplayPtr;


static unsigned bits = 0;
#define MSK_DISPLAY 1
#define MSK_SCREEN 2
#define MSK_ELEMENT 4
#define MSK_MAP 8
#define MSK_DIMENSION 16
#define Supress(mask) (bits = bits | mask)
#define Supressed(mask) (bits & mask)
#define Unsupress(mask) (bits = bits & ~mask)


#define FAILURE 0
#define VIDBACK 0                 /* background pix */
#define PRIO_2 2                  /* video priority */
#define SETTLE count(5000)
#define MAKE16(z) (z)=((z)+8)&(~0xf)


#define YES 1
#define NO 0

#define TIMECTRL_WIDTH  630 /* pixels in the time control bar */
#define CalculateTime(x,dsp) (x * dsp->duration / TIMECTRL_WIDTH)  
extern int time;
extern int timeinc;
extern int time_is_on;
extern int rate;
extern int timer();
extern int clock;

#define addbutton(w)\
    buttons[buttoncount].name = XtAWindow;\
    buttons[buttoncount].value = (caddr_t)w;\
    buttoncount++;

#define BORDERWIDTH 1
extern Font font;
extern char string[256];
extern FILE *fp;




/************************
*  Event data
*
*	This union is needed to get at the details of an event.  
*	The fact that the Xevent structure and the particular
*	event description structures occupy the same memory is
*	not described in the Xlib documentation.  The detail fields
*	of an event are accessed through this union as   
*			event.keypress.detail  
*	etc.   One other point; the input calls, XNextEvent, etc. need
*	a pointer, therefore the address of the union is passed.
*/

/*
union evnt { XEvent                rep;
	     XKeyPressedEvent      keypress;
	     XButtonPressedEvent   buttpress;
	     XButtonReleasedEvent  buttrelease;
	     XEnterWindowEvent	   enterwin;
	     XLeaveWindowEvent	   exitwin;
	     XMouseMovedEvent      mousemove;
          } event;

*/



