#define YES 1
#define NO 0

typedef struct element {
  struct element *cnext;
  struct element *cprev;
  struct element *next;
  int type;  /* video, text, or display */
  char    nextname[30];
  char    name[30];  /* name of display sequence */
  int     active;   /* is it active at start */
  char file[80];
} Element;

typedef struct element * ElementPtr;

typedef struct screen {
  struct screen *cnext;
  struct screen *cprev;
  char    nextname[30];
  char    name[30];  /* name of display sequence */
  int     active;   /* is it active at start */
  int type;
} Screen;

typedef struct screen * ScreenPtr;

typedef struct display {
  struct display *cnext;
  struct display *cprev;
  char    nextname[30];
  char    name[30];  /* name of display sequence */
  int     active;   /* is it active at start */
  int type;
  int geom;
  Element *ele;  /* video element */
  Screen *scr;
} Display;

typedef struct display * DisplayPtr;

char *calloc();
char *malloc();
DisplayPtr readfile();
DisplayPtr dsp1, dsp, tdsp;	   
ElementPtr ele, tele;
ScreenPtr scr, tscr;
int linecount = 0;

#define MAXSTR 	255
#define FAIL	1
#define SUCCESS	0

static unsigned bits = 0;
#define SCREEN 2
#define ELEMENT 4
#define Supress(mask) (bits = bits | mask)
#define Supressed(mask) (bits & mask)
#define Unsupress(mask) (bits = bits & ~mask)

