
/* tdriv.h */

/* RMS: latest mod, October 1 */

#ifndef TDRIV_H
#define TDRIV_H

typedef int (*METHOD)();

typedef struct 
{
	int		fd;		/* the file for talking */
	char		port[16];	/* tty_port name - for debugging */
	char		model[32];	/* manufacturer's name */
	char		devname[32];	/* logical name */
	char		volume[32];	/* what's currently mounted */

	struct	/* don't count on these; not fully working yet */
	{
		unsigned	busy :		1;
		unsigned	video_on :	1;
		unsigned	audio1_on :	1;
		unsigned	audio2_on :	1;
		unsigned	indexon :	1;
		unsigned	volume_loaded : 1;
		unsigned	searching :	1;
		unsigned	recording :	1;
		unsigned	segplaying :	1;
	}		state;

	METHOD		reset;		/* no args */
	METHOD		cmd;		/* 1 arg; see below */
	METHOD		search;		/* ( frame, wait ) */
	METHOD		segplay;	/* ( fr1, fr2, wait ) */
	METHOD		getframe;	/* no args */
	METHOD		varspeed;	/* 1 arg; see below */
	METHOD		jog;		/* jog( 1 arg; +- n frames ); */
	METHOD		record;		/* (disabled) */

} RPD, *RPD_ptr;

RPD_ptr	rpdutil_open();
RPD_ptr	rpdutil_close();

/* standard defined speeds */

#define R_MAX		0		/* maximum possible velocity */
#define R_VERY_FAST	1		/* really moving along */
#define R_FAST		2		/* 3-5 times normal; still visible */
#define R_PLAY		3		/* reverse normal */
#define R_SLOW		4		/* 1/2 to 1/5 normal */
#define R_VERY_SLOW	5		/* just barely moving */
#define STOP		6		/* transport halted */
#define F_VERY_SLOW	7		/* just barely moving */
#define F_SLOW		8		/* 1/2 to 1/5 normal */
#define F_PLAY		9		/* forward normal */
#define F_FAST		10		/* 3-5 times normal; still visible */
#define F_VERY_FAST	11		/* really moving along */
#define F_MAX		12		/* maximum possible velocity */

/* standard defined cmds */

#define INDEX_ON		0
#define INDEX_OFF		1
#define A1_ON			2
#define A1_OFF			3
#define A2_ON			4
#define A2_OFF			5
#define LOAD			6
#define UNLOAD			7

#endif
