/* 
 * scr.c - modifies demo1; adds a scroll bar
 *
 * Make executable with:
 *	cc -o demo1 demo1.c -lXt -lX
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>

static void ButtonAction(tag)
caddr_t tag;
{
    printf("Button Pressed\n");
}




static char ButtonLabel[] = "Press Me";
static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) ButtonLabel},
    {XtAFunction, (caddr_t) ButtonAction},
    {NULL, NULL}	/* needed to terminate argument list */
};



static void Scr1(scrW, cliW, intpos)
  Window scrW;
  Window cliW;
  int intpos;
{
  printf("pos %d\n",intpos);
}

static void Thmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{
  printf("top percent %.2f  shown percent %.2f\n",tp,sp);
}
  
static Arg scrargs[] = {
  {XtAOrientation, (caddr_t) XtAhorizontal},
  {XtAWidth, (caddr_t) 200},
  {XtAHeight, (caddr_t) 15},
  {XtAScrollUpDownProc, (caddr_t) Scr1},
  {XtAThumbProc, (caddr_t) Thmb},
  {NULL, NULL}
};


void main()
{
    Display  *d;
    Window   bw;	/* button window */
    Window   sw;  /*scroll window */

    d = XOpenDisplay(NULL);

    XtInitToolkit();

    bw = XtCreateCommand(RootWindow, buttonArgs);

    /* widget clients normally position, size and map widget windows */
    XMoveWindow(bw, 100, 100);
    XMapWindow(bw);


    sw = XtCreateScrollBar(RootWindow, scrargs);

    XMoveWindow(sw, 200,200);
    XMapWindow(sw);

    for(;;) {
	XEvent ev;

	XNextEvent(&ev);		/* Get next event */
	(void) XtDispatchXEvent(&ev);	/* Hand it to Toolkit Dispatcher */
    }
}
