/* Unexec function for Solaris 2.x
   Copyright (C) 1994 Board of Trustees, University of Illinois

This file is part of XEmacs.

XEmacs is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

XEmacs is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with XEmacs; see the file COPYING.  If not, write to the Free
Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* #pragma ident "@(#) $Id: unexsol2.c,v 1.2 1996/04/08 19:51:58 ghudson Exp $" */

#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>

#define DYNO_ENV	"DYNODUMP"
#define DYNODUMP_SO	"../dynodump/dynodump.so"
#define DYNODUMP	"dynodump"

int
unexec(char *new_name, char *old_name, unsigned int data_start,
       unsigned int bss_start, unsigned int entry_address)
{
    char *obj;
    void *handle;
    void (*func)(const char *file);

    if ((obj = getenv(DYNO_ENV)) == NULL)
	obj = DYNODUMP_SO;

    if ((handle = dlopen(obj, RTLD_LAZY)) == NULL)
	fatal("Can't open %s\n", obj);

    if ((func = (void (*)(const char *)) dlsym(handle, DYNODUMP)) == NULL)
	fatal("Can't find %s symbol\n", DYNODUMP);

    (*func)(new_name);

    dlclose(handle);

    return 0;
}
