# Copyright (c) 1995 by the Student Information Processing Board
# 	  of the Massachusetts Institute of Technology
#  
# Permission to use, copy, modify, and distribute this software
# and its documentation for any purpose and without fee is
# hereby granted, provided that the above copyright notice
# appear in all copies and that both that copyright notice and
# this permission notice appear in supporting documentation,
# and that the names of M.I.T. and the M.I.T. S.I.P.B. not be
# used in advertising or publicity pertaining to distribution
# of the software without specific, written prior permission.
# M.I.T. and the M.I.T. S.I.P.B. make no representations about
# the suitability of this software for any purpose.  It is
# provided "as is" without express or implied warranty.
#
#	$Id: disksetup.sh,v 1.2 1996/06/01 18:37:28 ghudson Exp $
#	$Source: /afs/sipb/project/sipb-athena/src/install/arch/i386_nbsd1/RCS/disksetup.sh,v $

# /tmp/vars inputs:
#	disk		disk device containing NetBSD partition
#	start		starting sector of NetBSD partition
#	size		ending sector of NetBSD partition
#	cylinders	number of cylinders on $disk
#	heads		number of tracks per cylinder on $disk
#	sectors		number of sectors per track on $disk
#	create		whether we need to create the partition
#	rootsize	sectors for root subpartition
#	swapsize	sectors for swap subpartition
#	cachesize	sectors for cache subpartition
#	u1size		sectors for u1 subpartition
#	u1cachesize	megabytes for cache if located in /u1 partition.

# /tmp/vars outputs:
#	u1letter	letter of /u1 subpartition

. /tmp/vars

if [ -z "$disk" ]; then
	echo "Please run /disksetup to select or create a NetBSD partition."
	exit 1
fi

case "$disk" in
	wd*)	type=ST506	;;
	sd*)	type=SCSI	;;
esac
if [ "$cachesize" -eq 0 ]; then u1letter=e; else u1letter=f; fi
total_sectors=`expr "$cylinders" "*" "$heads" "*" "$sectors"` # XXX
swapoffset=`expr "$offset" + "$rootsize"`
cacheoffset=`expr "$swapoffset" + "$swapsize"`
u1offset=`expr "$cacheoffset" + "$cachesize"`

cat > /tmp/label << EOM
temp|NetBSD installation generated:\\
	:dt=${type}:ty=winchester:\\
	:nc#${cylinders}:ns#${sectors}:nt#${heads}:se#512:\\
	:pa#${rootsize}:oa#${start}:ta=4.2BSD:ba#8192:fa#1024:\\
	:pb#${swapsize}:ob#${swapoffset}:tb=swap:\\
	:pc#${size}:oc#${start}:\\
	:pd#${total_sectors}:od#0:\\
EOM
if [ "$cachesize" -eq 0 ]; then
	cat >> /tmp/label << EOM
	:pe#${cachesize}:oe#${cacheoffset}:te=4.2BSD:be#8192:fe#1024:\\
	:pf#${u1size}:of#${u1offset}:tf=4.2BSD:bf#8192:ff#1024:
EOM
else
	cat >> /tmp/label << EOM
	:pe#${u1size}:oe#${u1offset}:te=4.2BSD:be#8192:fe#1024:
EOM
fi

if [ "$create" = "yes" ]; then
	# Find a free partition on the selected disk.
	eval `fdisk /dev/r${disk}d 2>&1 | awk '
		/^The data for part/	{ n = $5; }
		/<UNUSED>|size 0/	{ printf "freepart=%d;", n; exit 0; }'`
	if [ -z "$freepart" ]; then
		echo "Couldn't find a free partition on ${disk}."
		exit 1
	fi
	# Set the free partition to the given values.
	echo "n" > /tmp/fdiskcmd
	yes "n" | head "-$freepart" >> /tmp/fdiskcmd
	echo "y" >> /tmp/fdiskcmd
	echo "165" >> /tmp/fdiskcmd
	echo "$start" >> /tmp/fdiskcmd
	echo "$size" >> /tmp/fdiskcmd
	echo "n" >> /tmp/fdiskcmd
	echo "y" >> /tmp/fdiskcmd
	yes "n" | head -`expr 3 - "$freepart"` >> /tmp/fdiskcmd
	echo "n" >> /tmp/fdiskcmd
	echo "y" >> /tmp/fdiskcmd
	fdisk -u /dev/r${disk}d < /tmp/fdiskcmd > /dev/null || exit 1
else
	echo ""
	echo "Please confirm that you wish to overwrite the NetBSD partition"
	echo -n " on disk $disk by typing 'yes': "
	read resp
	if [ "$resp" != "yes" ]; then
		exit 1
	fi
fi

echo ""
echo "Initializing disk ${disk}..."

# Write the NetBSD partition table and make the NetBSD partition bootable.
disklabel -w -B $disk temp || exit 1

# Make the root subpartition.  /tmp will be a symlink to /u1/tmp; make sure
# that /tmp is available (as /rtmp) in single-user mode by making a /u1/tmp
# symlink to /rtmp before mounting /u1.  Also make other directories where
# filesystems will be mounted.
newfs /dev/r${disk}a || exit 1
mount -o async /dev/${disk}a /hd || exit 1
mkdir -m 755 /hd/u1 /hd/afs /hd/kern /hd/proc
mkdir -m 1777 /hd/rtmp
ln -s /rtmp /hd/u1/tmp

# Make the /u1 subpartition.
newfs /dev/r${disk}${u1letter} || exit 1
mount -o async /dev/${disk}${u1letter} /hd/u1 || exit 1
mkdir -m 755 /hd/u1/var /hd/u1/usr
mkdir -m 1777 /hd/u1/tmp

# Make /tmp, /usr, and /var symlinks into /u1.
ln -s u1/tmp /hd/tmp
ln -s u1/usr /hd/usr
ln -s u1/var /hd/var

# Make the cache subpartition if we have one.
if [ "$cachesize" -ne 0 ]; then
	mkdir -p /hd/u1/usr/vice/cache
	newfs /dev/r${disk}e || exit 1
	mount -o async /dev/${disk}e /hd/u1/usr/vice/cache || exit 1
fi

cat >> /tmp/vars << EOM
u1letter="$u1letter"
EOM
