/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/sipb/project/sipb-athena/olh/motif/RCS/menupath.c,v $
 *      $Id: menupath.c,v 1.1 1992/05/01 17:09:39 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include "global.h"
#include "menu.h"
#include "menupath.h"

#include "Xm/Mu.h"
char *menupath;
int mp_size = 0;
static not_init = 1;


void
init_menupath()
{
  menupath = XtMalloc(1024);	/* malloc an extra for trailing null. */
  mp_size = 1023;
  menupath[0] = '\0';
  not_init = 0;
}

void
add_to_menupath(e)
     MenuEntry *e;
{
  char *val;
  int len;

  if (not_init) init_menupath();
  val = field_value(e, POINTER);
  len = strlen(menupath);
  resize_menupath(strlen(val) + len + 1); /* add 1 for PATH_SEP */

  menupath[len] = PATH_SEP_CHAR;
  menupath[len+1] = '\0';
  strcat(menupath, val);
}

void
resize_menupath(size)
     int size;
{
  if (size > mp_size)
    {
      mp_size = size;
      menupath = XtRealloc(menupath, mp_size+1); /* add one for final null */
    }
}


void
make_parents_menupath(e)
     MenuEntry *e;
{
  if (not_init) init_menupath();
  set_menupath(e);

  add_parent_to_menupath(e);
}

long
add_parent_to_menupath(e)
     MenuEntry *e;
{
  char *val;
  static int done = 0;
  MenuEntry *e2;
  long code;
  int menu_len, val_len;

  if (e == NULL) {
    MuWarningSync("Error in token");
    return(1);
  }

  if (strcmp(field_value(e,NODE_ID),"top_menu") == 0) 
    {
      done = 0;
      return(0);
    }

  if ((e == NULL)
      || !strcmp((val = field_value(e, PARENT)), "")
      || !strcmp(val, top_pointer))
    {
      done = 1;
      val = top_pointer;
    }

  menu_len = strlen(menupath);
  val_len = strlen(val);

  resize_menupath(val_len + menu_len + 1); /* add 1 for PATH_SEP */

  bcopy(menupath, menupath+val_len+1, menu_len+1);   /* copy */
			/* the null too, and leave space for the semicolon. */
			/* bcopy is used because it will do the right */
			/* thing if the areas overlap. */
  strncpy(menupath+1, val, val_len);
  menupath[0] = PATH_SEP_CHAR;

  if (done)
    {
      done = 0;
      return(0);
    }

  code = pointerEntry(val, &e2);
  if (code || (!e2)) {
    if (code != 0)
      com_err(program,code,"constructing menupath");
    else
      MuWarningSync("Error in token");
    return(1);
  }
  return(add_parent_to_menupath(e2));
}


long
menupath_from_string(text)
     char *text;
{
  long code;
  MenuEntry *e;
  char *ptr;

  strcpy(menupath, text);

  /* Skip the first PATH_SEP_CHAR, and terminate the string to get the */
  /* pointer name of the first element in the path. */
  ptr = index(text+1, PATH_SEP_CHAR);
  if (ptr != NULL)
    ptr[0] = '\0';
 
  /* Find the entry corresponding to the first element (skip the leading */
  /* PATH_SEP_CHAR), then add all the parents of that entry. */

  code = pointerEntry(text+1, &e);
  if (code || (!e))
    e = NULL;
  return(add_parent_to_menupath(e));
}
