#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "owl.h"


void owl_process_command(char *buff) {
  char **argv;
  int argc;
  char *tmpbuff;

  tmpbuff=strdup(buff);
  argv=owl_parseline(buff, &argc);
  if (argc < 0) {
    owl_function_makemsg("Unbalanced quotes");
    return;
  }
  
  if (argc < 1) return;

  if (!strcmp(argv[0], "")) {
    /* do nothing */
  } else if (!strcmp(argv[0], "quit") ||
	     !strcmp(argv[0], "exit") ||
	     !strcmp(argv[0], "q")) {
    owl_command_quit();
  } else if (!strcmp(argv[0], "info")) {
    owl_command_info();
  } else if (!strcmp(argv[0], "help")) {
    owl_command_help(argc, argv);
  } else if (!strcmp(argv[0], "about")) {
    owl_command_about();
  } else if (!strcmp(argv[0], "version")) {
    owl_command_version();
  } else if (!strcmp(argv[0], "next")) {
    owl_command_next();
  } else if (!strcmp(argv[0], "prev")) {
    owl_command_prev();
  } else if (!strcmp(argv[0], "next-notdel")) {
    owl_command_next_notdeleted();
  } else if (!strcmp(argv[0], "prev-notdel")) {
    owl_command_prev_notdeleted();
  } else if (!strcmp(argv[0], "expunge")) {
    owl_command_expunge();
  } else if (!strcmp(argv[0], "delete") || !strcmp(argv[0], "del")) {
    owl_command_delete(argc, argv);
  } else if (!strcmp(argv[0], "last")) {
    owl_command_last();
  } else if (!strcmp(argv[0], "first")) {
    owl_command_first();
  } else if (!strcmp(argv[0], "resize")) {
    owl_command_resize();
  } else if (!strcmp(argv[0], "suspend")) {
    owl_command_suspend();
  } else if (!strcmp(argv[0], "echo")) {
    owl_command_echo(argc, argv);
  } else if (!strcmp(argv[0], "exec")) {
    owl_command_exec(argc, argv);
  } else if (!strcmp(argv[0], "pexec")) {
    owl_command_pexec(argc, argv);
  } else if (!strcmp(argv[0], "aexec")) {
    owl_command_aexec(argc, argv);
  } else if (!strcmp(argv[0], "perl")) {
    owl_command_perl(argc, argv, buff);
  } else if (!strcmp(argv[0], "pperl")) {
    owl_command_pperl(argc, argv, buff);
  } else if (!strcmp(argv[0], "aperl")) {
    owl_command_aperl(argc, argv, buff);
  } else if (!strcmp(argv[0], "unsuball")) {
    owl_command_unsuball();
  } else if (!strcmp(argv[0], "load-subs")) {
    owl_command_loadsubs(argc, argv);
  } else if (!strcmp(argv[0], "subscribe") || !strcmp(argv[0], "sub")) {
    owl_command_subscribe(argc, argv);
  } else if (!strcmp(argv[0], "unsubscribe") || !strcmp(argv[0], "unsub")) {
    owl_command_unsubscribe(argc, argv);
  } else if (!strcmp(argv[0], "getsubs")) {
    owl_command_getsubs();
  } else if (!strcmp(argv[0], "zlog")) {
    owl_command_zlog(argc, argv);
  } else if (!strcmp(argv[0], "debug")) {
    owl_command_debug(argc, argv);
  } else if (!strcmp(argv[0], "set")) {
    owl_command_set(argc, argv);
  } else if (!strcmp(argv[0], "print")) {
    owl_command_print(argc, argv);
  } else if (!strcmp(argv[0], "ktest")) {
    owl_command_ktest(argc, argv);
  } else if (!strcmp(argv[0], "filter")) {
    owl_command_filter(argc, argv);
  } else if (!strcmp(argv[0], "viewclass") || !strcmp(argv[0], "vc")) {
    owl_command_viewclass(argc, argv);
  } else if (!strcmp(argv[0], "viewuser") || !strcmp(argv[0], "vu")) {
    owl_command_viewuser(argc, argv);
  } else if (!strcmp(argv[0], "show")) {
    owl_command_show(argc, argv);
  } else if (!strcmp(argv[0], "beep")) {
    owl_command_beep();
  } else if (!strcmp(argv[0], "zlocate")) {
    owl_command_zlocate(argc, argv);
  } else if (!strcmp(argv[0], "status")) {
    owl_command_status();
  } else if (!strcmp(argv[0], "view")) {
    owl_command_view(argc, argv);
  } else if (!strcmp(argv[0], "zwrite")) {
    if (argc < 2) {
      owl_function_makemsg("Not enough arguments to the zwrite command.");
    } else {
      owl_command_zwrite_setup(tmpbuff);
      owl_global_set_buffercommand(&g, tmpbuff);
    }
  } else if (!strcmp(argv[0], "reply")) {
    owl_command_reply();
  } else if (!strcmp(argv[0], "zaway")) {
    owl_command_zaway(argc, argv);
  } else {
    char tmpbuff[1024];
    sprintf(tmpbuff, "Unknown command '%s'.", buff);
    owl_function_makemsg(tmpbuff);
  }
  owl_parsefree(argv, argc);
  free(tmpbuff);
  sepbar(NULL);
}


void owl_command_info() {
  owl_function_info();
}

void owl_command_help(int argc, char **argv) {
  if (argc==1) {
    owl_help();
    return;
  }

  if (!strcmp(argv[1], "zlog")) {
    owl_help_zlog();
  } else if (!strcmp(argv[1], "quit") || !strcmp(argv[1], "exit")) {
    owl_help_quit();
  } else if (!strcmp(argv[1], "zwrite")) {
    owl_help_zwrite();
  } else if (!strcmp(argv[1], "reply")) {
    owl_help_reply();
  } else if (!strcmp(argv[1], "set")) {
    owl_help_set();
  } else if (!strcmp(argv[1], "print")) {
    owl_help_print();
  } else if (!strcmp(argv[1], "version")) {
    owl_help_version();
  } else if (!strcmp(argv[1], "subscribe") || !strcmp(argv[1], "sub")) {
    owl_help_subscribe();
  } else if (!strcmp(argv[1], "unsubscribe") || !strcmp(argv[1], "unsub")) {
    owl_help_unsubscribe();
  } else if (!strcmp(argv[1], "unsuball")) {
    owl_help_unsuball();
  } else if (!strcmp(argv[1], "getsubs")) {
    owl_help_getsubs();
  } else if (!strcmp(argv[1], "zlocate")) {
    owl_help_zlocate();
  } else if (!strcmp(argv[1], "info")) {
    owl_help_info();
  } else if (!strcmp(argv[1], "help")) {
    owl_help_help();
  } else if (!strcmp(argv[1], "next")) {
    owl_help_next();
  } else if (!strcmp(argv[1], "prev")) {
    owl_help_prev();
  } else if (!strcmp(argv[1], "next-notdel")) {
    owl_help_next_notdel();
  } else if (!strcmp(argv[1], "prev-notdel")) {
    owl_help_prev_notdel();
  } else if (!strcmp(argv[1], "expunge")) {
    owl_help_expunge();
  } else if (!strcmp(argv[1], "first")) {
    owl_help_first();
  } else if (!strcmp(argv[1], "last")) {
    owl_help_last();
  } else if (!strcmp(argv[1], "resize")) {
    owl_help_resize();
  } else if (!strcmp(argv[1], "suspend")) {
    owl_help_suspend();
  } else if (!strcmp(argv[1], "exec")) {
    owl_help_exec();
  } else if (!strcmp(argv[1], "aexec")) {
    owl_help_aexec();
  } else if (!strcmp(argv[1], "pexec")) {
    owl_help_pexec();
  } else if (!strcmp(argv[1], "perl")) {
    owl_help_perl();
  } else if (!strcmp(argv[1], "aperl")) {
    owl_help_aperl();
  } else if (!strcmp(argv[1], "pperl")) {
    owl_help_pperl();
  } else if (!strcmp(argv[1], "zaway")) {
    owl_help_zaway();
  } else if (!strcmp(argv[1], "load-subs")) {
    owl_help_load_subs();
  } else if (!strcmp(argv[1], "status")) {
    owl_help_status();
  } else if (!strcmp(argv[1], "about")) {
    owl_help_about();
  } else if (!strcmp(argv[1], "filter")) {
    owl_help_filter();
  } else if (!strcmp(argv[1], "view")) {
    owl_help_view();
  } else if (!strcmp(argv[1], "viewclass")) {
    owl_help_viewclass();
  } else if (!strcmp(argv[1], "viewuser")) {
    owl_help_viewuser();
  } else if (!strcmp(argv[1], "show")) {
    owl_help_show();
  } else if (!strcmp(argv[1], "delete")) {
    owl_help_delete();
  } else if (!strcmp(argv[1], "beep")) {
    owl_help_beep();
  } else {
    char buff[LINE];
    sprintf(buff, "Uknown help topic '%s'", argv[1]);
    owl_function_makemsg(buff);
  }
}

void owl_command_about() {
  owl_function_about();
}

void owl_command_version() {
  char buff[1024];

  sprintf(buff, "Owl version %s", OWL_VERSION_STRING);
  owl_function_makemsg(buff);
}

void owl_command_next() {
  owl_function_nextmsg();
}

void owl_command_prev() {
  owl_function_prevmsg();
}

void owl_command_next_notdeleted() {
  owl_function_nextmsg_notdeleted();
}

void owl_command_prev_notdeleted() {
  owl_function_prevmsg_notdeleted();
}

void owl_command_delete_cur() {
  owl_function_deletecur();
}

void owl_command_undelete_curmsg() {
  owl_function_undeletecur();
}

void owl_command_expunge() {
  owl_function_expunge();
}

void owl_command_first() {
  owl_function_firstmsg();
}

void owl_command_last() {
  owl_function_lastmsg();
}

void owl_command_resize() {
  owl_function_resize();
}

void owl_command_shift_right() {
  owl_function_shift_right();
}

void owl_command_shift_left() {
  owl_function_shift_left();
}

void owl_command_unsuball() {
  owl_function_unsuball();
}

void owl_command_loadsubs(int argc, char **argv) {
  if (argc == 2) {
    owl_function_loadsubs(argv[1]);
  } else if (argc == 1) {
    owl_function_loadsubs(NULL);
  } else {
    owl_function_makemsg("Wrong number of arguments for load-subs.");
    return;
  }
}

void owl_command_zwrite_setup(char *line) {
  owl_editwin *e;
  char buff[1024];
  owl_zwrite z;
  int ret;

  /* check the arguments */
  ret=owl_zwrite_create_from_line(&z, line);
  if (ret) {
    owl_function_makemsg("Error in zwrite arugments");
    owl_zwrite_free(&z);
    return;
  }

  /* send a ping if necessary */
  if (owl_global_is_txping(&g)) {
    owl_zwrite_send_ping(&z);
  }
  owl_zwrite_free(&z);

  /* create and setup the editwin */
  e=owl_global_get_typwin(&g);
  owl_editwin_new_style(e, OWL_EDITWIN_STYLE_MULTILINE);

  if (!owl_global_is_lockout_ctrld(&g)) {
    owl_function_makemsg("Type your zephyr below.  End with ^D or a dot on a line by itself.  ^C will quit.");
  } else {
    owl_function_makemsg("Type your zephyr below.  End with a dot on a line by itself.  ^C will quit.");
  }

  owl_editwin_clear(e);
  owl_editwin_set_dotsend(e);
  strcpy(buff, "----> ");
  strcat(buff, line);
  strcat(buff, "\n");
  owl_editwin_set_locktext(e, buff);

  /* make it active */
  owl_global_set_typwin_active(&g);
}

void owl_command_zwrite(char *line) {
  char *tmpbuff, buff[1024];
  owl_zwrite z;
  int i, j;

  /* create the zwrite and send the message */
  owl_zwrite_create_from_line(&z, line);
  owl_zwrite_send_message(&z, owl_editwin_get_text(owl_global_get_typwin(&g)));
  owl_function_makemsg("Waiting for ack...");

  /* display the message as an admin message in the receive window */
  if (owl_global_is_displayoutgoing(&g) && owl_zwrite_is_personal(&z)) {
    tmpbuff=owl_malloc(strlen(owl_editwin_get_text(owl_global_get_typwin(&g)))+1024);
    owl_zwrite_get_recipstr(&z, buff);
    sprintf(tmpbuff, "Message sent to %s", buff);
    owl_function_adminmsg_outgoing(tmpbuff, owl_editwin_get_text(owl_global_get_typwin(&g)), line);
    owl_free(tmpbuff);
  }

  /* log it if we have logging turned on */
  if (owl_global_is_logging(&g) && owl_zwrite_is_personal(&z)) {
    j=owl_zwrite_get_numrecips(&z);
    for (i=0; i<j; i++) {
      owl_log_outgoing(owl_zwrite_get_recip_n(&z, i),
		       owl_editwin_get_text(owl_global_get_typwin(&g)));
    }
  }

  /* free the zwrite */
  owl_zwrite_free(&z);
}


void owl_command_suspend() {
  owl_function_suspend();
}

void owl_command_zaway(int argc, char **argv) {
  char buff[1024]; /* ick */
  int i;
  
  if ((argc==1) ||
      ((argc==2) && !strcmp(argv[1], "on"))) {
    owl_global_set_zaway_msg(&g, owl_global_get_zaway_msg_default(&g));
    owl_function_zaway_on();
    return;
  }

  if (argc==2 && !strcmp(argv[1], "off")) {
    owl_function_zaway_off();
    return;
  }

  strcpy(buff, "");
  for (i=1; i<argc; i++) {
    strcat(buff, argv[i]);
    if (i!=argc-1) {
      strcat(buff, " ");
    }
  }
  owl_global_set_zaway_msg(&g, buff);
  owl_function_zaway_on();
}


void owl_command_set(int argc, char **argv) {
  char *var, *val;
  int  silent=0;

  if (argc == 1) {
    owl_function_printallvars();
    return;
  } else if (argc == 4 && !strcmp("-q",argv[1])) {
    silent = 1;
    var=argv[2];
    val=argv[3];
  } else if (argc == 3) {
    var=argv[1];
    val=argv[2];
  } else {
    owl_function_makemsg("Wrong number of arguments for set command");
    return;
  }

  owl_variable_set_fromstring(owl_global_get_vardict(&g), var, val, !silent);
}

void owl_command_print(int argc, char **argv) {
  char *var;
  char valbuff[1024];

  if (argc==1) {
    owl_function_printallvars();
    return;
  } else if (argc!=2) {
    owl_function_makemsg("Wrong number of arguments for print command");
    return;
  }

  var=argv[1];
    
  if (0 == owl_variable_get_tostring(owl_global_get_vardict(&g), 
				     var, valbuff, 1024)) {
    owl_function_makemsg("%s = '%s'", var, valbuff);
  } else {
    owl_function_makemsg("Unknown variable '%s'.", var);
  }
}


void owl_command_exec(int argc, char **argv) {
  owl_function_exec(argc, argv);
}

void owl_command_pexec(int argc, char **argv) {
  owl_function_exec2(argc, argv, 1);
}

void owl_command_aexec(int argc, char **argv) {
  owl_function_exec2(argc, argv, 2);
}

void owl_command_perl(int argc, char **argv, char *buff) {
  owl_function_perl(argc, argv, buff, 0);
}

void owl_command_pperl(int argc, char **argv, char *buff) {
  owl_function_perl(argc, argv, buff, 1);
}

void owl_command_aperl(int argc, char **argv, char *buff) {
  owl_function_perl(argc, argv, buff, 2);
}

void owl_command_quit() {
  owl_function_quit();
}

void owl_command_debug(int argc, char **argv) {
  if (argc<2) {
    owl_function_makemsg("Need at least one argument to debug command");
    return;
  }

  if (!owl_global_is_debug_fast(&g)) {
    owl_function_makemsg("Debugging is not turned on");
    return;
  }

  owl_function_debugmsg(argv[1]);
}

void owl_command_ktest(int argc, char **argv) {
  owl_process_command("pexec znl -e -t");
}

void owl_command_zlog(int argc, char **argv) {
  if (argc != 2) {
    owl_function_makemsg("Wrong number of arguments for zlog command");
    return;
  }

  if (!strcmp(argv[1], "in")) {
    owl_function_zlog_in();
  } else if (!strcmp(argv[1], "out")) {
    owl_function_zlog_out();
  } else {
    owl_function_makemsg("Invalid subcommand for zlog");
  }
}


void owl_command_zlog_out() {
  owl_function_zlog_out();
}


void owl_command_subscribe(int argc, char **argv) {
  char *recip="";

  if (argc<3) {
    owl_function_makemsg("Not enough arguments to the subscribe command");
    return;
  } else if (argc>4) {
    owl_function_makemsg("Too many arguments to the subscribe command");
    return;
  }

  if (argc==3) {
    recip="";
  } else if (argc==4) {
    recip=argv[3];
  }

  owl_function_subscribe(argv[1], argv[2], recip);
}


void owl_command_unsubscribe(int argc, char **argv) {
  char *recip="";

  if (argc<3) {
    owl_function_makemsg("Not enough arguments to the unsubscribe command");
    return;
  } else if (argc>4) {
    owl_function_makemsg("Too many arguments to the unsubscribe command");
    return;
  }

  if (argc==3) {
    recip="";
  } else if (argc==4) {
    recip=argv[3];
  }

  owl_function_unsubscribe(argv[1], argv[2], recip);
}


void owl_command_echo(int argc, char **argv) {
  int i, size;
  char *buff;

  size=0;
  for (i=1; i<argc; i++) {
    size+=strlen(argv[i])+1;
  }
  buff=owl_malloc(size+20);
  strcpy(buff, "");
  for (i=1; i<argc; i++) {
    sprintf(buff, "%s%s ", buff, argv[i]);
  }
  buff[strlen(buff)-1]='\0';
  strcat(buff, "\n");
  owl_function_popless_text(buff);
  free(buff);
}


void owl_command_getsubs() {
  owl_function_getsubs();
}

void owl_command_status() {
  owl_function_status();
}

void owl_command_reply() {
  owl_function_reply(0, 1);
}

void owl_command_replytosender() {
  owl_function_reply(1, 1);
}

void owl_command_editreply() {
  owl_function_reply(0, 0);
}

void owl_command_editreplytosender() {
  owl_function_reply(1, 1);
}

void owl_command_filter(int argc, char **argv) {
  owl_function_create_filter(argc, argv);
}

void owl_command_zlocate(int argc, char **argv) {
  if (argc != 2) {
    owl_function_makemsg("Wrong number of arguments for zlocate");
    return;
  }
  owl_function_zlocate(argv[1], 1);
}

void owl_command_view(int argc, char **argv) {
  if (argc<2) {
    owl_function_makemsg("Wrong number of arguments to view command");
    return;
  }

  /* is it a dynamic filter? */
  if (!strcmp(argv[1], "-d")) {
    char **myargv;
    int i;

    myargv=owl_malloc((argc*sizeof(char *))+50);
    myargv[0]="";
    myargv[1]="owl-dynamic";
    for (i=2; i<argc; i++) {
      myargv[i]=argv[i];
    }
    owl_function_create_filter(argc, myargv);
    owl_function_change_view("owl-dynamic");
    owl_free(myargv);
    return;
  }

  /* otherwise it's a normal view command */
  if (argc>2) {
    owl_function_makemsg("Wrong number of arguments to view command");
    return;
  }
  owl_function_change_view(argv[1]);
}


void owl_command_show(int argc, char **argv) {
  if (argc<2) {
    owl_function_makemsg("Wrong number of arguments to the show command");
    return;
  }

  if (!strcmp(argv[1], "filter") || !strcmp(argv[1], "filters")) {
    if (argc==2) {
      owl_function_show_filters();
    } else {
      owl_function_show_filter(argv[2]);
    }
  } else {
    owl_function_makemsg("Unknown subcommand for 'show' command");
    return;
  }
}

void owl_command_viewclass(int argc, char **argv) {
  if (argc!=2) {
    owl_function_makemsg("Wrong number of arguments to viewclass command");
    return;
  }
  owl_function_fastclassfilt(argv[1]);
}

void owl_command_viewuser(int argc, char **argv) {
  if (argc!=2) {
    owl_function_makemsg("Wrong number of arguments to viewuser command");
    return;
  }
  owl_function_fastuserfilt(argv[1]);
}


void owl_command_delete(int argc, char **argv) {
  if (argc==1) {
    owl_function_deletecur();
    return;
  }

  if (argc==2 && !strcmp(argv[1], "view")) {
    owl_function_delete_curview_msgs();
    return;
  }

  if (argc==3 && !strcmp(argv[1], "-id")) {
    owl_function_delete_by_id(atoi(argv[2]));
    return;
  }

  owl_function_makemsg("Unknown arguments to delete command");
}

void owl_command_beep() {
  owl_function_beep();
}
