#include "owl.h"
#include <string.h>

#define HELPBUFLEN 10000

void owl_help() {
  char buff[HELPBUFLEN], *pos, *varname;
  owl_list varnames;
  int i, numvarnames, rem;
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "  Keys:\n");
  strcat(buff, "    n             Move to next non-deleted message\n");
  strcat(buff, "    p             Move to previous non-deleted message\n");
  strcat(buff, "    C-n , down    Move to next message\n");
  strcat(buff, "    C-p , up      Move to previous message\n");
  strcat(buff, "    < , >         Move to first, last message\n");
  strcat(buff, "    right , left  Scroll screen left or right\n");
  strcat(buff, "    C-v           Page down\n");
  strcat(buff, "    M-v           Page up\n");
  strcat(buff, "    i             Print more information about a message\n");
  strcat(buff, "    P             Move to the next personal message\n");
  strcat(buff, "    M-P           Move to the preivous personal message\n");
  strcat(buff, "\n");
  strcat(buff, "    d             Mark message for deletion\n");
  strcat(buff, "    u             Undelete a message marked for deletion\n");
  strcat(buff, "    x             Expunge deleted messages\n");
  strcat(buff, "    X             Expunge deleted messages and switch view\n");
  strcat(buff, "    T             Mark all 'trash' messages for deletion\n");
  strcat(buff, "\n");
  strcat(buff, "    z             Start a zwrite command\n");
  strcat(buff, "    r             Reply to the current message\n");
  strcat(buff, "    R             Reply to sender\n");
  strcat(buff, "    C-r           Reply but allow editing of reply line\n");
  strcat(buff, "\n");
  strcat(buff, "    M-n           View zephyrs to selected conversation\n");
  strcat(buff, "    v             Start a view command\n");
  strcat(buff, "\n");
  strcat(buff, "    A             Toggle zaway\n");
  strcat(buff, "    w             Open a URL in the message in netscape\n");
  strcat(buff, "    C-l           Refresh the screen\n");
  strcat(buff, "    C-z           Suspend\n");
  strcat(buff, "    h             Print this help message\n");
  strcat(buff, "    :             Enter one of the commands below\n");
  strcat(buff, "\n");
  strcat(buff, "  For help on a specific command use 'help <command>'\n\n");
  strcat(buff, "  Commands:\n");
  strcat(buff, "    quit, exit    Exit owl\n");
  strcat(buff, "    zwrite        Send a zephyr\n");
  strcat(buff, "    reply         Reply to the current zephyr\n");
  strcat(buff, "    set           Set a variable (see list below)\n");
  strcat(buff, "    print         Print a variable's value (variables listed below)\n");
  strcat(buff, "    zlog          Send a login or logout notification\n");
  strcat(buff, "    version       Print the version number of owl\n");
  strcat(buff, "    subscribe     Subscribe to a zephyr class or instance\n");
  strcat(buff, "    unsubscribe   Unsubscribe to a zephyr class or instance\n");
  strcat(buff, "    unsuball      Unsubscribe from all zephyr classes\n");
  strcat(buff, "    getsubs       Print a list of current subscriptions\n");
  strcat(buff, "    zlocate       Locate a user\n");
  strcat(buff, "    info          Print detailed information about the current message\n");
  strcat(buff, "    filter        Create a message filter\n");
  strcat(buff, "    view          View messages matching a filter\n");
  strcat(buff, "    viewuser      View messages to or from a particular user\n");
  strcat(buff, "    viewclass     View messages to a particular class\n");
  strcat(buff, "    show          Show information about owl (see detailed help)\n");
  strcat(buff, "    help          Print the help screen\n");
  strcat(buff, "    next          Move to the next message\n");
  strcat(buff, "    prev          Move to the previous message\n");
  strcat(buff, "    next-notdel   Move to the next non-deleted message\n");
  strcat(buff, "    prev-notdel   Move to the previous non-deleted message\n");
  strcat(buff, "    expunge       Expunge messages marked for deletion\n");
  strcat(buff, "    first         Move to the first message\n");
  strcat(buff, "    last          Move to the last message\n");
  strcat(buff, "    resize        Resize owl to the size of the terminal\n");
  strcat(buff, "    suspend       Suspend owl\n");
  strcat(buff, "    exec          Run a shell command\n");
  strcat(buff, "    aexec         Run a shell command and output to an admin message\n");
  strcat(buff, "    pexec         Run a shell command and output to a popup\n");
  strcat(buff, "    perl          Evaluate a perl expression\n");
  strcat(buff, "    aperl         Eval a perl expression and output to an admin message\n");
  strcat(buff, "    pperl         Eval a perl expression and output to a popup\n");
  strcat(buff, "    zaway         Turn zaway on or off, or set the message\n");
  strcat(buff, "    load-subs     Load zephyr subscriptions from a file\n");
  strcat(buff, "    about         Print information about owl\n");
  strcat(buff, "    status        Print status information about the running owl\n");
  strcat(buff, "\n");
  
  /* help for variables */
  owl_variable_dict_get_names(owl_global_get_vardict(&g), &varnames);
  pos = buff+strlen(buff);
  rem = (buff+HELPBUFLEN)-pos-1;
  pos += owl_variable_get_helpheader(pos, rem);
  numvarnames = owl_list_get_size(&varnames);
  for (i=0; i<numvarnames; i++) {
    varname = owl_list_get_element(&varnames, i);
    if (varname && varname[0]!='_') {
      rem = (buff+HELPBUFLEN)-pos-1;
      pos += owl_variable_get_help(owl_global_get_vardict(&g), 
				   varname, pos, rem);
    }
  }
  owl_variable_dict_namelist_free(&varnames);

  strcat(buff, "\n");

  owl_function_popless_text(buff);
}

void owl_help_zlog() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    zlog - send a login or logout notification\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    zlog in\n");
  strcat(buff, "    zlog out\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    zlog in will send a login notification, zlog out will send a\n");
  strcat(buff, "    logout notification.  By default a login notification is sent\n");
  strcat(buff, "    when owl is started and a logout notification is sent when owl\n");
  strcat(buff, "    is exited.  This behavior can be changed with the 'startuplogin'\n");
  strcat(buff, "    and 'shudownlogout' variables.\n");
  owl_function_popless_text(buff);
}

void owl_help_quit() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    quit / exit - exit owl\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    quit\n");
  strcat(buff, "    exit\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Exit owl and run any shutdown activities.\n");
  owl_function_popless_text(buff);
}

void owl_help_zwrite() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    zwrite - send a zephyr\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    zwrite [-n] [-C] [-c class] [-i instance] [-r realm] [-O opcde] [<user> ...] \n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Zwrite send a zephyr to the one or more users specified.\n\n");
  strcat(buff, "    The following options are available:\n\n");
  strcat(buff, "    -n    Do not send a ping message.\n\n");
  strcat(buff, "    -C    If the message is sent to more than one user include a\n");
  strcat(buff, "          \"cc:\" line in the text\n\n");
  strcat(buff, "    -c class\n");
  strcat(buff, "          Send to the specified zephyr class\n\n");
  strcat(buff, "    -i instance\n");
  strcat(buff, "          Send to the specified zephyr instance\n\n");
  strcat(buff, "    -r realm\n");
  strcat(buff, "          Send to a foreign realm\n");
  strcat(buff, "    -O opcode\n");
  strcat(buff, "          Send to the specified opcode\n");
  owl_function_popless_text(buff);
}

void owl_help_reply() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    reply - reply to the current message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    reply\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    If the current message is a personal message reply to the sender.\n");
  strcat(buff, "    If is a non-personal message reply publicly to the same\n");
  strcat(buff, "    class/instance.\n");
  owl_function_popless_text(buff);
}

void owl_help_set() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    set - set a variable value\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    set [-q] <variable> <value>\n");
  strcat(buff, "    set\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Set the named variable to the specified value.  If no arguments\n");
  strcat(buff, "    are used print the value of all variables.\n");
  strcat(buff, "    If -q is specified, is silent and doesn't print a message.\n");
  owl_function_popless_text(buff);
}

void owl_help_print() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    print - print a variable value\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    print <variable>\n");
  strcat(buff, "    print\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Print the value of the named variable.  If no arugments\n");
  strcat(buff, "    are used print the value of all variables.\n");
  owl_function_popless_text(buff);
}

void owl_help_version() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    version - print the version of the running owl\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    version\n\n");
  owl_function_popless_text(buff);
}

void owl_help_subscribe() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    subscribe / sub - subscribe to a zephyr class, instance, recipient\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    subscribe <class> <instance> [recipient]\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Subscribe the specified class and instance.  If the recipient is\n");
  strcat(buff, "    not listed on the command line it defaults to * (the wildcard\n");
  strcat(buff, "    recipient).\n");
  owl_function_popless_text(buff);
}

void owl_help_unsubscribe() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    unsubscribe / unsub - unsubscribe from a zephyr class, instance, recipient\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    unsubscribe <class> <instance> [recipient]\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Unsubscribe from the specified class and instance.  If the recipient\n");
  strcat(buff, "    is not listed on the command line it defaults to * (the wildcard\n");
  strcat(buff, "    recipient).\n");
  owl_function_popless_text(buff);
}

void owl_help_unsuball() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    unsuball - unsubscribe from all zephyrs\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    unsuball\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Unsubscribe from all zephyrs\n");
  owl_function_popless_text(buff);
}

void owl_help_getsubs() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    getsubs - print all current subscriptions\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    getsubs\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    getsubs retrieves the current subscriptions from the server\n");
  strcat(buff, "    and displays them.\n");
  owl_function_popless_text(buff);
}

void owl_help_info() {
  char buff[5000];
    
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    info - display detailed information about the current message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    info\n\n");
  owl_function_popless_text(buff);
}

void owl_help_help() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    help - display help on using owl\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    help [command]\n\n");
  owl_function_popless_text(buff);
}

void owl_help_next() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    next - move the pointer to the next message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    next\n\n");
  owl_function_popless_text(buff);
}

void owl_help_prev() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    next - move the pointer to the previous message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    prev\n\n");
  owl_function_popless_text(buff);
}

void owl_help_next_notdel() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    next-notdel - move the pointer to the next non-deleted message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    next-notdel\n\n");
  owl_function_popless_text(buff);
}

void owl_help_prev_notdel() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    prev-notdel - move the pointer to the previous non-deleted message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    prev-notdel\n\n");
  owl_function_popless_text(buff);
}

void owl_help_expunge() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    expunge - remove all messages marked for deletion\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    expunge\n\n");
  owl_function_popless_text(buff);
}

void owl_help_first() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    first - move the pointer to the first message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    first\n\n");
  owl_function_popless_text(buff);
}

void owl_help_last() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    first - move the pointer to the last message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    last\n\n");
  owl_function_popless_text(buff);
}

void owl_help_resize() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    resize - resize the window to the current screen size\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    resize\n\n");
  owl_function_popless_text(buff);
}

void owl_help_suspend() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    suspend - suspend owl\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    suspend\n\n");
  owl_function_popless_text(buff);
}

void owl_help_exec() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    exec - run a command from the shell\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    exec [args .. ]\n\n");
  owl_function_popless_text(buff);
}

void owl_help_aexec() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    aexec - run a command from the shell and display in an admin message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    aexec [args .. ]\n\n");
  owl_function_popless_text(buff);
}

void owl_help_pexec() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    pexec - run a command from the shell and display in a popup window\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    pexec [args .. ]\n\n");
  owl_function_popless_text(buff);
}

void owl_help_perl() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    perl - run a perl expression\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    perl [args .. ]\n\n");
  owl_function_popless_text(buff);
}

void owl_help_aperl() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    aperl - run a perl expression and display in an admin message\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    aperl [args .. ]\n\n");
  owl_function_popless_text(buff);
}

void owl_help_pperl() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    pperl - run a perl expression and display in a popup window\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    pperl [args .. ]\n\n");
  owl_function_popless_text(buff);
}

void owl_help_zaway() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    zaway - running a command from the shell\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    zaway [ on | off ]\n");
  strcat(buff, "    zaway <message>\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Turn on or off the default zaway message.  If a message is\n");
  strcat(buff, "    specified turn on zaway with that message\n");
  owl_function_popless_text(buff);
}

void owl_help_load_subs() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    load-subs - load subscriptions from a file\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    load-subs <file>\n");
  owl_function_popless_text(buff);
}


void owl_help_about() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    about - print information about owl\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    about\n");
  owl_function_popless_text(buff);
}

void owl_help_status() {
  char buff[5000];
  
  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    status - print status information about the running owl\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    status\n");
  owl_function_popless_text(buff);
}

void owl_help_zlocate() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    zlocate - locate a user\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    zlocate <user>\n");
  owl_function_popless_text(buff);
}


void owl_help_filter() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    filter - create a message filter\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    filter <name> [ <expression> ... ]\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    The filter command creates a filter with the specified name,\n");
  strcat(buff, "    or if one already exists it is replaced.  Example filter\n");
  strcat(buff, "    syntax would be:\n\n");
  strcat(buff, "        filter myfilter ( class ^foobar$ ) or ( class ^quux$ and instance ^bar$ )\n\n");
  strcat(buff, "    Valid matching fields are class, instance, recipient, sender, opcode\n");
  strcat(buff, "    and realm.  Valid operations are 'and', 'or' and 'not'.  Spaces must be\n");
  strcat(buff, "    present before and after parenthesis.\n\n");
  strcat(buff, "SEE ALSO\n");
  strcat(buff, "    view viewclass viewuser\n");
  owl_function_popless_text(buff);
}

void owl_help_view() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    view - view messages matching a filter\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    view <filter>\n");
  strcat(buff, "    view -d <expression>\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    In the first usage, The view command sets the current view to\n");
  strcat(buff, "    the specified filter.   This causes only messages matching that\n");
  strcat(buff, "    filter to be displayed.\n");
  strcat(buff, "\n");
  strcat(buff, "    In the second usage a filter expression and be specified directly\n");
  strcat(buff, "    after -d.  Owl will build an internal filter based on this\n");
  strcat(buff, "    filter and change the current view to use it.\n\n");
  strcat(buff, "SEE ALSO\n");
  strcat(buff, "    filter viewclass viewuser\n");
  owl_function_popless_text(buff);
}

void owl_help_viewclass() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    viewclass - view messages matching a particular class\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    viewclass <class>\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    The viewclass command will automatically create a filter matching\n");
  strcat(buff, "    the specified class and switch the current view to it.\n\n");
  strcat(buff, "SEE ALSO\n");
  strcat(buff, "    filter view viewuser\n");
  owl_function_popless_text(buff);
}

void owl_help_viewuser() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    viewuser - view messages matching a particular user\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    user <user>\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    The viewuser command will automatically create a filter matching\n");
  strcat(buff, "    the specified user and switch the current view to it.\n\n");
  strcat(buff, "SEE ALSO\n");
  strcat(buff, "    filter view viewclass\n");
  owl_function_popless_text(buff);
}

void owl_help_show() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    show - show information\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    show filters\n");
  strcat(buff, "    show filter <filter>\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Show filters will list the names of all filters.\n");
  strcat(buff, "    Show fitler <filter> will show the definition of a particular\n");
  strcat(buff, "    filter.\n\n");
  strcat(buff, "SEE ALSO\n");
  strcat(buff, "    filter view\n");
  owl_function_popless_text(buff);
}

void owl_help_delete() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    delete - mark a message for deletion\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    delete [ -id msgid ]\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    If no message id is specified the current message is marked for\n");
  strcat(buff, "    deletion.  Otherwise the message with the given message id is marked\n");
  strcat(buff, "    for deltion.\n\n");
  owl_function_popless_text(buff);
}

void owl_help_beep() {
  char buff[5000];

  strcpy(buff, "OWL HELP\n\n");
  strcat(buff, "NAME\n");
  strcat(buff, "    beep - ring the terminal bell\n\n");
  strcat(buff, "SYNOPSIS\n");
  strcat(buff, "    beep\n\n");
  strcat(buff, "DESCRIPTION\n");
  strcat(buff, "    Beep will ring the terminal bell.  If the variable 'bell' has been\n");
  strcat(buff, "    set to 'off' this command does nothing.\n");
  owl_function_popless_text(buff);
}
