#include "owl.h"

void owl_process_key(int j) {
  WINDOW *typwin;
  owl_editwin *tw;
  owl_history *hist;
  int ret;
  
  typwin=owl_global_get_curs_typwin(&g);
  tw=owl_global_get_typwin(&g);
  hist=owl_global_get_history(&g);
  
  if (j==ERR) return;

  /* first, keys that are not context sensitive */
  if (j==CTRL('z')) {
    /* suspend */
    owl_command_suspend(&g);
    return;
  }

  
  /* add keys here for owl_function_typwin_grow() and
     owl_function_typwin_shrink() at some point */

  /* if the typwin is not active, use the main keybindings */
  if (!owl_global_is_typwin_active(&g)) {
    owl_function_makemsg("");
    if (j==' ') {
      owl_function_page_curmsg(10);
    } else if (j==CTRL('h') || j==127 || j==KEY_BACKSPACE || j==KEY_DC) {
      owl_function_page_curmsg(-1);
    } else if (j=='b') {
      owl_function_page_curmsg(-10);
    } else if (j=='\n' || j=='\r') {
      owl_function_page_curmsg(1);
    } else if (j=='A') {
      if (!owl_global_is_zaway(&g)) {
	owl_global_set_zaway_msg(&g, owl_global_get_zaway_msg_default(&g));
	owl_function_zaway_on();
      } else {
	owl_function_zaway_off();
      }
    } else if (j=='d') {
      owl_command_delete_cur();
    } else if (j==META('D')) {
      owl_function_delete_curview_msgs();
    } else if (j=='u') {
      owl_command_undelete_curmsg();
    } else if (j=='x') {
      owl_command_expunge();
    } else if (j=='X') {
      owl_command_expunge();
      owl_function_change_view(owl_global_get_view_home(&g));
    } else if (j=='i') {
      owl_command_info();
    } else if (j=='h') {
      owl_help();
    } else if (j=='n') {
      owl_command_next_notdeleted();
    } else if (j=='p') {
      owl_command_prev_notdeleted();
    } else if (j==KEY_DOWN || j==CTRL('n')) {
      owl_command_next();
    } else if (j==KEY_UP || j==CTRL('p')) {
      owl_command_prev();
    } else if (j==KEY_RIGHT) {
      owl_command_shift_right();
    } else if (j==KEY_LEFT) {
      owl_command_shift_left();
    } else if (j=='<' || j==META('<')) {
      owl_global_set_rightshift(&g, 0);
      owl_command_first();
    } else if (j=='>' || j==META('>')) {
      owl_command_last();
    } else if (j==CTRL('v') || j==KEY_NPAGE) {
      owl_function_mainwin_pagedown();
    } else if (j==META('v') || j==KEY_PPAGE) {
      owl_function_mainwin_pageup();
    } else if (j=='M') {
      owl_function_curmsg_to_popwin();
    } else if (j=='T') {
      owl_function_delete_automsgs();
    } else if (j=='P') {
      owl_function_next_personal();
    } else if (j==META('P')) {
      owl_function_prev_personal();
    } else if (j=='w') {
      owl_function_openurl();
    } else if (j=='z') {
      owl_function_start_command("zwrite ");
      return;
    } else if (j=='v') {
      owl_function_start_command("view ");
      return;
    } else if (j=='r') {
      owl_command_reply();
    } else if (j==META('n')) {
      owl_function_smartnarrow();
    } else if (j=='R') {
      owl_command_replytosender();
    } else if (j==CTRL('r')) {
      owl_command_editreply();
    } else if (j==CTRL('R')) {
      owl_command_editreplytosender();
    } else if (j==':' || j==META('x')) {
      owl_function_start_command("");
      return;
    } else if (j==CTRL('l')) {
      owl_function_full_redisplay();
      owl_global_set_needrefresh(&g);
    } else if (j==CTRL('c')) {
      return;
    } else if (j==CTRL('g')) {
      return;
    } else if (j==410) {
      /* we get this on a resize */
      return;
    } else {
      char buff[LINE];
      if (j<META('\0')) {
	sprintf(buff, "'%c' is not a valid key in this context.", j);
      } else {
	sprintf(buff, "'M-%c' is not a valid key in this context.", j&0177);
      }
      owl_function_makemsg(buff);
      return;
    }

    sepbar(NULL);
    return;
  }

  /* if we're in ONELINE mode the arrow keys do history */
  if (owl_editwin_get_style(tw)==OWL_EDITWIN_STYLE_ONELINE) {
    if (j==KEY_UP || j==CTRL('p')) {
      char *ptr;
      if (!owl_history_is_touched(hist)) {
	owl_history_store(hist, owl_editwin_get_text(tw));
	owl_history_set_partial(hist);
      }
      ptr=owl_history_get_prev(hist);
      if (ptr) {
	owl_editwin_clear(tw);
	owl_editwin_insert_string(tw, ptr);
	owl_editwin_redisplay(tw, 0);
	owl_global_set_needrefresh(&g);
      } else {
	owl_function_beep();
      }
      return;
    } else if (j==KEY_DOWN || j==CTRL('n')) {
      char *ptr;
      ptr=owl_history_get_next(hist);
      if (ptr) {
	owl_editwin_clear(tw);
	owl_editwin_insert_string(tw, ptr);
	owl_editwin_redisplay(tw, 0);
	owl_global_set_needrefresh(&g);
      } else {
	owl_function_beep();
      }
      return;
    }
  }


  /* otherwise keys go to the typwin */
  ret=owl_editwin_process_char(tw, j);
  owl_global_set_needrefresh(&g);
  
  /* C-c will cancel */
  if (j==CTRL('c') || j==CTRL('g')) {
    owl_function_makemsg("Command cancelled.");
    owl_editwin_fullclear(tw);
    owl_global_set_needrefresh(&g);
    wnoutrefresh(typwin);
    owl_global_set_typwin_inactive(&g);
    owl_editwin_new_style(tw, OWL_EDITWIN_STYLE_ONELINE);
    return;
  }
  
  /* C-d will do whatever command if in MULTILINE mode */
  if (owl_editwin_get_style(tw)==OWL_EDITWIN_STYLE_MULTILINE) {
    if (ret==1 ||
	(!owl_global_is_lockout_ctrld(&g) && j==CTRL('d'))) {
      owl_function_run_buffercommand();
      owl_editwin_new_style(tw, OWL_EDITWIN_STYLE_ONELINE);
      owl_editwin_fullclear(tw);
      owl_global_set_typwin_inactive(&g);
      owl_global_set_needrefresh(&g);
      wnoutrefresh(typwin);
      return;
    }
  }
  
  /* if we're in ONELINE mode and they hit enter, process the line */
  if ((owl_editwin_get_style(tw)==OWL_EDITWIN_STYLE_ONELINE) &&
      (j=='\n' || j=='\r')) {
    
    owl_global_set_typwin_inactive(&g);
    owl_history_store(hist, owl_editwin_get_text(tw));
    owl_history_reset(hist);
    owl_process_command(owl_editwin_get_text(tw));
    
    /* if we're still in ONELINE mode we can clear the buffer */
    if (owl_editwin_get_style(tw)==OWL_EDITWIN_STYLE_ONELINE) {
      owl_editwin_fullclear(tw);
    }

    wnoutrefresh(typwin);
    owl_global_set_needrefresh(&g);
  }
}

