#ifndef INC_OWL_H
#define INC_OWL_H

#include <zephyr/zephyr.h>
#include <curses.h>
#include <sys/param.h>
#include <EXTERN.h>
#include <netdb.h>
#include <regex.h>
#include "config.h"

#define OWL_VERSION         1.1.1
#define OWL_VERSION_STRING "1.1.1"

#define OWL_DEBUG 0
#define OWL_DEBUG_FILE "/var/tmp/owldebug"

#define OWL_FMTEXT_ATTR_NONE      0
#define OWL_FMTEXT_ATTR_BOLD      1
#define OWL_FMTEXT_ATTR_REVERSE   2
#define OWL_FMTEXT_ATTR_UNDERLINE 4

#define OWL_EDITWIN_STYLE_MULTILINE 0
#define OWL_EDITWIN_STYLE_ONELINE   1

#define OWL_MESSAGE_TYPE_ADMIN  0
#define OWL_MESSAGE_TYPE_ZEPHYR 1

#define OWL_MESSAGE_ADMINTYPE_GENERIC  0
#define OWL_MESSAGE_ADMINTYPE_OUTGOING 1
#define OWL_MESSAGE_ADMINTYPE_NOTADMIN 2

#define OWL_DIRECTION_NONE      0
#define OWL_DIRECTION_DOWNWARDS 1
#define OWL_DIRECTION_UPWARDS   2

#define OWL_TAB               3  /* This *HAS* to be the size of TABSTR below */
#define OWL_TABSTR        "   "
#define OWL_MSGTAB            7
#define OWL_TYPWIN_SIZE       8
#define OWL_HISTORYSIZE       50

#define OWL_MODE_STARTUP      1
#define OWL_MODE_READCONFIG   2
#define OWL_MODE_INTERACTIVE  3

#define OWL_USERCLUE_NONE       0
#define OWL_USERCLUE_CLASSES    1
#define OWL_USERCLUE_FOOBAR     2
#define OWL_USERCLUE_BAZ        4

#define OWL_WEBBROWSER_NONE     0
#define OWL_WEBBROWSER_NETSCAPE 1
#define OWL_WEBBROWSER_GALEON   2

#define OWL_VARIABLE_OTHER      0
#define OWL_VARIABLE_INT        1
#define OWL_VARIABLE_BOOL       2
#define OWL_VARIABLE_STRING     3

#define OWL_FILTER_MAX_DEPTH    300

#define OWL_DEFAULT_ZAWAYMSG "I'm sorry, but I am currently away from the terminal and am\nnot able to receive your message.\n"

#define OWL_INCLUDE_REG_TESTS  1  /* whether to build in regression tests */

#ifndef CTRL
#define CTRL(key) ((key)&037)
#endif
#ifndef META
#define META(key) ((key)|0200)
#endif

#define LINE 2048

typedef struct _owl_variable {
  char *name;
  int   type;  /* OWL_VARIABLE_* */
  void *pval_default;  /* for types other and string */
  int   ival_default;  /* for types int and bool     */
  char *validsettings;		/* documentation of valid settings */
  char *docstring;		/* documentation of valid settings */
  void *val;                    /* current value */
  int  (*validate_fn)(struct _owl_variable *v, void *newval);
                                /* returns 1 if newval is valid */
  int  (*set_fn)(struct _owl_variable *v, void *newval); 
                                /* sets the variable to a value
				 * of the appropriate type.
				 * unless documented, this 
				 * should make a copy. 
				 * returns 0 on success. */
  int  (*set_fromstring_fn)(struct _owl_variable *v, char *newval);
                                /* sets the variable to a value
				 * of the appropriate type.
				 * unless documented, this 
				 * should make a copy. 
				 * returns 0 on success. */
  void *(*get_fn)(struct _owl_variable *v);
				/* returns a reference to the current value.
				 * WARNING:  this approach is hard to make
				 * thread-safe... */
  int  (*get_tostring_fn)(struct _owl_variable *v, 
			  char *buf, int bufsize, void *val); 
                                /* converts val to a string 
				 * and puts into buf */
  void  (*free_fn)(struct _owl_variable *v);
				/* frees val as needed */
} owl_variable;

typedef struct _owl_fmtext {
  int textlen;
  char *textbuff;
  char *fmbuff;
} owl_fmtext;

typedef struct _owl_list {
  int size;
  int avail;
  void **list;
} owl_list;

typedef struct _owl_dict_el {
  char *k;			/* key   */
  void *v;			/* value */
} owl_dict_el;

typedef struct _owl_dict {
  int size;
  int avail;
  owl_dict_el *els;		/* invariant: sorted by k */
} owl_dict;

typedef owl_dict owl_vardict;

typedef struct _owl_zwrite {
  char class[LINE];
  char inst[LINE];
  char realm[LINE];
  char opcode[LINE];
  owl_list recips;
  int cc;
  int noping;
} owl_zwrite;

typedef struct _owl_message {
  int id;
  int type;
  int admintype;
  ZNotice_t notice;
  owl_fmtext fmtext;
  int delete;
  char hostname[MAXHOSTNAMELEN];
  char *sender;
  char *recip;
  char *class;
  char *inst;
  char *opcode;
  char *time;
  char *realm;
  char *body;
  char *zwriteline;
} owl_message;

typedef struct _owl_mainwin {
  int curtruncated;
  int lastdisplayed;
} owl_mainwin;

typedef struct _owl_editwin {
  char *buff;
  int bufflen;
  int allocated;
  int buffx, buffy;
  int topline;
  int winlines, wincols, fillcol;
  WINDOW *curswin;
  int style;
  int lock;
  int dotsend;
} owl_editwin;

typedef struct _owl_viewwin {
  owl_fmtext fmtext;
  int textlines;
  int topline;
  int rightshift;
  int winlines, wincols;
  WINDOW *curswin;
} owl_viewwin;
  
typedef struct _owl_popwin {
  WINDOW *borderwin;
  WINDOW *popwin;
  int lines;
  int cols;
  int active;
  int needsfirstrefresh;
  void (*handler) (int ch);
} owl_popwin;

typedef struct _owl_messagelist {
  owl_list list;
} owl_messagelist;

typedef struct _owl_regex {
  int negate;
  char *string;
  regex_t re;
} owl_regex;

typedef struct _owl_filterelement {
  int type;
  char *field;
  owl_regex re;
} owl_filterelement;

typedef struct _owl_filter {
  char *name;
  int polarity;
  owl_list fes; /* filterelements */
} owl_filter;

typedef struct _owl_view {
  owl_filter *filter;
  owl_messagelist ml;
} owl_view;

typedef struct _owl_history {
  owl_list hist;
  int cur;
  int touched;
  int partial;
} owl_history;

typedef struct _owl_global {
  owl_mainwin mw;
  owl_popwin pw;
  owl_history hist;
  owl_list filterlist;
  owl_vardict vars;
  int mode;
  int lines, cols;
  int curmsg, topmsg;
  int curmsg_vert_offset;
  owl_view current_view;
  owl_messagelist msglist;
  WINDOW *recwin, *sepwin, *msgwin, *typwin;
  int needrefresh;
  int rightshift;
  int resizepending;
  int recwinlines;
  int typwinactive;
  char thishost[LINE];
  char thistty[LINE];
  char homedir[LINE];
  int direction;
  int zaway;
  char *cur_zaway_msg;
  int haveconfig;
  int config_format;
  char buffercommand[1024];
  owl_editwin tw;
  owl_viewwin vw;
  void *perl;
  int debug;
  int starttime;
  char startupargs[LINE];
  int userclue;
  int nextmsgid;
  owl_filterelement fe_true;
  owl_filterelement fe_false;
  owl_filterelement fe_null;
} owl_global;

/* globals */
owl_global g;

#include "owl_prototypes.h"

/* these are missing from the zephyr includes for some reason */
int ZGetSubscriptions(ZSubscription_t *, int *);
int ZGetLocations(ZLocations_t *,int *);

#endif /* INC_OWL_H */
