/* -------------------------------- commands.c -------------------------------- */
void owl_process_command(char *buff);
void owl_command_info();
void owl_command_help(int argc, char **argv);
void owl_command_about();
void owl_command_version();
void owl_command_next();
void owl_command_prev();
void owl_command_next_notdeleted();
void owl_command_prev_notdeleted();
void owl_command_delete_cur();
void owl_command_undelete_curmsg();
void owl_command_expunge();
void owl_command_first();
void owl_command_last();
void owl_command_resize();
void owl_command_shift_right();
void owl_command_shift_left();
void owl_command_unsuball();
void owl_command_loadsubs(int argc, char **argv);
void owl_command_zwrite_setup(char *line);
void owl_command_zwrite(char *line);
void owl_command_suspend();
void owl_command_zaway(int argc, char **argv);
void owl_command_set(int argc, char **argv);
void owl_command_print(int argc, char **argv);
void owl_command_exec(int argc, char **argv);
void owl_command_pexec(int argc, char **argv);
void owl_command_aexec(int argc, char **argv);
void owl_command_perl(int argc, char **argv, char *buff);
void owl_command_pperl(int argc, char **argv, char *buff);
void owl_command_aperl(int argc, char **argv, char *buff);
void owl_command_quit();
void owl_command_debug(int argc, char **argv);
void owl_command_ktest(int argc, char **argv);
void owl_command_zlog(int argc, char **argv);
void owl_command_zlog_out();
void owl_command_subscribe(int argc, char **argv);
void owl_command_unsubscribe(int argc, char **argv);
void owl_command_echo(int argc, char **argv);
void owl_command_getsubs();
void owl_command_status();
void owl_command_reply();
void owl_command_replytosender();
void owl_command_editreply();
void owl_command_editreplytosender();
void owl_command_filter(int argc, char **argv);
void owl_command_zlocate(int argc, char **argv);
void owl_command_view(int argc, char **argv);
void owl_command_show(int argc, char **argv);
void owl_command_viewclass(int argc, char **argv);
void owl_command_viewuser(int argc, char **argv);
void owl_command_delete(int argc, char **argv);
void owl_command_beep();

/* -------------------------------- dict.c -------------------------------- */
int owl_dict_create(owl_dict *d);
int owl_dict_get_size(owl_dict *d);
int _owl_dict_find_pos(owl_dict *d, char *k, int *pos);
void *owl_dict_find_element(owl_dict *d, char *k);
int owl_dict_get_keys(owl_dict *d, owl_list *l);
int owl_dict_insert_element(owl_dict *d, char *k, void *v, int replace);
void *owl_dict_remove_element(owl_dict *d, char *k);
void owl_dict_free_all(owl_dict *d, void (*elefree)(void *));
void owl_dict_free_simple(owl_dict *d);
int owl_dict_regtest(void);

/* -------------------------------- editwin.c -------------------------------- */
void owl_editwin_init(owl_editwin *e, WINDOW *win, int winlines, int wincols, int style);
void owl_editwin_set_curswin(owl_editwin *e, WINDOW *w, int winlines, int wincols);
void owl_editwin_set_dotsend(owl_editwin *e);
void owl_editwin_set_locktext(owl_editwin *e, char *text);
int owl_editwin_get_style(owl_editwin *e);
void owl_editwin_new_style(owl_editwin *e, int newstyle);
void owl_editwin_fullclear(owl_editwin *e);
void owl_editwin_clear(owl_editwin *e);
void _owl_editwin_addspace(owl_editwin *e);
void owl_editwin_recenter(owl_editwin *e);
void owl_editwin_redisplay(owl_editwin *e, int update);
int _owl_editwin_linewrap_word(owl_editwin *e);
void owl_editwin_insert_char(owl_editwin *e, char c);
void owl_editwin_overwrite_char(owl_editwin *e, char c);
void owl_editwin_delete_char(owl_editwin *e);
void owl_editwin_insert_string(owl_editwin *e, char *string);
void owl_editwin_overwrite_string(owl_editwin *e, char *string);
int _owl_editwin_get_index_from_xy(owl_editwin *e);
void _owl_editwin_set_xy_by_index(owl_editwin *e, int index);
void owl_editwin_adjust_for_locktext(owl_editwin *e);
void owl_editwin_backspace(owl_editwin *e);
void owl_editwin_key_up(owl_editwin *e);
void owl_editwin_key_down(owl_editwin *e);
void owl_editwin_key_left(owl_editwin *e);
void owl_editwin_key_right(owl_editwin *e);
void owl_editwin_move_to_nextword(owl_editwin *e);
void owl_editwin_move_to_previousword(owl_editwin *e);
void owl_editwin_delete_nextword(owl_editwin *e);
void owl_editwin_delete_to_endofline(owl_editwin *e);
void owl_editwin_move_to_end(owl_editwin *e);
void owl_editwin_move_to_top(owl_editwin *e);
void owl_editwin_fill_paragraph(owl_editwin *e);
int owl_editwin_process_char(owl_editwin *e, int j);
char *owl_editwin_get_text(owl_editwin *e);
int owl_editwin_get_numchars_on_line(owl_editwin *e, int line);
int owl_editwin_get_numlines(owl_editwin *e);

/* -------------------------------- filter.c -------------------------------- */
int owl_filter_init_fromstring(owl_filter *f, char *name, char *string);
int owl_filter_init(owl_filter *f, char *name, int argc, char **argv);
char *owl_filter_get_name(owl_filter *f);
void owl_filter_set_polarity_match(owl_filter *f);
void owl_filter_set_polarity_unmatch(owl_filter *f);
int owl_filter_message_match(owl_filter *f, owl_message *m);
int _owl_filter_message_match_recurse(owl_filter *f, owl_message *m, owl_list *fes, int start, int end);
void owl_filter_print(owl_filter *f, char *out);
void owl_filter_free(owl_filter *f);

/* -------------------------------- filterelement.c -------------------------------- */
void owl_filterelement_create_null(owl_filterelement *fe);
void owl_filterelement_create_openbrace(owl_filterelement *fe);
void owl_filterelement_create_closebrace(owl_filterelement *fe);
void owl_filterelement_create_and(owl_filterelement *fe);
void owl_filterelement_create_or(owl_filterelement *fe);
void owl_filterelement_create_not(owl_filterelement *fe);
void owl_filterelement_create_true(owl_filterelement *fe);
void owl_filterelement_create_false(owl_filterelement *fe);
void owl_filterelement_create_re(owl_filterelement *fe, char *field, char *re);
void owl_filterelement_free(owl_filterelement *fe);
int owl_filterelement_is_null(owl_filterelement *fe);
int owl_filterelement_is_openbrace(owl_filterelement *fe);
int owl_filterelement_is_closebrace(owl_filterelement *fe);
int owl_filterelement_is_and(owl_filterelement *fe);
int owl_filterelement_is_or(owl_filterelement *fe);
int owl_filterelement_is_not(owl_filterelement *fe);
int owl_filterelement_is_true(owl_filterelement *fe);
int owl_filterelement_is_false(owl_filterelement *fe);
int owl_filterelement_is_re(owl_filterelement *fe);
owl_regex *owl_filterelement_get_re(owl_filterelement *fe);
char *owl_filterelement_get_field(owl_filterelement *fe);
int owl_filterelement_is_value(owl_filterelement *fe);
char *owl_filterelement_to_string(owl_filterelement *fe);

/* -------------------------------- fmtext.c -------------------------------- */
void owl_fmtext_init_null(owl_fmtext *f);
void _owl_fmtext_set_attr(owl_fmtext *f, int attr, int first, int last);
void owl_fmtext_append_attr(owl_fmtext *f, char *text, int attr);
void owl_fmtext_append_normal(owl_fmtext *f, char *text);
void owl_fmtext_append_bold(owl_fmtext *f, char *text);
void owl_fmtext_append_reverse(owl_fmtext *f, char *text);
void owl_fmtext_append_reversebold(owl_fmtext *f, char *text);
void owl_fmtext_addattr(owl_fmtext *f, int attr);
void owl_fmtext_append_ztext(owl_fmtext *f, char *text);
void owl_fmtext_append_fmtext(owl_fmtext *f, owl_fmtext *in, int start, int stop);
void owl_fmtext_print_plain(owl_fmtext *f, char *buff);
void owl_fmtext_curs_waddstr(owl_fmtext *f, WINDOW *w);
int owl_fmtext_truncate_lines(owl_fmtext *in, int aline, int lines, owl_fmtext *out);
void owl_fmtext_truncate_cols(owl_fmtext *in, int acol, int bcol, owl_fmtext *out);
int owl_fmtext_num_lines(owl_fmtext *f);
char *owl_fmtext_get_text(owl_fmtext *f);
void owl_fmtext_free(owl_fmtext *f);
void owl_fmtext_copy(owl_fmtext *dst, owl_fmtext *src);

/* -------------------------------- functions.c -------------------------------- */
void owl_function_adminmsg(char *header, char *body);
void owl_function_adminmsg_outgoing(char *header, char *body, char *zwriteline);
void owl_function_nextmsg();
void owl_function_prevmsg();
void owl_function_nextmsg_notdeleted();
void owl_function_prevmsg_notdeleted();
void owl_function_deletecur();
void owl_function_undeletecur();
void owl_function_expunge();
void owl_function_firstmsg();
void owl_function_lastmsg();
void owl_function_shift_right();
void owl_function_shift_left();
void owl_function_unsuball();
void owl_function_loadsubs(char *file);
void owl_function_suspend();
void owl_function_zaway_on();
void owl_function_zaway_off();
void owl_function_quit();
void owl_function_zlog_in();
void owl_function_zlog_out();
void owl_function_makemsg(char *fmt, ...);
void owl_function_openurl();
void owl_function_calculate_topmsg_old(int direction);
void owl_function_calculate_topmsg(int direction);
void owl_function_resize();
void owl_function_run_buffercommand();
void owl_function_debugmsg(char *fmt, ...);
void owl_function_refresh();
void owl_function_beep();
void owl_function_subscribe(char *class, char *inst, char *recip);
void owl_function_unsubscribe(char *class, char *inst, char *recip);
void owl_function_set_cursor(WINDOW *win);
void owl_function_full_redisplay();
void owl_function_popless_text(char *text);
void owl_function_popless_fmtext(owl_fmtext *fm);
void owl_function_about();
void owl_function_info();
void owl_function_curmsg_to_popwin();
void owl_function_page_curmsg(int step);
void owl_function_resize_typwin(int newsize);
void owl_function_typwin_grow();
void owl_function_typwin_shrink();
void owl_function_mainwin_pagedown();
void owl_function_mainwin_pageup();
void owl_function_getsubs();
void owl_function_printallvars();
void owl_function_delete_by_id(int id);
void owl_function_delete_automsgs();
void owl_function_next_personal();
void owl_function_prev_personal();
void owl_function_status();
void owl_function_reply(int type, int enter);
void owl_function_zlocate(char *user, int auth);
void owl_function_start_command(char *line);
void owl_function_exec(int argc, char **argv);
void owl_function_exec2(int argc, char **argv, int type);
void owl_function_perl(int argc, char **argv, char *buff, int type);
void owl_function_change_view(char *filtname);
void owl_function_create_filter(int argc, char **argv);
void owl_function_show_filters();
void owl_function_show_filter(char *name);
void owl_function_fastclassfilt(char *class);
void owl_function_fastuserfilt(char *user);
void owl_function_fastclassfilt_curclass();
void owl_function_fastuserfilt_curuser();
void owl_function_delete_curview_msgs();
void owl_function_smartnarrow();

/* -------------------------------- global.c -------------------------------- */
void owl_global_init(owl_global *g);
void _owl_global_setup_windows(owl_global *g);
int owl_global_get_mode(owl_global *g);
void owl_global_set_mode(owl_global *g, int mode);
int owl_global_get_lines(owl_global *g);
int owl_global_get_cols(owl_global *g);
int owl_global_get_recwin_lines(owl_global *g);
int owl_global_get_curmsg(owl_global *g);
void owl_global_set_curmsg(owl_global *g, int i);
int owl_global_get_topmsg(owl_global *g);
void owl_global_set_topmsg(owl_global *g, int i);
owl_mainwin *owl_global_get_mainwin(owl_global *g);
owl_popwin *owl_global_get_popwin(owl_global *g);
owl_messagelist *owl_global_get_msglist(owl_global *g);
WINDOW *owl_global_get_curs_recwin(owl_global *g);
WINDOW *owl_global_get_curs_sepwin(owl_global *g);
WINDOW *owl_global_get_curs_msgwin(owl_global *g);
WINDOW *owl_global_get_curs_typwin(owl_global *g);
owl_editwin *owl_global_get_typwin(owl_global *g);
void owl_global_set_buffercommand(owl_global *g, char *command);
char *owl_global_get_buffercommand(owl_global *g);
int owl_global_is_needrefresh(owl_global *g);
void owl_global_set_needrefresh(owl_global *g);
void owl_global_set_noneedrefresh(owl_global *g);
owl_vardict *owl_global_get_vardict(owl_global *g);
void owl_global_set_rightshift(owl_global *g, int i);
int owl_global_get_rightshift(owl_global *g);
int owl_global_is_typwin_active(owl_global *g);
void owl_global_set_typwin_active(owl_global *g);
void owl_global_set_typwin_inactive(owl_global *g);
void owl_global_set_resize_pending(owl_global *g);
char *owl_global_get_homedir(owl_global *g);
int owl_global_get_direction(owl_global *g);
void owl_global_set_direction_downwards(owl_global *g);
void owl_global_set_direction_upwards(owl_global *g);
void owl_global_set_perlinterp(owl_global *g, void *p);
void *owl_global_get_perlinterp(owl_global *g);
int owl_global_is_config_format(owl_global *g);
void owl_global_set_config_format(owl_global *g, int state);
void owl_global_set_have_config(owl_global *g);
void owl_global_set_no_have_config(owl_global *g);
int owl_global_have_config(owl_global *g);
void owl_global_resize(owl_global *g, int x, int y);
void owl_global_set_tty(owl_global *g, char *tty);
int owl_global_is_debug_fast(owl_global *g);
time_t owl_global_get_starttime(owl_global *g);
time_t owl_global_get_runtime(owl_global *g);
void owl_global_get_runtime_string(owl_global *g, char *buff);
void owl_global_set_userclue(owl_global *g, int clue);
void owl_global_add_userclue(owl_global *g, int clue);
int owl_global_get_userclue(owl_global *g);
int owl_global_is_userclue(owl_global *g, int clue);
owl_viewwin *owl_global_get_viewwin(owl_global *g);
int owl_global_get_curmsg_vert_offset(owl_global *g);
void owl_global_set_curmsg_vert_offset(owl_global *g, int i);
void owl_global_set_startupargs(owl_global *g, int argc, char **argv);
char *owl_global_get_startupargs(owl_global *g);
owl_history *owl_global_get_history(owl_global *g);
owl_list *owl_global_get_filterlist(owl_global *g);
owl_filter *owl_global_get_filter(owl_global *g, char *name);
void owl_global_add_filter(owl_global *g, owl_filter *f);
void owl_global_remove_filter(owl_global *g, char *name);
int owl_global_get_nextmsgid(owl_global *g);
owl_view *owl_global_get_current_view(owl_global *g);
owl_filterelement *owl_global_get_filterelement_true(owl_global *g);
owl_filterelement *owl_global_get_filterelement_false(owl_global *g);
owl_filterelement *owl_global_get_filterelement_null(owl_global *g);

/* -------------------------------- help.c -------------------------------- */
void owl_help();
void owl_help_zlog();
void owl_help_quit();
void owl_help_zwrite();
void owl_help_reply();
void owl_help_set();
void owl_help_print();
void owl_help_version();
void owl_help_subscribe();
void owl_help_unsubscribe();
void owl_help_unsuball();
void owl_help_getsubs();
void owl_help_info();
void owl_help_help();
void owl_help_next();
void owl_help_prev();
void owl_help_next_notdel();
void owl_help_prev_notdel();
void owl_help_expunge();
void owl_help_first();
void owl_help_last();
void owl_help_resize();
void owl_help_suspend();
void owl_help_exec();
void owl_help_aexec();
void owl_help_pexec();
void owl_help_perl();
void owl_help_aperl();
void owl_help_pperl();
void owl_help_zaway();
void owl_help_load_subs();
void owl_help_about();
void owl_help_status();
void owl_help_zlocate();
void owl_help_filter();
void owl_help_view();
void owl_help_viewclass();
void owl_help_viewuser();
void owl_help_show();
void owl_help_delete();
void owl_help_beep();

/* -------------------------------- history.c -------------------------------- */
void owl_history_init(owl_history *h);
char *owl_history_get_prev(owl_history *h);
char *owl_history_get_next(owl_history *h);
void owl_history_store(owl_history *h, char *line);
void owl_history_set_partial(owl_history *h);
void owl_history_reset(owl_history *h);
int owl_history_is_touched(owl_history *h);

/* -------------------------------- keys.c -------------------------------- */
void owl_process_key(int j);

/* -------------------------------- list.c -------------------------------- */
int owl_list_create(owl_list *l);
int owl_list_get_size(owl_list *l);
void *owl_list_get_element(owl_list *l, int n);
int owl_list_append_element(owl_list *l, void *element);
int owl_list_prepend_element(owl_list *l, void *element);
int owl_list_remove_element(owl_list *l, int n);
int owl_list_replace_element(owl_list *l, int n, void *element);
void owl_list_free_all(owl_list *l, void (*elefree)(void *));
void owl_list_free_simple(owl_list *l);

/* -------------------------------- logging.c -------------------------------- */
void owl_log_outgoing(char *to, char *text);
void owl_log_incoming(owl_message *m);

/* -------------------------------- mainwin.c -------------------------------- */
void owl_mainwin_init(owl_mainwin *mw);
void owl_mainwin_redisplay(owl_mainwin *mw);
int owl_mainwin_is_curmsg_truncated(owl_mainwin *mw);
int owl_mainwin_get_last_msg(owl_mainwin *mw);

/* -------------------------------- message.c -------------------------------- */
void owl_message_create_admin(owl_message *m, char *header, char *text);
void owl_message_create_from_zephyr(owl_message *m, ZNotice_t *n);
void _owl_message_make_text_from_config(owl_message *m);
void _owl_message_make_text_from_notice(owl_message *m);
void _owl_message_get_zsig(owl_message *m, char *buff, int size);
int owl_message_get_numlines(owl_message *m);
void owl_message_mark_delete(owl_message *m);
void owl_message_unmark_delete(owl_message *m);
int owl_message_set_admintype(owl_message *m, int admintype);
int owl_message_get_admintype(owl_message *m);
void owl_message_set_admin_outgoing(owl_message *m, char *zwriteline);
char *owl_message_get_zwriteline(owl_message *m);
int owl_message_is_delete(owl_message *m);
ZNotice_t *owl_message_get_notice(owl_message *m);
void owl_message_free(owl_message *m);
char *owl_message_get_hostname(owl_message *m);
void owl_message_curs_waddstr(owl_message *m, WINDOW *win, int aline, int bline, int acol, int bcol);
owl_fmtext *owl_message_get_fmtext(owl_message *m);
void owl_message_set_class(owl_message *m, char *class);
char *owl_message_get_class(owl_message *m);
void owl_message_set_instance(owl_message *m, char *inst);
char *owl_message_get_instance(owl_message *m);
void owl_message_set_sender(owl_message *m, char *sender);
char *owl_message_get_sender(owl_message *m);
void owl_message_set_recipient(owl_message *m, char *recip);
char *owl_message_get_recipient(owl_message *m);
void owl_message_set_realm(owl_message *m, char *realm);
char *owl_message_get_realm(owl_message *m);
void owl_message_set_opcode(owl_message *m, char *opcode);
char *owl_message_get_opcode(owl_message *m);
char *owl_message_get_timestr(owl_message *m);
int owl_message_is_admin(owl_message *m);
int owl_message_is_zephyr(owl_message *m);
char *owl_message_get_text(owl_message *m);
char *owl_message_get_body(owl_message *m);
int owl_message_is_personal(owl_message *m);
int owl_message_is_private(owl_message *m);
int owl_message_is_mail(owl_message *m);
int owl_message_is_ping(owl_message *m);
int owl_message_is_login(owl_message *m);
int owl_message_is_burningears(owl_message *m);
int owl_message_get_id(owl_message *m);

/* -------------------------------- messagelist.c -------------------------------- */
int owl_messagelist_create(owl_messagelist *ml);
int owl_messagelist_get_size(owl_messagelist *ml);
void *owl_messagelist_get_element(owl_messagelist *ml, int n);
owl_message *owl_messagelist_get_by_id(owl_messagelist *ml, int id);
int owl_messagelist_append_element(owl_messagelist *ml, void *element);
int owl_messagelist_delete_element(owl_messagelist *ml, int n);
int owl_messagelist_undelete_element(owl_messagelist *ml, int n);
int owl_messagelist_expunge(owl_messagelist *ml);

/* -------------------------------- owl.c -------------------------------- */
int main(int argc, char **argv, char **env);
void sig_handler(int sig);
void usage();

/* -------------------------------- popwin.c -------------------------------- */
int owl_popwin_init(owl_popwin *pw);
int owl_popwin_up(owl_popwin *pw);
int owl_popwin_display_text(owl_popwin *pw, char *text);
int owl_popwin_getch(owl_popwin *pw);
int owl_popwin_close(owl_popwin *pw);
int owl_popwin_is_active(owl_popwin *pw);
int owl_popwin_refresh(owl_popwin *pw);
void owl_popwin_set_handler(owl_popwin *pw, void (*func)(int ch));
void owl_popwin_unset_handler(owl_popwin *pw);
WINDOW *owl_popwin_get_curswin(owl_popwin *pw);
int owl_popwin_get_lines(owl_popwin *pw);
int owl_popwin_get_cols(owl_popwin *pw);
int owl_popwin_needs_first_refresh(owl_popwin *pw);
void owl_popwin_no_needs_first_refresh(owl_popwin *pw);

/* -------------------------------- readconfig.c -------------------------------- */
int owl_readconfig(char *file);
char *owl_config_execute(char *line);
char *owl_config_getmsg(owl_message *m, int mode);

/* -------------------------------- regex.c -------------------------------- */
void owl_regex_init(owl_regex *re);
int owl_regex_create(owl_regex *re, char *string);
int owl_regex_compare(owl_regex *re, char *string);
int owl_regex_is_set(owl_regex *re);
char *owl_regex_get_string(owl_regex *re);
void owl_regex_copy(owl_regex *a, owl_regex *b);
void owl_regex_free(owl_regex *re);

/* -------------------------------- tester.c -------------------------------- */
void screeninit();
void test1();
void test2(char *in);
void test3();
void test4();
int main(int argc, char **argv, char **env);

/* -------------------------------- text.c -------------------------------- */
int owl_text_truncate_lines(char *out, char *in, int aline, int lines);
void owl_text_truncate_cols(char *out, char *in, int acol, int bcol);
void owl_text_indent(char *out, char *in, int n);
int owl_text_num_lines(char *in);

/* -------------------------------- util.c -------------------------------- */
void sepbar(char *in);
void pophandler_quit(int ch);
void pophandler_viewwin(int ch);
char **atokenize(char *buffer, char *sep, int *i);
void atokenize_free(char **tok, int nels);
void owl_parsefree(char **argv, int argc);
char **owl_parseline(char *line, int *argc);
int owl_util_find_trans(char *in, int len);
void downstr(char *foo);
char *stristr(char *a, char *b);
void *owl_malloc(size_t size);
void owl_free(void *ptr);
char *owl_strdup(const char *s1);
void *owl_realloc(void *ptr, size_t size);
char *pretty_sender(char *in);
char *long_sender(char *in);
char *owl_getquoting(char *line);

/* -------------------------------- variable.c -------------------------------- */
int owl_variable_int_validate_gt0(owl_variable *v, void *newval);
int owl_variable_int_validate_positive(owl_variable *v, void *newval);
int owl_variable_typewinsize_set(owl_variable *v, void *newval);
int owl_variable_debug_set(owl_variable *v, void *newval);
int owl_variable_dict_setup(owl_vardict *vd);
void owl_variable_dict_free(owl_vardict *d);
void owl_variable_dict_get_names(owl_vardict *d, owl_list *l);
void owl_variable_dict_namelist_free(owl_list *l);
void owl_variable_free(owl_variable *v);
char *owl_variable_get_docstring(owl_variable *v);
char *owl_variable_get_validsettings(owl_variable *v);
int owl_variable_set_fromstring(owl_vardict *d, char *name, char *value, int msg);
int owl_variable_set_string(owl_vardict *d, char *name, char *newval);
int owl_variable_set_int(owl_vardict *d, char *name, int newval);
int owl_variable_set_bool_on(owl_vardict *d, char *name);
int owl_variable_set_bool_off(owl_vardict *d, char *name);
int owl_variable_get_tostring(owl_vardict *d, char *name, char *buf, int bufsize);
int owl_variable_get_default_tostring(owl_vardict *d, char *name, char *buf, int bufsize);
void *owl_variable_get(owl_vardict *d, char *name, int require_type);
char *owl_variable_get_string(owl_vardict *d, char *name);
void *owl_variable_get_other(owl_vardict *d, char *name);
int owl_variable_get_int(owl_vardict *d, char *name);
int owl_variable_get_bool(owl_vardict *d, char *name);
int owl_variable_get_helpheader(char *buf, int buflen);
int owl_variable_get_help(owl_vardict *d, char *name, char *buf, int buflen);
void *owl_variable_get_default(owl_variable *v);
void owl_variable_free_default(owl_variable *v);
int owl_variable_bool_validate_default(owl_variable *v, void *newval);
int owl_variable_bool_set_default(owl_variable *v, void *newval);
int owl_variable_bool_set_fromstring_default(owl_variable *v, char *newval);
int owl_variable_bool_get_tostring_default(owl_variable *v, char* buf, int bufsize, void *val);
int owl_variable_int_validate_default(owl_variable *v, void *newval);
int owl_variable_int_set_default(owl_variable *v, void *newval);
int owl_variable_int_set_fromstring_default(owl_variable *v, char *newval);
int owl_variable_int_get_tostring_default(owl_variable *v, char* buf, int bufsize, void *val);
int owl_variable_enum_validate(owl_variable *v, void *newval);  
int owl_variable_enum_set_fromstring(owl_variable *v, char *newval);
int owl_variable_enum_get_tostring(owl_variable *v, char* buf, int bufsize, void *val);
int owl_variable_string_validate_default(struct _owl_variable *v, void *newval);
int owl_variable_string_set_default(owl_variable *v, void *newval);
int owl_variable_string_set_fromstring_default(owl_variable *v, char *newval);
int owl_variable_string_get_tostring_default(owl_variable *v, char* buf, int bufsize, void *val);
int owl_variable_regtest(void);

/* -------------------------------- varstubs.c -------------------------------- */
void owl_global_set_personalbell_on(owl_global *g);
void owl_global_set_personalbell_off(owl_global *g);
int owl_global_is_personalbell(owl_global *g);
void owl_global_set_bell_on(owl_global *g);
void owl_global_set_bell_off(owl_global *g);
int owl_global_is_bell(owl_global *g);
void owl_global_set_debug_on(owl_global *g);
void owl_global_set_debug_off(owl_global *g);
int owl_global_is_debug(owl_global *g);
void owl_global_set_startuplogin_on(owl_global *g);
void owl_global_set_startuplogin_off(owl_global *g);
int owl_global_is_startuplogin(owl_global *g);
void owl_global_set_shutdownlogout_on(owl_global *g);
void owl_global_set_shutdownlogout_off(owl_global *g);
int owl_global_is_shutdownlogout(owl_global *g);
void owl_global_set_rxping_on(owl_global *g);
void owl_global_set_rxping_off(owl_global *g);
int owl_global_is_rxping(owl_global *g);
void owl_global_set_txping_on(owl_global *g);
void owl_global_set_txping_off(owl_global *g);
int owl_global_is_txping(owl_global *g);
void owl_global_set_displayoutgoing_on(owl_global *g);
void owl_global_set_displayoutgoing_off(owl_global *g);
int owl_global_is_displayoutgoing(owl_global *g);
void owl_global_set_loginsubs_on(owl_global *g);
void owl_global_set_loginsubs_off(owl_global *g);
int owl_global_is_loginsubs(owl_global *g);
void owl_global_set_logging_on(owl_global *g);
void owl_global_set_logging_off(owl_global *g);
int owl_global_is_logging(owl_global *g);
void owl_global_set_classlogging_on(owl_global *g);
void owl_global_set_classlogging_off(owl_global *g);
int owl_global_is_classlogging(owl_global *g);
void owl_global_set_lockout_ctrld_on(owl_global *g);
void owl_global_set_lockout_ctrld_off(owl_global *g);
int owl_global_is_lockout_ctrld(owl_global *g);
void owl_global_set_burningears_on(owl_global *g);
void owl_global_set_burningears_off(owl_global *g);
int owl_global_is_burningears(owl_global *g);
void owl_global_set_summarymode_on(owl_global *g);
void owl_global_set_summarymode_off(owl_global *g);
int owl_global_is_summarymode(owl_global *g);
void owl_global_set_logpath(owl_global *g, char *text);
char *owl_global_get_logpath(owl_global *g);
void owl_global_set_classlogpath(owl_global *g, char *text);
char *owl_global_get_classlogpath(owl_global *g);
void owl_global_set_debug_file(owl_global *g, char *text);
char *owl_global_get_debug_file(owl_global *g);
void owl_global_set_zsig_exec(owl_global *g, char *text);
char *owl_global_get_zsig_exec(owl_global *g);
void owl_global_set_zsig(owl_global *g, char *text);
char *owl_global_get_zsig(owl_global *g);
void owl_global_set_appendtosepbar(owl_global *g, char *text);
char *owl_global_get_appendtosepbar(owl_global *g);
void owl_global_set_zaway_on(owl_global *g);
void owl_global_set_zaway_off(owl_global *g);
int owl_global_is_zaway(owl_global *g);
void owl_global_set_zaway_msg(owl_global *g, char *text);
char *owl_global_get_zaway_msg(owl_global *g);
void owl_global_set_zaway_msg_default(owl_global *g, char *text);
char *owl_global_get_zaway_msg_default(owl_global *g);
void owl_global_set_view_home(owl_global *g, char *text);
char *owl_global_get_view_home(owl_global *g);
void owl_global_set_typwin_lines(owl_global *g, int n);
int owl_global_get_typwin_lines(owl_global *g);
void owl_global_set_webbrowser(owl_global *g, int n);
int owl_global_get_webbrowser(owl_global *g);

/* -------------------------------- view.c -------------------------------- */
void owl_view_create(owl_view *v, owl_filter *f);
void owl_view_consider_message(owl_view *v, owl_message *m);
void owl_view_recalculate(owl_view *v);
owl_message *owl_view_get_element(owl_view *v, int index);
void owl_view_delete_element(owl_view *v, int index);
void owl_view_undelete_element(owl_view *v, int index);
int owl_view_get_size(owl_view *v);
char *owl_view_get_filtname(owl_view *v);
void owl_view_free(owl_view *v);

/* -------------------------------- viewwin.c -------------------------------- */
void owl_viewwin_init_text(owl_viewwin *v, WINDOW *win, int winlines, int wincols, char *text);
void owl_viewwin_init_fmtext(owl_viewwin *v, WINDOW *win, int winlines, int wincols, owl_fmtext *fmtext);
void owl_viewwin_set_curswin(owl_viewwin *v, WINDOW *w, int winlines, int wincols);
void owl_viewwin_redisplay(owl_viewwin *v, int update);
void owl_viewwin_pagedown(owl_viewwin *v);
void owl_viewwin_linedown(owl_viewwin *v);
void owl_viewwin_pageup(owl_viewwin *v);
void owl_viewwin_lineup(owl_viewwin *v);
void owl_viewwin_right(owl_viewwin *v, int n);
void owl_viewwin_left(owl_viewwin *v, int n);
void owl_viewwin_top(owl_viewwin *v);
void owl_viewwin_bottom(owl_viewwin *v);
void owl_viewwin_free(owl_viewwin *v);
void owl_viewwin_process_key(owl_viewwin *v, int j);

/* -------------------------------- zephyr.c -------------------------------- */
int loadsubs(char *filename);
int loadloginsubs(char *filename);
void unsuball();
int owl_zephyr_sub(char *class, char *inst, char *recip);
int owl_zephyr_unsub(char *class, char *inst, char *recip);
void zlog_in();
void zlog_out();
char *owl_zephyr_get_field(ZNotice_t *n, int j, int *k);
int owl_zephyr_get_num_fields(ZNotice_t *n);
char *owl_zephyr_get_message(ZNotice_t *n, int *k);
char *owl_zephyr_get_zsig(ZNotice_t *n, int *k);
int send_zephyr(char *opcode, char *zsig, char *class, char *instance, char *recipient, char *message);
Code_t send_zephyr_helper(ZNotice_t *notice, char *buf, int len, int wait);
void send_ping(char *to);
void owl_zephyr_handle_ack(ZNotice_t *retnotice);
int owl_zephyr_notice_is_ack(ZNotice_t *n);
void owl_zephyr_zaway(owl_message *m);
void owl_zephyr_hackaway_cr(ZNotice_t *n);
void owl_zephyr_zlocate(char *user, char *out, int auth);

/* -------------------------------- zwrite.c -------------------------------- */
int owl_zwrite_create_from_line(owl_zwrite *z, char *line);
void owl_zwrite_send_ping(owl_zwrite *z);
void owl_zwrite_send_message(owl_zwrite *z, char *msg);
char *owl_zwrite_get_class(owl_zwrite *z);
char *owl_zwrite_get_instance(owl_zwrite *z);
char *owl_zwrite_get_realm(owl_zwrite *z);
void owl_zwrite_get_recipstr(owl_zwrite *z, char *buff);
int owl_zwrite_get_numrecips(owl_zwrite *z);
char *owl_zwrite_get_recip_n(owl_zwrite *z, int n);
int owl_zwrite_is_personal(owl_zwrite *z);
void owl_zwrite_free(owl_zwrite *z);

