#include "defs.h"

#include "accumulation.h"

#include <math.h>

int compare_doubles (const double *a,const double *b)
{
  if (*a>*b)
    return 1;
  else
    if (*a<*b)
      return -1;
    else 
      return 0;
}

/* ensure size>=nneighbors */
double guess_accumulation(int size,double *alpha,int nneighbors)
{
  int k;
  double delta,deltamin;
  int kdeltamin=0;
  
  qsort(alpha,size,sizeof(double),(comparison_fn_t)compare_doubles);

  deltamin=DBL_MAX;
  for (k=0;k<size-nneighbors+1;k++) 
    {
      delta=alpha[k+nneighbors-1]-alpha[k];
      if (delta<deltamin)
	{
	  deltamin=delta;
	  kdeltamin=k;
	}
    }
  
  return alpha[kdeltamin+nneighbors/2];
}
