#include "defs.h"

#include "path.h"
#include "categorical_classifiers.h"

#include <math.h>

/* here is the table of pertinent categorical classifiers
   i would like them to be font independent, scaling independent.
   can be rotation dependent */
categorical_classifier CC[] =
        {
	  { nholes, "NHOLES" },
	  { underbaseline, "UNDERBASELINE" },
	  { overxline, "OVERXLINE" },
	  { vfuret, "VFURET" },
	  { hfuret, "HFURET" }
        };
int nCC = sizeof(CC)/sizeof(CC[0]);

CATEGORICAL_CLASSIFIER(nholes)
{
  int n=0;
  lop *U;
  for (U=P->holes;U;U=U->next) n++;
  
  return n;
}

CATEGORICAL_CLASSIFIER(underbaseline)
{
  double u;
  
  u=(P->bottom-baseline)/(P->bottom-P->top);
  
  if ((0.2<u)&&(u<1)) return 1;
  if ((-1<u)&&(u<-0.2)) return 2;
  return 0;
}

CATEGORICAL_CLASSIFIER(overxline)
{
  double u;
  
  u=(xline-P->top)/(P->bottom-P->top);

  if ((0.2<u)&&(u<1)) return 1;
  if ((-1<u)&&(u<-0.2)) return 2;
  return 0;
}

static void compute_angles(path *P,double *angles);

CATEGORICAL_CLASSIFIER(nbends)
{
  double *angles;

  MYOWN_MALLOC(angles,double,P->length);
  compute_angles(P,angles);
  MYOWN_FREE(angles,double,P->length);

  return 0; /* HACK not finished yet --- when finished, add it in the table */ 
}

double variangle(double x1,double y1,double x2,double y2,double x3,double y3)
{
  double u;
  
  u=atan2(y3-y2,x3-x2)-atan2(y2-y1,x2-x1);
  if (u>M_PI) u-=M_PI*2;
  if (u<-M_PI) u+=M_PI*2;

  return u;
}
  
void compute_angles(path *P,double *angles)
{
  /* not very optimized but clear */
  
#define SIGNIFICANTBEND 10
  
  int i;
  pair *u,*pu,*ppu;
  double x1,y1,x2,y2,x3,y3;
  DECLARE_UNINITIALIZED(double,firstx);
  DECLARE_UNINITIALIZED(double,firsty);
  DECLARE_UNINITIALIZED(double,secondx);
  DECLARE_UNINITIALIZED(double,secondy);

  ppu=NULL;
  pu=NULL;
  i=1;
  for (u=P->first;u;u=u->next)
    {
      if (ppu)
	{
	  x1=ppu->x;
	  y1=ppu->y;
	  x2=pu->x;
	  y2=pu->y;
	  x3=u->x;
	  y3=u->y;
	  angles[i]=variangle(x1,y1,x2,y2,x3,y3);
	  i++;
	}
      else
	{
	  if (pu)
	    {
	      secondx=u->x;
	      secondy=u->y;
	    }
	  else
	    {
	      firstx=u->x;
	      firsty=u->y;
	    }

	}
      ppu=pu;
      pu=u;
    }
  x1=ppu->x;
  y1=ppu->y;
  x2=pu->x;
  y2=pu->y;
  x3=firstx;
  y3=firsty;
  angles[i]=variangle(x1,y1,x2,y2,x3,y3);
  x1=pu->x;
  y1=pu->y;
  x2=firstx;
  y2=firsty;
  x3=secondx;
  y3=secondy;
  angles[0]=variangle(x1,y1,x2,y2,x3,y3);
}

#define OPPSGN(a, b)  ( ((a>0)&&(b<0)) || ((b>0)&&(a<0)) )

CATEGORICAL_CLASSIFIER(vfuret)
{
  pair *u,*pu;
  double x1,x2;
  int n=0;
  DECLARE_UNINITIALIZED(double,firstx);

  pu=NULL;
  for (u=P->first;u;u=u->next)
    {
      if (pu)
	{
	  x1=pu->x-P->xg;
	  x2=u->x-P->xg;
	  if (OPPSGN(x1,x2)) n++;
	}
      else
	  firstx=u->x;
      pu=u;
    }
  x1=pu->x-P->xg;
  x2=firstx-P->xg;
  if (OPPSGN(x1,x2)) n++;
  
  return n/2;
}

CATEGORICAL_CLASSIFIER(hfuret)
{
  pair *u,*pu;
  double y1,y2;
  int n=0;
  DECLARE_UNINITIALIZED(double,firsty);

  pu=NULL;
  for (u=P->first;u;u=u->next)
    {
      if (pu)
	{
	  y1=pu->y-P->yg;
	  y2=u->y-P->yg;
	  if (OPPSGN(y1,y2)) n++;
	}
      else
	  firsty=u->y;
      pu=u;
    }
  y1=pu->y-P->yg;
  y2=firsty-P->yg;
  if (OPPSGN(y1,y2)) n++;
  
  return n/2;
}
