#include "defs.h"

#include "matrix.h"
#include "path.h"
#include "xet.h"
#include "numerical_classifiers.h"
#include "categorical_classifiers.h"
#include "charax.h"

void charax_dump(top *T,tol *C)
{
  int i,j,k,index;
  double baseline,xline,spacing,averagespacing;

  printf("%%\"?\"\n");
  printf("%%column, var, type\n");

  printf("%%1  Class  d\n");
  for (i=0;i<nNC;i++)
    printf("%%%d  %s  n\n",i+2,NC[i].description);
  for (i=0;i<nCC;i++)
    printf("%%%d  %s  c\n",i+2+nNC,CC[i].description);
  
   for (k=0;k<C->size;k++)
    {
      printf("# %d-%d",k,C->table[k].length);
      if (k==0) printf(" (junkline)");
      printf("\n");

      /* estimate average spacing on line */
      averagespacing=0;
      for (i=0;i<C->table[k].length-1;i++)
	{
	  spacing=
	    (T->table+C->table[k].indices[i+1])->left-
	    (T->table+C->table[k].indices[i])->right;
	  averagespacing+=spacing;
	}
      averagespacing/=C->table[k].length-1;

      for (i=0;i<C->table[k].length;i++)
	{
	  index=C->table[k].indices[i];
	  baseline=C->table[k].baseline;
	  xline=C->table[k].xline;
	  for (j=0;j<nNC;j++)
	    printf("%.3f ",NC[j].f(T->table+index,baseline,xline));
	  for (j=0;j<nCC;j++)
	    printf("%d ",CC[j].f(T->table+index,baseline,xline));
	  printf("\n");

	  /* mark a space if there is one */
	  if (i<C->table[k].length-1)
	    {
	      spacing=
		(T->table+C->table[k].indices[i+1])->left-
		(T->table+C->table[k].indices[i])->right;
	      if (spacing>averagespacing) printf("S\n");
	    }
	}
    }
}





